/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsWorld;
import net.minecraft.gizmos.Gizmo;
import net.minecraft.gizmos.GizmoPrimitives;
import net.minecraft.gizmos.GizmoStyle;
import net.minecraft.gizmos.Gizmos;
import net.minecraft.util.ARGB;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.geometry.PxBoxGeometry;
import physx.geometry.PxCapsuleGeometry;
import physx.geometry.PxConvexMesh;
import physx.geometry.PxConvexMeshGeometry;
import physx.geometry.PxGeometry;
import physx.geometry.PxGeometryTypeEnum;
import physx.geometry.PxHullPolygon;
import physx.geometry.PxSphereGeometry;
import physx.physics.PxActor;
import physx.physics.PxActorFlagEnum;
import physx.physics.PxActorTypeEnum;
import physx.physics.PxActorTypeFlagEnum;
import physx.physics.PxActorTypeFlags;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxRigidDynamic;
import physx.physics.PxScene;
import physx.physics.PxShape;
import physx.support.NativeArrayHelpers;
import physx.support.PxArray_PxActorPtr;
import physx.support.PxArray_PxShapePtr;
import physx.support.PxU8ConstPtr;

public class DebugRenderer {
    private static final int KINEMATIC_COLOR = ARGB.colorFromFloat((float)0.5f, (float)0.5f, (float)1.0f, (float)0.5f);
    private static final int STATIC_COLOR = ARGB.colorFromFloat((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
    private static final int DYNAMIC_COLOR = ARGB.colorFromFloat((float)0.5f, (float)1.0f, (float)0.5f, (float)0.5f);
    private static final int DISABLED_COLOR = ARGB.colorFromFloat((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
    private List<Gizmo> activeGizmos = new ObjectArrayList();

    public void renderDebugGizmos() {
        if (!ConfigClient.renderPhysicsDebugOverlay) {
            return;
        }
        for (Gizmo gizmo : this.activeGizmos) {
            Gizmos.addGizmo((Gizmo)gizmo);
        }
    }

    public void createDebugGizmos(PhysicsWorld physics) {
        if (!ConfigClient.renderPhysicsDebugOverlay) {
            return;
        }
        this.activeGizmos.clear();
        Vector3d offset = physics.getOffset();
        PxScene scene = physics.getDynamicsWorld().getScene();
        PxActorTypeFlags flags = new PxActorTypeFlags((short)(PxActorTypeFlagEnum.eRIGID_DYNAMIC.value | PxActorTypeFlagEnum.eRIGID_STATIC.value));
        int actors = scene.getNbActors(flags);
        PxArray_PxActorPtr arrPtr = new PxArray_PxActorPtr(actors);
        scene.getActors(flags, arrPtr.begin(), actors, 0);
        for (int i = 0; i < actors; ++i) {
            PxActor actor = arrPtr.get(i);
            this.debugActor(actor, offset);
        }
        arrPtr.destroy();
        flags.destroy();
    }

    private void debugActor(PxActor actor, Vector3d offset) {
        PxActorTypeEnum actorType = actor.getType();
        if (actorType != PxActorTypeEnum.eRIGID_DYNAMIC && actorType != PxActorTypeEnum.eRIGID_STATIC) {
            return;
        }
        PxRigidActor rigidActor = PxRigidActor.wrapPointer(actor.getAddress());
        Matrix4f transform = this.fromPhysicsTransform(rigidActor.getGlobalPose());
        transform.m30((float)((double)transform.m30() + offset.x));
        transform.m31((float)((double)transform.m31() + offset.y));
        transform.m32((float)((double)transform.m32() + offset.z));
        int shapes = rigidActor.getNbShapes();
        PxArray_PxShapePtr arrPtr = new PxArray_PxShapePtr(shapes);
        rigidActor.getShapes(arrPtr.begin(), shapes, 0);
        int color = STATIC_COLOR;
        if (rigidActor.getActorFlags().isSet(PxActorFlagEnum.eDISABLE_SIMULATION)) {
            color = DISABLED_COLOR;
        } else if (actorType == PxActorTypeEnum.eRIGID_DYNAMIC) {
            color = DYNAMIC_COLOR;
            PxRigidDynamic dynamic = PxRigidDynamic.wrapPointer(actor.getAddress());
            if (dynamic.getRigidBodyFlags().isSet(PxRigidBodyFlagEnum.eKINEMATIC)) {
                color = KINEMATIC_COLOR;
            }
        }
        for (int i = 0; i < arrPtr.size(); ++i) {
            PxShape shape = arrPtr.get(i);
            PxGeometry geometry = shape.getGeometry();
            Matrix4f localTransform = this.fromPhysicsTransform(shape.getLocalPose());
            Matrix4f worldShapeTransform = transform.mul((Matrix4fc)localTransform, new Matrix4f());
            GizmoStyle style = GizmoStyle.fill((int)color);
            if (geometry.getType() == PxGeometryTypeEnum.eBOX) {
                PxBoxGeometry box = PxBoxGeometry.wrapPointer(geometry.getAddress());
                PxVec3 halfExtents = box.getHalfExtents();
                this.activeGizmos.add(new TransformedCuboidGizmo((Matrix4fc)worldShapeTransform, new AABB((double)(-halfExtents.getX()) - 0.01, (double)(-halfExtents.getY()) - 0.01, (double)(-halfExtents.getZ()) - 0.01, (double)halfExtents.getX() + 0.01, (double)halfExtents.getY() + 0.01, (double)halfExtents.getZ() + 0.01), style, false));
                continue;
            }
            if (geometry.getType() == PxGeometryTypeEnum.eSPHERE) {
                PxSphereGeometry sphere = PxSphereGeometry.wrapPointer(geometry.getAddress());
                float r = sphere.getRadius();
                this.activeGizmos.add(new TransformedSphereGizmo((Matrix4fc)worldShapeTransform, r, style));
                continue;
            }
            if (geometry.getType() == PxGeometryTypeEnum.eCAPSULE) {
                PxCapsuleGeometry capsule = PxCapsuleGeometry.wrapPointer(geometry.getAddress());
                float radius = capsule.getRadius();
                float halfHeight = capsule.getHalfHeight();
                this.activeGizmos.add(new TransformedCapsuleGizmo((Matrix4fc)worldShapeTransform, radius, halfHeight, style));
                continue;
            }
            if (geometry.getType() != PxGeometryTypeEnum.eCONVEXMESH) continue;
            PxConvexMeshGeometry convexMesh = PxConvexMeshGeometry.wrapPointer(geometry.getAddress());
            worldShapeTransform.scale(1.04f);
            this.activeGizmos.add(new TransformedConvexMeshGizmo((Matrix4fc)worldShapeTransform, convexMesh, style));
        }
        arrPtr.destroy();
    }

    private Matrix4f fromPhysicsTransform(PxTransform transform) {
        PxVec3 position = transform.getP();
        PxQuat rotation = transform.getQ();
        return new Matrix4f().translationRotate(position.getX(), position.getY(), position.getZ(), rotation.getX(), rotation.getY(), rotation.getZ(), rotation.getW());
    }

    public record TransformedCuboidGizmo(Matrix4fc transformation, AABB aabb, GizmoStyle style, boolean coloredCornerStroke) implements Gizmo
    {
        private Vec3 transform(double x, double y, double z) {
            Vector3f tmp = new Vector3f();
            this.transformation.transformPosition((float)x, (float)y, (float)z, tmp);
            return new Vec3((double)tmp.x(), (double)tmp.y(), (double)tmp.z());
        }

        public void emit(GizmoPrimitives gizmoPrimitives, float f) {
            int k;
            double minX = this.aabb.minX;
            double minY = this.aabb.minY;
            double minZ = this.aabb.minZ;
            double maxX = this.aabb.maxX;
            double maxY = this.aabb.maxY;
            double maxZ = this.aabb.maxZ;
            if (this.style.hasFill()) {
                k = this.style.multipliedFill(f);
                gizmoPrimitives.addQuad(this.transform(maxX, minY, minZ), this.transform(maxX, maxY, minZ), this.transform(maxX, maxY, maxZ), this.transform(maxX, minY, maxZ), k);
                gizmoPrimitives.addQuad(this.transform(minX, minY, minZ), this.transform(minX, minY, maxZ), this.transform(minX, maxY, maxZ), this.transform(minX, maxY, minZ), k);
                gizmoPrimitives.addQuad(this.transform(minX, minY, minZ), this.transform(minX, maxY, minZ), this.transform(maxX, maxY, minZ), this.transform(maxX, minY, minZ), k);
                gizmoPrimitives.addQuad(this.transform(minX, minY, maxZ), this.transform(maxX, minY, maxZ), this.transform(maxX, maxY, maxZ), this.transform(minX, maxY, maxZ), k);
                gizmoPrimitives.addQuad(this.transform(minX, maxY, minZ), this.transform(minX, maxY, maxZ), this.transform(maxX, maxY, maxZ), this.transform(maxX, maxY, minZ), k);
                gizmoPrimitives.addQuad(this.transform(minX, minY, minZ), this.transform(maxX, minY, minZ), this.transform(maxX, minY, maxZ), this.transform(minX, minY, maxZ), k);
            }
            if (this.style.hasStroke()) {
                k = this.style.multipliedStroke(f);
                gizmoPrimitives.addLine(this.transform(minX, minY, minZ), this.transform(maxX, minY, minZ), this.coloredCornerStroke ? ARGB.multiply((int)k, (int)-34953) : k, this.style.strokeWidth());
                gizmoPrimitives.addLine(this.transform(minX, minY, minZ), this.transform(minX, maxY, minZ), this.coloredCornerStroke ? ARGB.multiply((int)k, (int)-8913033) : k, this.style.strokeWidth());
                gizmoPrimitives.addLine(this.transform(minX, minY, minZ), this.transform(minX, minY, maxZ), this.coloredCornerStroke ? ARGB.multiply((int)k, (int)-8947713) : k, this.style.strokeWidth());
                gizmoPrimitives.addLine(this.transform(maxX, minY, minZ), this.transform(maxX, maxY, minZ), k, this.style.strokeWidth());
                gizmoPrimitives.addLine(this.transform(maxX, maxY, minZ), this.transform(minX, maxY, minZ), k, this.style.strokeWidth());
                gizmoPrimitives.addLine(this.transform(minX, maxY, minZ), this.transform(minX, maxY, maxZ), k, this.style.strokeWidth());
                gizmoPrimitives.addLine(this.transform(minX, maxY, maxZ), this.transform(minX, minY, maxZ), k, this.style.strokeWidth());
                gizmoPrimitives.addLine(this.transform(minX, minY, maxZ), this.transform(maxX, minY, maxZ), k, this.style.strokeWidth());
                gizmoPrimitives.addLine(this.transform(maxX, minY, maxZ), this.transform(maxX, minY, minZ), k, this.style.strokeWidth());
                gizmoPrimitives.addLine(this.transform(minX, maxY, maxZ), this.transform(maxX, maxY, maxZ), k, this.style.strokeWidth());
                gizmoPrimitives.addLine(this.transform(maxX, minY, maxZ), this.transform(maxX, maxY, maxZ), k, this.style.strokeWidth());
                gizmoPrimitives.addLine(this.transform(maxX, maxY, minZ), this.transform(maxX, maxY, maxZ), k, this.style.strokeWidth());
            }
        }
    }

    public record TransformedSphereGizmo(Matrix4fc transformation, float radius, GizmoStyle style) implements Gizmo
    {
        private Vec3 transform(float x, float y, float z) {
            Vector3f tmp = new Vector3f();
            this.transformation.transformPosition(x, y, z, tmp);
            return new Vec3((double)tmp.x(), (double)tmp.y(), (double)tmp.z());
        }

        public void emit(GizmoPrimitives gizmoPrimitives, float f) {
            int slice;
            int slices = 6;
            int stacks = 4;
            Vec3[][] grid = new Vec3[stacks + 1][slices];
            for (int stack = 0; stack <= stacks; ++stack) {
                double v = (double)stack / (double)stacks;
                double phi = -1.5707963267948966 + v * Math.PI;
                double cosPhi = Math.cos(phi);
                double sinPhi = Math.sin(phi);
                for (int slice2 = 0; slice2 < slices; ++slice2) {
                    double u = (double)slice2 / (double)slices;
                    double theta = u * (Math.PI * 2);
                    double cosTheta = Math.cos(theta);
                    double sinTheta = Math.sin(theta);
                    float x = (float)((double)this.radius * cosPhi * cosTheta);
                    float y = (float)((double)this.radius * sinPhi);
                    float z = (float)((double)this.radius * cosPhi * sinTheta);
                    grid[stack][slice2] = this.transform(x, y, z);
                }
            }
            if (this.style.hasFill()) {
                int fillColor = this.style.multipliedFill(f);
                for (int stack = 0; stack < stacks; ++stack) {
                    for (slice = 0; slice < slices; ++slice) {
                        int nextSlice = (slice + 1) % slices;
                        Vec3 v00 = grid[stack][slice];
                        Vec3 v01 = grid[stack][nextSlice];
                        Vec3 v11 = grid[stack + 1][nextSlice];
                        Vec3 v10 = grid[stack + 1][slice];
                        gizmoPrimitives.addQuad(v00, v01, v11, v10, fillColor);
                    }
                }
            }
            if (this.style.hasStroke()) {
                int strokeColor = this.style.multipliedStroke(f);
                float width = this.style.strokeWidth();
                for (slice = 0; slice < slices; ++slice) {
                    for (int stack = 0; stack < stacks; ++stack) {
                        gizmoPrimitives.addLine(grid[stack][slice], grid[stack + 1][slice], strokeColor, width);
                    }
                }
                for (int stack = 1; stack < stacks; ++stack) {
                    for (int slice3 = 0; slice3 < slices; ++slice3) {
                        Vec3 a = grid[stack][slice3];
                        Vec3 b = grid[stack][(slice3 + 1) % slices];
                        gizmoPrimitives.addLine(a, b, strokeColor, width);
                    }
                }
            }
        }
    }

    public record TransformedCapsuleGizmo(Matrix4fc transformation, float radius, float halfHeight, GizmoStyle style) implements Gizmo
    {
        private Vec3 transform(float x, float y, float z) {
            Vector3f tmp = new Vector3f();
            this.transformation.transformPosition(x, y, z, tmp);
            return new Vec3((double)tmp.x(), (double)tmp.y(), (double)tmp.z());
        }

        public void emit(GizmoPrimitives gizmoPrimitives, float f) {
            int slice;
            int slices = 8;
            int capStacks = 3;
            Vec3[][] left = new Vec3[capStacks + 1][slices];
            Vec3[][] right = new Vec3[capStacks + 1][slices];
            for (int s = 0; s <= capStacks; ++s) {
                double t = (double)s / (double)capStacks;
                double alpha = t * 1.5707963267948966;
                double sinA = Math.sin(alpha);
                double cosA = Math.cos(alpha);
                double ringRadius = (double)this.radius * cosA;
                double offset = (double)this.radius * sinA;
                float xLeftBase = -this.halfHeight;
                float xRightBase = this.halfHeight;
                for (int slice2 = 0; slice2 < slices; ++slice2) {
                    double u = (double)slice2 / (double)slices;
                    double theta = u * (Math.PI * 2);
                    double cosT = Math.cos(theta);
                    double sinT = Math.sin(theta);
                    float y = (float)(ringRadius * cosT);
                    float z = (float)(ringRadius * sinT);
                    float xLeft = (float)((double)xLeftBase - offset);
                    float xRight = (float)((double)xRightBase + offset);
                    left[s][slice2] = this.transform(xLeft, y, z);
                    right[s][slice2] = this.transform(xRight, y, z);
                }
            }
            if (this.style.hasFill()) {
                Vec3 v11;
                Vec3 v00;
                int s;
                int fillColor = this.style.multipliedFill(f);
                for (int slice3 = 0; slice3 < slices; ++slice3) {
                    int nextSlice = (slice3 + 1) % slices;
                    Vec3 l0 = left[0][slice3];
                    Vec3 l1 = left[0][nextSlice];
                    Vec3 r1 = right[0][nextSlice];
                    Vec3 r0 = right[0][slice3];
                    gizmoPrimitives.addQuad(l0, l1, r1, r0, fillColor);
                }
                for (s = 0; s < capStacks; ++s) {
                    for (slice = 0; slice < slices; ++slice) {
                        int nextSlice = (slice + 1) % slices;
                        v00 = left[s][slice];
                        Vec3 v01 = left[s][nextSlice];
                        v11 = left[s + 1][nextSlice];
                        Vec3 v10 = left[s + 1][slice];
                        gizmoPrimitives.addQuad(v00, v01, v11, v10, fillColor);
                    }
                }
                for (s = 0; s < capStacks; ++s) {
                    for (slice = 0; slice < slices; ++slice) {
                        int nextSlice = (slice + 1) % slices;
                        v00 = right[s][slice];
                        Vec3 v01 = right[s][nextSlice];
                        v11 = right[s + 1][nextSlice];
                        Vec3 v10 = right[s + 1][slice];
                        gizmoPrimitives.addQuad(v00, v01, v11, v10, fillColor);
                    }
                }
            }
            if (this.style.hasStroke()) {
                Vec3 a;
                int s;
                int strokeColor = this.style.multipliedStroke(f);
                float width = this.style.strokeWidth();
                for (slice = 0; slice < slices; ++slice) {
                    gizmoPrimitives.addLine(left[0][slice], right[0][slice], strokeColor, width);
                }
                for (s = 0; s <= capStacks; ++s) {
                    for (int slice4 = 0; slice4 < slices; ++slice4) {
                        a = left[s][slice4];
                        Vec3 b = left[s][(slice4 + 1) % slices];
                        gizmoPrimitives.addLine(a, b, strokeColor, width);
                    }
                }
                for (s = 0; s <= capStacks; ++s) {
                    for (int slice5 = 0; slice5 < slices; ++slice5) {
                        a = right[s][slice5];
                        Vec3 b = right[s][(slice5 + 1) % slices];
                        gizmoPrimitives.addLine(a, b, strokeColor, width);
                    }
                }
            }
        }
    }

    public record TransformedConvexMeshGizmo(Matrix4fc transformation, Vector3f[][] fans, GizmoStyle style) implements Gizmo
    {
        public TransformedConvexMeshGizmo(Matrix4fc transformation, PxConvexMeshGeometry geometry, GizmoStyle style) {
            this(transformation, TransformedConvexMeshGizmo.createGeometryFans(geometry), style);
        }

        private static Vector3f[][] createGeometryFans(PxConvexMeshGeometry geometry) {
            PxConvexMesh mesh = geometry.getConvexMesh();
            int polygonCount = mesh.getNbPolygons();
            if (polygonCount == 0) {
                return null;
            }
            PxHullPolygon polygon = new PxHullPolygon();
            PxU8ConstPtr indices = mesh.getIndexBuffer();
            PxVec3 vertices = mesh.getVertices();
            Vector3f[][] fans = new Vector3f[polygonCount][];
            for (int p = 0; p < polygonCount; ++p) {
                mesh.getPolygonData(p, polygon);
                short firstIndex = polygon.getMIndexBase();
                int vertCount = polygon.getMNbVerts();
                if (vertCount < 3) continue;
                Vector3f[] fan = new Vector3f[vertCount];
                for (int i = 0; i < vertCount; ++i) {
                    byte vertexIndex = NativeArrayHelpers.getU8At(indices, firstIndex + i);
                    PxVec3 v = NativeArrayHelpers.getVec3At(vertices, vertexIndex);
                    fan[i] = new Vector3f(v.getX(), v.getY(), v.getZ());
                }
                fans[p] = fan;
            }
            polygon.destroy();
            return fans;
        }

        private Vec3 transform(float x, float y, float z) {
            Vector3f tmp = new Vector3f();
            this.transformation.transformPosition(x, y, z, tmp);
            return new Vec3((double)tmp.x(), (double)tmp.y(), (double)tmp.z());
        }

        public void emit(GizmoPrimitives gizmoPrimitives, float f) {
            if (this.fans == null) {
                return;
            }
            int fillColor = this.style.hasFill() ? this.style.multipliedFill(f) : 0;
            int strokeColor = this.style.hasStroke() ? this.style.multipliedStroke(f) : 0;
            float width = this.style.strokeWidth();
            for (int p = 0; p < this.fans.length; ++p) {
                int i;
                Vector3f[] fan = this.fans[p];
                if (fan == null) continue;
                Vec3[] transformed = new Vec3[fan.length];
                for (i = 0; i < fan.length; ++i) {
                    Vector3f v = fan[i];
                    transformed[i] = this.transform(v.x(), v.y(), v.z());
                }
                if (this.style.hasFill()) {
                    gizmoPrimitives.addTriangleFan(transformed, fillColor);
                }
                if (!this.style.hasStroke()) continue;
                for (i = 0; i < transformed.length; ++i) {
                    Vec3 a = transformed[i];
                    Vec3 b = transformed[(i + 1) % transformed.length];
                    gizmoPrimitives.addLine(a, b, strokeColor, width);
                }
            }
        }
    }
}

