/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.guiphysics;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.jbox2d.common.Vec2;
import net.diebuddies.jbox2d.dynamics.Body;
import net.diebuddies.jbox2d.dynamics.BodyType;
import net.diebuddies.jbox2d.dynamics.World;
import net.diebuddies.mixins.guiphysics.MixinAbstractWidgetAccessor;
import net.diebuddies.physics.Box2DUtil;
import net.diebuddies.physics.settings.PhysicsSettingsScreen;
import net.diebuddies.physics.settings.gui.ScreenExtension;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import org.joml.Math;
import org.joml.Matrix3x2fStack;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_339.class})
public class MixinAbstractWidget
implements Animatable {
    @Shadow
    private int field_22758;
    @Shadow
    private int field_22759;
    @Shadow
    private int field_22760;
    @Shadow
    private int field_22761;
    @Unique
    private double positionX;
    @Unique
    private double positionY;
    @Unique
    private float rotation;
    @Unique
    private Body buttonBody;
    @Unique
    private float totalDelta;
    @Unique
    private boolean isSimActive;
    @Unique
    private float animX;
    @Unique
    private float animY;
    @Unique
    private float animWidth;
    @Unique
    private float animHeight;
    @Unique
    private List<Animator> animations;
    @Unique
    private float animRed = 1.0f;
    @Unique
    private float animGreen = 1.0f;
    @Unique
    private float animBlue = 1.0f;
    @Unique
    private float animAlpha = 1.0f;
    @Unique
    private float animDepth = 0.0f;
    @Unique
    private float renderPercent = 0.0f;

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void physicsmod$constructor(int x, int y, int width, int height, class_2561 component, CallbackInfo info) {
        this.animX = x;
        this.animY = y;
        this.animWidth = width;
        this.animHeight = height;
        this.animations = new ObjectArrayList();
    }

    @Unique
    private void physicsmod$physicsSetup() {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen == null || screen instanceof PhysicsSettingsScreen) {
            return;
        }
        World world = ((ScreenExtension)screen).getPhysicsWorld();
        class_339 widget = (class_339)this;
        this.buttonBody = Box2DUtil.createBox(world, widget.method_46426(), widget.method_46427(), widget.method_25368(), widget.method_25364(), BodyType.DYNAMIC);
        this.buttonBody.setAngularVelocity(net.diebuddies.math.Math.random() * 10.0f - 5.0f);
        this.buttonBody.setLinearVelocity(new Vec2(net.diebuddies.math.Math.random() * 100.0f - 50.0f, net.diebuddies.math.Math.random() * 100.0f - 50.0f));
    }

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    private void physicsmod$renderHead(class_332 guiGraphics, int mouseX, int mouseY, float delta, CallbackInfo info) {
        this.renderPercent += delta;
        while (this.renderPercent >= 1.0f) {
            this.renderPercent -= 1.0f;
            for (Animator animator : this.animations) {
                animator.tick(this);
            }
        }
        class_437 screen = class_310.method_1551().field_1755;
        if (screen == null) {
            return;
        }
        World world = ((ScreenExtension)screen).getPhysicsWorld();
        if (world != null && (this.buttonBody == null || world != this.buttonBody.getWorld())) {
            this.physicsmod$physicsSetup();
        }
        if (this.buttonBody != null) {
            Vec2 pos = this.buttonBody.getPosition();
            this.rotation = this.buttonBody.getAngle();
            this.positionX = pos.x;
            this.positionY = pos.y;
            ((MixinAbstractWidgetAccessor)((Object)this)).setIsHovered(this.isInside(mouseX, mouseY));
            this.isSimActive = true;
        }
        if (world == null && this.isSimActive) {
            this.buttonBody = null;
            this.totalDelta += 0.05f * delta;
            class_339 widget = (class_339)this;
            float posX = (float)((double)this.getAnimX() + (double)this.getAnimWidth() / 2.0);
            float posY = (float)((double)this.getAnimY() + (double)this.getAnimHeight() / 2.0);
            while (this.totalDelta > 0.004166667f) {
                this.rotation = Math.lerp((float)this.rotation, (float)0.0f, (float)0.05f);
                this.positionX = Math.lerp((double)this.positionX, (double)posX, (double)0.05f);
                this.positionY = Math.lerp((double)this.positionY, (double)posY, (double)0.05f);
                this.totalDelta -= 0.004166667f;
            }
            if (java.lang.Math.abs(this.positionX - (double)posX) < (double)0.1f && java.lang.Math.abs(this.positionX - (double)posX) < (double)0.1f && java.lang.Math.abs(this.rotation) < 0.005f) {
                this.isSimActive = false;
            }
        } else {
            this.totalDelta = 0.0f;
        }
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        if (this.physicsmod$isAnimationActive()) {
            poseStack.pushMatrix();
            this.physicsmod$applyTransformation(poseStack);
        }
        boolean cancelled = false;
        float tickAdjustedDelta = delta / 20.0f;
        for (Animator animator : this.animations) {
            cancelled |= animator.render(this, guiGraphics, mouseX, mouseY, this.renderPercent, tickAdjustedDelta);
        }
        if (cancelled) {
            if (this.physicsmod$isAnimationActive()) {
                poseStack.popMatrix();
                ((MixinAbstractWidgetAccessor)((Object)this)).setIsHovered(this.isInside(mouseX, mouseY));
            }
            info.cancel();
        }
    }

    @Unique
    private boolean physicsmod$isAnimationActive() {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen == null || screen instanceof PhysicsSettingsScreen) {
            return false;
        }
        return this.buttonBody != null || this.isSimActive;
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    private void physicsmod$renderTail(class_332 guiGraphics, int mouseX, int mouseY, float delta, CallbackInfo info) {
        if (this.physicsmod$isAnimationActive()) {
            guiGraphics.method_51448().popMatrix();
            ((MixinAbstractWidgetAccessor)((Object)this)).setIsHovered(this.isInside(mouseX, mouseY));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isMouseOver"}, cancellable=true)
    private void physicsmod$isMouseOver(double mouseX, double mouseY, CallbackInfoReturnable<Boolean> info) {
        if (this.physicsmod$isAnimationActive()) {
            class_339 widget = (class_339)this;
            info.setReturnValue((Object)(widget.field_22763 && widget.field_22764 && this.isInside(mouseX, mouseY) ? 1 : 0));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"areCoordinatesInRectangle"}, cancellable=true)
    private void physicsmod$areCoordinatesInRectangle(double mouseX, double mouseY, CallbackInfoReturnable<Boolean> info) {
        if (this.physicsmod$isAnimationActive()) {
            info.setReturnValue((Object)this.isInside(mouseX, mouseY));
        }
    }

    @Unique
    private void physicsmod$applyTransformation(Matrix3x2fStack poseStack) {
        poseStack.translate((float)(this.positionX - ((double)this.getAnimX() + (double)this.getAnimWidth() / 2.0)), (float)(this.positionY - ((double)this.getAnimY() + (double)this.getAnimHeight() / 2.0)));
        poseStack.translate((float)((double)this.getAnimX() + (double)this.getAnimWidth() / 2.0), (float)((double)this.getAnimY() + (double)this.getAnimHeight() / 2.0));
        poseStack.rotate(this.rotation);
        poseStack.translate((float)(-((double)this.getAnimX() + (double)this.getAnimWidth() / 2.0)), (float)(-((double)this.getAnimY() + (double)this.getAnimHeight() / 2.0)));
    }

    @Override
    public boolean isInside(double mouseX, double mouseY) {
        if (this.physicsmod$isAnimationActive()) {
            Matrix3x2fStack poseStack = new Matrix3x2fStack();
            this.physicsmod$applyTransformation(poseStack);
            Vector3f trMouse = new Vector3f((float)mouseX, (float)mouseY, 1.0f);
            poseStack.invert();
            poseStack.transform(trMouse);
            return (double)trMouse.x() >= (double)this.getAnimX() && (double)trMouse.y() >= (double)this.getAnimY() && (double)trMouse.x() < (double)(this.getAnimX() + this.getAnimWidth()) && (double)trMouse.y() < (double)(this.getAnimY() + this.getAnimHeight());
        }
        return mouseX >= (double)this.getAnimX() && mouseY >= (double)this.getAnimY() && mouseX < (double)(this.getAnimX() + this.getAnimWidth()) && mouseY < (double)(this.getAnimY() + this.getAnimHeight());
    }

    @Override
    public Animatable addAnimator(Animator animator) {
        this.animations.add(animator);
        animator.init(this);
        return this;
    }

    @Override
    public Animatable addAnimator(int offset, Animator animator) {
        this.animations.add(offset, animator);
        animator.init(this);
        return this;
    }

    @Override
    public Animatable addAnimator(List<Animator> animators) {
        for (Animator animator : animators) {
            this.animations.add(animator);
            animator.init(this);
        }
        return this;
    }

    @Override
    public Animatable addAnimator(Animator ... animators) {
        for (Animator animator : animators) {
            this.animations.add(animator);
            animator.init(this);
        }
        return this;
    }

    @Override
    public List<Animator> getAnimators() {
        return this.animations;
    }

    @Override
    public <T extends Animator> T getAnimator(Class<T> clzz) {
        for (Animator animation : this.animations) {
            if (clzz != animation.getClass()) continue;
            return (T)animation;
        }
        return null;
    }

    @Override
    public Animatable removeAnimator(Animator animator) {
        this.animations.remove(animator);
        return this;
    }

    @Override
    public float getAnimX() {
        return this.animX;
    }

    @Override
    public Animatable setAnimX(float x) {
        this.animX = x;
        this.field_22760 = (int)x;
        return this;
    }

    @Override
    public float getAnimY() {
        return this.animY;
    }

    @Override
    public Animatable setAnimY(float y) {
        this.animY = y;
        this.field_22761 = (int)y;
        return this;
    }

    @Override
    public float getAnimWidth() {
        return this.animWidth;
    }

    @Override
    public Animatable setAnimWidth(float width) {
        this.animWidth = width;
        this.field_22758 = (int)width;
        return this;
    }

    @Override
    public float getAnimHeight() {
        return this.animHeight;
    }

    @Override
    public Animatable setAnimHeight(float height) {
        this.animHeight = height;
        this.field_22759 = (int)height;
        return this;
    }

    @Inject(at={@At(value="HEAD")}, method={"setX"})
    public void setX(int x, CallbackInfo info) {
        this.animX = x;
    }

    @Inject(at={@At(value="HEAD")}, method={"setY"})
    public void setY(int y, CallbackInfo info) {
        this.animY = y;
    }

    @Inject(at={@At(value="HEAD")}, method={"setWidth"})
    public void setWidth(int width, CallbackInfo info) {
        this.animWidth = width;
    }

    @Override
    public float getAnimRed() {
        return this.animRed;
    }

    @Override
    public Animatable setAnimRed(float red) {
        this.animRed = red;
        return this;
    }

    @Override
    public float getAnimGreen() {
        return this.animGreen;
    }

    @Override
    public Animatable setAnimGreen(float green) {
        this.animGreen = green;
        return this;
    }

    @Override
    public float getAnimBlue() {
        return this.animBlue;
    }

    @Override
    public Animatable setAnimBlue(float blue) {
        this.animBlue = blue;
        return this;
    }

    @Override
    public float getAnimAlpha() {
        return this.animAlpha;
    }

    @Override
    public Animatable setAnimAlpha(float alpha) {
        this.animAlpha = alpha;
        return this;
    }

    @Override
    public Animatable setAnimColor(float red, float green, float blue, float alpha) {
        this.animRed = red;
        this.animGreen = green;
        this.animBlue = blue;
        this.animAlpha = alpha;
        return this;
    }

    @Override
    public float getAnimDepth() {
        return this.animDepth;
    }

    @Override
    public Animatable setAnimDepth(float depth) {
        this.animDepth = depth;
        return this;
    }
}

