/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.compat;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.diebuddies.physics.BoxRigidBody;
import net.diebuddies.physics.GrabHand;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsWorld;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.provider.openvr_lwjgl.VRInputAction;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxHitFlagEnum;
import physx.physics.PxHitFlags;
import physx.physics.PxQueryFilterData;
import physx.physics.PxQueryFlagEnum;
import physx.physics.PxQueryFlags;
import physx.physics.PxRaycastHit;
import physx.physics.PxRaycastResult;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxRigidDynamic;

public class Vivecraft {
    private static final int OFFSET = -2147483638;
    private final GrabHand[] hands = new GrabHand[]{new GrabHand(), new GrabHand()};

    public void performVrHandsSupport(PhysicsWorld physicsWorld, IntSet active, IntSet activeLastFrame, Int2ObjectMap<IRigidBody> worldEntities) {
        IRigidBody leftHandBody;
        physicsWorld.getDynamicsWorld().getScene().sceneQueriesUpdate();
        physicsWorld.getDynamicsWorld().getScene().fetchQueries(true);
        this.addHandBody(physicsWorld, 0, active, activeLastFrame, worldEntities);
        this.addHandBody(physicsWorld, 1, active, activeLastFrame, worldEntities);
        IRigidBody rightHandBody = (IRigidBody)worldEntities.get(-2147483638);
        if (rightHandBody != null && !rightHandBody.isDestroyed()) {
            VRInputAction action = ClientDataHolderVR.getInstance().vr.getInputActionByName("/actions/ingame/in/key.attack");
            this.overrideActionWhenHovered(physicsWorld, rightHandBody, action, 0);
            this.isHandTriggered(physicsWorld, rightHandBody, action, 0);
        }
        if ((leftHandBody = (IRigidBody)worldEntities.get(-2147483637)) != null && !leftHandBody.isDestroyed()) {
            VRInputAction action = ClientDataHolderVR.getInstance().vr.getInputActionByName("/actions/ingame/in/vivecraft.key.teleport");
            this.overrideActionWhenHovered(physicsWorld, rightHandBody, action, 1);
            this.isHandTriggered(physicsWorld, leftHandBody, action, 1);
        }
    }

    private void overrideActionWhenHovered(PhysicsWorld physicsWorld, IRigidBody handBody, VRInputAction action, int index) {
        if (action.isButtonPressed()) {
            return;
        }
        action.setEnabled(true);
        try (MemoryStack mem = MemoryStack.stackPush();){
            Vec3 pos = this.getControllerPosition(index);
            Vector3f dir = this.getControllerDirection(index);
            Vector3d offset = physicsWorld.getOffset();
            if (dir.lengthSquared() == 0.0f) {
                dir.set(1.0f, 0.0f, 0.0f);
            } else {
                dir.normalize();
            }
            PxVec3 origin = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)(pos.x - offset.x), (float)(pos.y - offset.y), (float)(pos.z - offset.z));
            PxVec3 unitDir = PxVec3.createAt(mem, MemoryStack::nmalloc, dir.x, dir.y, dir.z);
            float distance = 5.0f;
            float closestTerrainHit = Float.MAX_VALUE;
            PxRaycastResult terrainResult = new PxRaycastResult();
            PxHitFlags terrainHitFlags = PxHitFlags.createAt(mem, MemoryStack::nmalloc, (byte)PxHitFlagEnum.eDEFAULT.value);
            PxQueryFlags terrainQueryFlags = PxQueryFlags.createAt(mem, MemoryStack::nmalloc, (byte)(PxQueryFlagEnum.eSTATIC.value | PxQueryFlagEnum.eANY_HIT.value));
            PxQueryFilterData terrainQueryFilter = PxQueryFilterData.createAt(mem, MemoryStack::nmalloc, terrainQueryFlags);
            if (physicsWorld.getDynamicsWorld().getScene().raycast(origin, unitDir, distance, terrainResult, terrainHitFlags, terrainQueryFilter)) {
                for (int i = 0; i < terrainResult.getNbAnyHits(); ++i) {
                    PxRaycastHit hit = terrainResult.getAnyHit(i);
                    float curDistance = hit.getDistance();
                    if (!(curDistance < closestTerrainHit)) continue;
                    closestTerrainHit = curDistance;
                }
            }
            PxRaycastResult result = new PxRaycastResult();
            PxHitFlags hitFlags = PxHitFlags.createAt(mem, MemoryStack::nmalloc, (byte)PxHitFlagEnum.eDEFAULT.value);
            PxQueryFlags queryFlags = PxQueryFlags.createAt(mem, MemoryStack::nmalloc, (byte)(PxQueryFlagEnum.eDYNAMIC.value | PxQueryFlagEnum.eNO_BLOCK.value));
            PxQueryFilterData queryFilter = PxQueryFilterData.createAt(mem, MemoryStack::nmalloc, queryFlags);
            if (physicsWorld.getDynamicsWorld().getScene().raycast(origin, unitDir, distance, result, hitFlags, queryFilter)) {
                for (int i = 0; i < result.getNbAnyHits(); ++i) {
                    PxRaycastHit hit = result.getAnyHit(i);
                    PxRigidDynamic dynamic = PxRigidDynamic.wrapPointer(hit.getActor().getAddress());
                    if (dynamic.getRigidBodyFlags().isSet(PxRigidBodyFlagEnum.eKINEMATIC) || !(hit.getDistance() < closestTerrainHit)) continue;
                    action.setEnabled(false);
                    break;
                }
            }
            result.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void isHandTriggered(PhysicsWorld physicsWorld, IRigidBody handBody, VRInputAction action, int index) {
        GrabHand hand = this.hands[index];
        boolean triggered = action.isButtonPressed();
        if (triggered && !hand.isPreviousTriggered()) {
            if (hand.getJoint() != null) {
                hand.getJoint().release();
                hand.setJoint(null);
            }
            try (MemoryStack mem = MemoryStack.stackPush();){
                Vec3 pos = this.getControllerPosition(index);
                Vector3f dir = this.getControllerDirection(index);
                Vector3d offset = physicsWorld.getOffset();
                if (dir.lengthSquared() == 0.0f) {
                    dir.set(1.0f, 0.0f, 0.0f);
                } else {
                    dir.normalize();
                }
                PxVec3 origin = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)(pos.x - offset.x), (float)(pos.y - offset.y), (float)(pos.z - offset.z));
                PxVec3 unitDir = PxVec3.createAt(mem, MemoryStack::nmalloc, dir.x, dir.y, dir.z);
                float distance = 5.0f;
                float closestTerrainHit = Float.MAX_VALUE;
                PxRaycastResult terrainResult = new PxRaycastResult();
                PxHitFlags terrainHitFlags = PxHitFlags.createAt(mem, MemoryStack::nmalloc, (byte)PxHitFlagEnum.eDEFAULT.value);
                PxQueryFlags terrainQueryFlags = PxQueryFlags.createAt(mem, MemoryStack::nmalloc, (byte)(PxQueryFlagEnum.eSTATIC.value | PxQueryFlagEnum.eANY_HIT.value));
                PxQueryFilterData terrainQueryFilter = PxQueryFilterData.createAt(mem, MemoryStack::nmalloc, terrainQueryFlags);
                if (physicsWorld.getDynamicsWorld().getScene().raycast(origin, unitDir, distance, terrainResult, terrainHitFlags, terrainQueryFilter)) {
                    for (int i = 0; i < terrainResult.getNbAnyHits(); ++i) {
                        PxRaycastHit hit = terrainResult.getAnyHit(i);
                        float curDistance = hit.getDistance();
                        if (!(curDistance < closestTerrainHit)) continue;
                        closestTerrainHit = curDistance;
                    }
                }
                PxRaycastResult result = new PxRaycastResult();
                PxHitFlags hitFlags = PxHitFlags.createAt(mem, MemoryStack::nmalloc, (byte)PxHitFlagEnum.eDEFAULT.value);
                PxQueryFlags queryFlags = PxQueryFlags.createAt(mem, MemoryStack::nmalloc, (byte)(PxQueryFlagEnum.eDYNAMIC.value | PxQueryFlagEnum.eNO_BLOCK.value));
                PxQueryFilterData queryFilter = PxQueryFilterData.createAt(mem, MemoryStack::nmalloc, queryFlags);
                if (physicsWorld.getDynamicsWorld().getScene().raycast(origin, unitDir, distance, result, hitFlags, queryFilter)) {
                    float closest = Float.MAX_VALUE;
                    PxRigidDynamic closestActor = null;
                    PxVec3 closestPos = null;
                    for (int i = 0; i < result.getNbAnyHits(); ++i) {
                        float curDistance;
                        PxRaycastHit hit = result.getAnyHit(i);
                        PxRigidDynamic dynamic = PxRigidDynamic.wrapPointer(hit.getActor().getAddress());
                        if (dynamic.getRigidBodyFlags().isSet(PxRigidBodyFlagEnum.eKINEMATIC) || !((curDistance = hit.getDistance()) < closest) || !(curDistance < closestTerrainHit)) continue;
                        closest = curDistance;
                        closestActor = dynamic;
                        closestPos = hit.getPosition();
                    }
                    if (closestActor != null) {
                        hand.setJoint(physicsWorld.createGrabJoint(handBody.getRigidBody(), closestActor, closestPos));
                    }
                }
                result.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!triggered && hand.isPreviousTriggered() && hand.getJoint() != null) {
            hand.getJoint().release();
            hand.setJoint(null);
        }
        hand.setPreviousTriggered(triggered);
    }

    public void addHandBody(PhysicsWorld physicsWorld, int index, IntSet active, IntSet activeLastFrame, Int2ObjectMap<IRigidBody> worldEntities) {
        try {
            IRigidBody ibody;
            Object body;
            Vector3d offset = physicsWorld.getOffset();
            Matrix4f pos = new Matrix4f();
            this.setupRenderingAtController(index, pos);
            int controllerId = -2147483638 + index;
            double width = 0.2;
            double height = 0.5;
            double depth = 0.5;
            Vector3f translation = pos.getTranslation(new Vector3f());
            Quaternionf rotation = pos.getNormalizedRotation(new Quaternionf());
            if (!activeLastFrame.contains(controllerId)) {
                PhysicsEntity physicsEntity = new PhysicsEntity(PhysicsEntity.Type.MOB, null);
                physicsEntity.physicsGroup = (byte)4;
                physicsEntity.physicsMask = (byte)7;
                physicsEntity.getTransformation().set((Matrix4fc)pos);
                body = null;
                body = BoxRigidBody.create(physicsEntity, (float)width, (float)height, (float)depth, 0.0f, 0.0f, 0.0f, true);
                ((IRigidBody)body).setKinematic(true);
                ((IRigidBody)body).setGravity(false);
                physicsWorld.getDynamicsWorld().addActor(((IRigidBody)body).getRigidBody());
                worldEntities.put(controllerId, body);
            }
            if (!(ibody = (IRigidBody)worldEntities.get(controllerId)).isDestroyed()) {
                body = (PxRigidDynamic)ibody.getRigidBody();
                try (MemoryStack mem = MemoryStack.stackPush();){
                    ((PxRigidDynamic)body).setKinematicTarget(PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)((double)translation.x - offset.x), (float)((double)translation.y - offset.y), (float)((double)translation.z - offset.z)), PxQuat.createAt(mem, MemoryStack::nmalloc, rotation.x, rotation.y, rotation.z, rotation.w)));
                }
            }
            active.add(controllerId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setupRenderingAtController(int c, Matrix4f matrix) {
        Vec3 aimSource = this.getControllerPosition(c);
        matrix.translate((float)aimSource.x, (float)aimSource.y, (float)aimSource.z);
        ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
        float sc = DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale;
        matrix.mul((Matrix4fc)DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getMatrix().invert().transpose());
        matrix.scale(sc, sc, sc);
    }

    public Vec3 getControllerPosition(int c) {
        return RenderHelper.getControllerRenderPos((int)c);
    }

    public Vector3f getControllerDirection(int c) {
        ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
        return DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getDirection();
    }

    public void destroy() {
        for (GrabHand hand : this.hands) {
            if (hand.getJoint() == null) continue;
            hand.getJoint().release();
        }
    }
}

