/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.compat.Sodium;
import net.diebuddies.minecraft.ChunkSectionsToRenderExtension;
import net.diebuddies.minecraft.LevelRendererAccessor;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.render.MainRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.chunk.ChunkSectionsToRender;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class}, priority=1100)
public class MixinLevelRenderer
implements LevelRendererAccessor {
    @Shadow
    private ClientLevel level;
    @Unique
    private MainRenderer physicsmod$mainRenderer = new MainRenderer();

    @Inject(at={@At(value="RETURN")}, method={"prepareChunkRenders"})
    private void physicsmod$setRenderer(Matrix4fc matrix4fc, double d, double e, double f, CallbackInfoReturnable<ChunkSectionsToRender> info) {
        ((ChunkSectionsToRenderExtension)info.getReturnValue()).physicsmod$setRenderer(this.physicsmod$mainRenderer, this.level);
    }

    @Inject(at={@At(value="TAIL")}, method={"submitBlockEntities"})
    private void physicsmod$renderBlockEntities(PoseStack poseStack, LevelRenderState levelRenderState, SubmitNodeStorage submitNodeStorage, CallbackInfo info) {
        this.physicsmod$mainRenderer.renderStaticCloth(this.level);
    }

    @Inject(at={@At(value="TAIL")}, method={"submitEntities"})
    private void physicsmod$renderEntities(PoseStack poseStack, LevelRenderState levelRenderState, SubmitNodeCollector submitNodeCollector, CallbackInfo info) {
        this.physicsmod$mainRenderer.renderDynamicCloth(this.level);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;cullTerrain(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;Z)V", shift=At.Shift.BEFORE)})
    private void physicsmod$setMatrices(GraphicsResourceAllocator graphicsResourceAllocator, DeltaTracker deltaTracker, boolean bl, Camera camera, Matrix4f viewMatrix, Matrix4f projectionMatrix, Matrix4f projectionMatrixForCulling, GpuBufferSlice gpuBufferSlice, Vector4f vector4f, boolean bl2, CallbackInfo info) {
        this.physicsmod$mainRenderer.setMatrices(viewMatrix, projectionMatrix);
        if (this.level != null) {
            PhysicsMod mod = PhysicsMod.getInstance((Level)this.level);
            projectionMatrix.mul((Matrix4fc)viewMatrix, mod.getPhysicsWorld().getSnowWorld().viewProjection);
            if (StarterClient.sodium) {
                Sodium.setRenderer((LevelRenderer)this, this.physicsmod$mainRenderer, this.level);
            }
        }
    }

    @Override
    public MainRenderer physicsmod$getMainRenderer() {
        return this.physicsmod$mainRenderer;
    }

    @Override
    public ClientLevel physicsmod$getLevel() {
        return this.level;
    }
}

