#version 150

in vec3 Position;
in vec3 Normal;
in ivec4 Light;
in vec4 Offset;
in vec4 OffsetNew;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform float RenderPercent;
uniform vec3 LiquidCameraPos;

flat out uint lightcoords;

void main() {
	float scale = OffsetNew.w;
	vec4 currentWorldPos = ModelViewMat * vec4(Position.xyz * scale + mix(Offset.xyz - LiquidCameraPos, OffsetNew.xyz - LiquidCameraPos, RenderPercent), 1.0);
    gl_Position = ProjMat * currentWorldPos;
    lightcoords = uint(Light.x);
}
