/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft.weather;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.snow.math.AABB3D;
import net.diebuddies.physics.vines.VineHelper;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.joml.Vector3d;

public abstract class WeatherParticle
extends class_3940 {
    protected class_2338.class_2339 blockPos = new class_2338.class_2339();
    protected class_2338.class_2339 lastPos = new class_2338.class_2339(0, 1, 0);
    protected int cachedBrightness;
    protected double dampingX = 0.98;
    protected double dampingY = 0.98;
    protected double dampingZ = 0.98;
    protected int r;
    protected int g;
    protected int b;
    protected int a;
    protected int argb;
    protected AABB3D aabb;

    public WeatherParticle(class_638 clientLevel, double x, double y, double z, double vx, double vy, double vz, class_1058 textureAtlasSprite) {
        super(clientLevel, x, y, z, textureAtlasSprite);
        this.field_3844 = 0.06f;
        this.field_3852 = vx;
        this.field_3869 = vy;
        this.field_3850 = vz;
        this.field_17867 = 0.14f;
        this.field_3847 = Math.randomInt(200) + 200;
        this.aabb = new AABB3D(x - 0.01, y - 0.01, z - 0.01, x + 0.01, y + 0.01, z + 0.01);
        this.move();
        this.calculateLight();
    }

    private void move() {
        Vector3d start = this.aabb.start;
        Vector3d end = this.aabb.end;
        start.x += this.field_3852;
        start.y += this.field_3869;
        start.z += this.field_3850;
        end.x += this.field_3852;
        end.y += this.field_3869;
        end.z += this.field_3850;
        this.field_3874 += this.field_3852;
        this.field_3854 += this.field_3869;
        this.field_3871 += this.field_3850;
    }

    public void setColor(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.argb = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62640;
    }

    public int method_3068(float renderPercent) {
        return this.cachedBrightness;
    }

    private void calculateLight() {
        this.blockPos.method_10102(this.field_3858, this.field_3838, this.field_3856);
        if (WeatherEffects.invalidateLight || (this.blockPos.method_10263() != this.lastPos.method_10263() || this.blockPos.method_10264() != this.lastPos.method_10264() || this.blockPos.method_10260() != this.lastPos.method_10260()) && this.field_3851.method_22340((class_2338)this.blockPos)) {
            this.lastPos.method_10101((class_2382)this.blockPos);
            this.cachedBrightness = class_761.method_23794((class_1920)this.field_3851, (class_2338)this.blockPos);
        }
    }

    public void method_3070() {
        ++WeatherEffects.aliveParticles;
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
            return;
        }
        if (this.field_3843) {
            return;
        }
        this.calculateLight();
        this.field_3869 -= (double)this.field_3844;
        this.move();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        float currentX = (float)(this.field_3874 - cameraPos.method_10216());
        float currentY = (float)(this.field_3854 - cameraPos.method_10214());
        float currentZ = (float)(this.field_3871 - cameraPos.method_10215());
        if ((double)(currentX * currentX + currentY * currentY + currentZ * currentZ) > 196.0) {
            this.method_3085();
            return;
        }
        this.blockPos.method_10102(this.field_3874, this.field_3854, this.field_3871);
        class_2680 state = this.field_3851.method_8320((class_2338)this.blockPos);
        class_265 voxelShape = state.method_26220((class_1922)this.field_3851, (class_2338)this.blockPos);
        if (!voxelShape.method_1110() && VineHelper.getSetting(state) == null) {
            for (class_238 aabb : voxelShape.method_1090()) {
                if (!this.aabb.intersect(aabb.field_1323 + (double)this.blockPos.method_10263(), aabb.field_1322 + (double)this.blockPos.method_10264(), aabb.field_1321 + (double)this.blockPos.method_10260(), aabb.field_1320 + (double)this.blockPos.method_10263(), aabb.field_1325 + (double)this.blockPos.method_10264(), aabb.field_1324 + (double)this.blockPos.method_10260())) continue;
                this.method_3085();
                return;
            }
        }
        this.field_3852 *= this.dampingX;
        this.field_3869 *= this.dampingY;
        this.field_3850 *= this.dampingZ;
        class_3610 fluidState = this.field_3851.method_8316((class_2338)this.blockPos);
        if (fluidState.method_15772() == class_3612.field_15910 && this.field_3854 < (double)((float)this.blockPos.method_10264() + fluidState.method_15763((class_1922)this.field_3851, (class_2338)this.blockPos))) {
            if (ConfigClient.areOceanPhysicsEnabled() && Math.random() < ConfigClient.oceanRainPuddleAmount) {
                PhysicsMod.getInstance((class_1937)this.field_3851).getPhysicsWorld().getOceanWorld().spawnRainRipple(20, 0.65f + Math.random() * 0.5f, this.field_3874, this.field_3854, this.field_3871);
            }
            this.method_3085();
        }
    }
}

