/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.vines;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.diebuddies.minecraft.ChunkHelper;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ragdoll.DoorRagdoll;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.vines.Adjustable;
import net.diebuddies.physics.vines.DynamicSetting;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DoorSetting
extends DynamicSetting {
    @Adjustable(id="Hitbox scale", min=0.1, max=10.0, step=0.01, translationId="physicsmod.prop.door.hitboxscale")
    public Vector3f hitboxScale;
    @Adjustable(id="Stiffness", min=0.1, max=5000.0, step=0.1, translationId="physicsmod.prop.door.stiffness")
    public float stiffness;
    @Adjustable(id="Damping", min=0.1, max=100.0, step=0.1, translationId="physicsmod.prop.door.damping")
    public float damping;
    @Adjustable(id="Collision", min=0.1, max=100.0, step=0.1, translationId="physicsmod.prop.door.collision")
    public boolean collision;

    public DoorSetting(Vector3f hitboxScale, float stiffness, float damping, boolean linkedPhysics, boolean collision) {
        this.collision = collision;
        this.hitboxScale = hitboxScale;
        this.stiffness = stiffness;
        this.damping = damping;
        this.linkedPhysics = linkedPhysics;
    }

    public DoorSetting() {
        this.collision = true;
        this.hitboxScale = new Vector3f(0.85f);
        this.stiffness = 1580.0f;
        this.damping = 8.0f;
        this.linkedPhysics = true;
    }

    @Override
    public DynamicRagdoll createRagdoll(PhysicsMod mod, class_2680 current, class_2338 pos, Long2ObjectMap<class_2680> availableBlocks) {
        if (current.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12609) {
            availableBlocks.remove(ChunkHelper.calcRelativeIndex(pos.method_10263(), pos.method_10264(), pos.method_10260()));
            return null;
        }
        DoorRagdoll ragdoll = new DoorRagdoll();
        ragdoll.hitboxScale.set((Vector3fc)this.hitboxScale);
        ragdoll.collision = this.collision;
        ragdoll.hookedEntity = this.createPart(mod, ragdoll, current, pos.method_10264(), pos.method_10263(), pos.method_10264(), pos.method_10260());
        this.createPart(mod, ragdoll, (class_2680)current.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609), pos.method_10264(), pos.method_10263(), pos.method_10264() + 1, pos.method_10260());
        ragdoll.addConnection(1, 0, true);
        ragdoll.stiffness = this.stiffness;
        ragdoll.damping = this.damping;
        ragdoll.linkedPhysics = this.linkedPhysics;
        Vector3d hookPos = new Vector3d();
        hookPos.y = 0.5;
        class_2350 direction = (class_2350)current.method_11654((class_2769)class_2323.field_10938);
        boolean open = (Boolean)current.method_11654((class_2769)class_2323.field_10945) == false;
        boolean hinge = current.method_11654((class_2769)class_2323.field_10941) == class_2750.field_12586;
        class_2350 result = null;
        switch (direction) {
            default: {
                result = open ? class_2350.field_11034 : (hinge ? class_2350.field_11043 : class_2350.field_11035);
                break;
            }
            case field_11035: {
                result = open ? class_2350.field_11035 : (hinge ? class_2350.field_11034 : class_2350.field_11039);
                break;
            }
            case field_11039: {
                result = open ? class_2350.field_11039 : (hinge ? class_2350.field_11035 : class_2350.field_11043);
                break;
            }
            case field_11043: {
                result = open ? class_2350.field_11043 : (hinge ? class_2350.field_11039 : class_2350.field_11034);
            }
        }
        switch (result) {
            default: {
                hookPos.z = 0.90625;
                hookPos.x = hinge ? 0.90625 : 0.09375;
                break;
            }
            case field_11035: {
                hookPos.z = 0.09375;
                hookPos.x = hinge ? 0.09375 : 0.90625;
                break;
            }
            case field_11039: {
                hookPos.x = 0.90625;
                hookPos.z = hinge ? 0.09375 : 0.90625;
                break;
            }
            case field_11034: {
                hookPos.x = 0.09375;
                double d = hookPos.z = hinge ? 0.90625 : 0.09375;
            }
        }
        if (!open) {
            switch (result) {
                default: {
                    hookPos.x = 1.0 - hookPos.x;
                    break;
                }
                case field_11035: {
                    hookPos.x = 1.0 - hookPos.x;
                    break;
                }
                case field_11039: {
                    hookPos.z = 1.0 - hookPos.z;
                    break;
                }
                case field_11034: {
                    hookPos.z = 1.0 - hookPos.z;
                }
            }
        }
        Vector3f offset = ragdoll.hookedEntity.models.get((int)0).mesh.offset;
        hookPos.x -= (double)offset.x % 1.0;
        hookPos.y -= (double)offset.y % 1.0;
        hookPos.z -= (double)offset.z % 1.0;
        ragdoll.hook = hookPos;
        availableBlocks.remove(ChunkHelper.calcRelativeIndex(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        return ragdoll;
    }

    @Override
    public boolean isValid(class_2680 state) {
        return state.method_28498((class_2769)class_2323.field_10938) && state.method_28498((class_2769)class_2323.field_10945) && state.method_28498((class_2769)class_2323.field_10941) && state.method_28498((class_2769)class_2323.field_10946);
    }

    @Override
    public class_2248 defaultBlock() {
        return class_2246.field_10149;
    }
}

