/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft;

import java.util.Random;
import net.diebuddies.physics.Mesh;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderHelper {
    private static Matrix4f transformation = new Matrix4f();
    private static Matrix3f normalMatrix = new Matrix3f();
    private static Vector3f tmpPos = new Vector3f();
    private static Vector3f tmpNormal = new Vector3f();
    private static Random random = new Random();

    public static void renderMesh(class_4597 multiBufferSource, int seed, float rotation, class_898 entityRenderDispatcher, class_2960 texture, Mesh mesh, class_4587 poseStack, int light, int overlay, boolean shade) {
        class_4588 consumer = multiBufferSource.getBuffer(class_1921.method_23572((class_2960)texture));
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        transformation.set((Matrix4fc)poseStack.method_23760().method_23761());
        random.setSeed(seed);
        transformation.rotateX(random.nextFloat() * (float)Math.PI);
        transformation.rotateY(random.nextFloat() * (float)Math.PI);
        transformation.rotateZ(random.nextFloat() * (float)Math.PI + rotation * 0.5f);
        transformation.normal(normalMatrix);
        if (!shade) {
            normalMatrix.set((Matrix3fc)poseStack.method_23760().method_23762());
        }
        for (int i = 0; i < mesh.indicesQuads.size(); ++i) {
            int index = mesh.indicesQuads.getInt(i);
            Vector3f position = mesh.positions.get(index);
            Vector2f uv = mesh.uvs.get(index);
            Vector3f normal = mesh.normals.get(index);
            position = transformation.transformPosition((Vector3fc)position, tmpPos);
            if (shade) {
                tmpNormal.set(normal.x, normal.y, normal.z);
            } else {
                tmpNormal.set(0.0, 1.0, 0.0);
            }
            normalMatrix.transform(tmpNormal);
            if (mesh.colors.size() > 0) {
                int color = mesh.colors.getInt(index);
                r = (float)(color & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color >> 16 & 0xFF) / 255.0f;
            }
            consumer.method_22912(position.x, position.y, position.z).method_22915(r, g, b, 1.0f).method_22913(uv.x, uv.y).method_22922(overlay).method_60803(light).method_22914(RenderHelper.tmpNormal.x, RenderHelper.tmpNormal.y, RenderHelper.tmpNormal.z);
        }
    }
}

