/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.vines;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.diebuddies.compat.Sodium;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.minecraft.ChunkHelper;
import net.diebuddies.minecraft.ClientChunkCacheAccessor;
import net.diebuddies.mixins.vines.StorageInvoker;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.vines.DynamicLoader;
import net.diebuddies.physics.vines.DynamicSetting;
import net.diebuddies.physics.vines.VineHelper;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minecraft.class_6603;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_631.class})
public class MixinClientChunkManager
implements DynamicLoader,
ClientChunkCacheAccessor {
    @Shadow
    @Final
    protected volatile class_631.class_3681 field_16246;
    @Shadow
    @Final
    protected class_638 field_16525;
    @Unique
    protected Long2ObjectMap<List<DynamicRagdoll>> loadedVines = new Long2ObjectOpenHashMap();
    @Unique
    protected PhysicsMod mod;
    @Unique
    protected LongSet loadedChunksSodiumFix = new LongOpenHashSet();

    @Override
    public void chunkPosChanged() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        ObjectOpenHashSet affectedChunks = new ObjectOpenHashSet();
        while (it.hasNext()) {
            boolean shouldBeLoaded;
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            boolean isLoaded = this.loadedVines.containsKey(chunkIndex);
            if (isLoaded == (shouldBeLoaded = VineHelper.isChunkInRange(chunkX, chunkZ))) continue;
            if (isLoaded) {
                this.unloadDynamicBlockChunk(chunkX, chunkZ, (ObjectSet<Vector3i>)affectedChunks, true);
            } else {
                this.loadDynamicBlockChunk(((class_631)this).method_12126(chunkX, chunkZ, false), chunkX, chunkZ, (ObjectSet<Vector3i>)affectedChunks);
            }
            for (Vector3i affectedChunk : affectedChunks) {
                if (StarterClient.sodium) {
                    Sodium.scheduleChunkRebuild(class_310.method_1551().field_1769, affectedChunk.x, affectedChunk.y, affectedChunk.z, true);
                    continue;
                }
                class_310.method_1551().field_1769.method_3295(affectedChunk.x, affectedChunk.y, affectedChunk.z, true);
            }
            affectedChunks.clear();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"updateViewRadius"})
    public void updateLoadDistance(int loadDistance, CallbackInfo info) {
        int properLoadDistance = Math.max(loadDistance, 2) + 3;
        LongIterator itLoaded = this.loadedChunksSodiumFix.iterator();
        while (itLoaded.hasNext()) {
            int chunkZ;
            long chunkIndex = itLoaded.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            if (this.isInRadius(properLoadDistance, chunkX, chunkZ = ChunkHelper.getChunkZ(chunkIndex))) continue;
            itLoaded.remove();
        }
        if (this.mod != null) {
            ObjectIterator it = this.loadedVines.long2ObjectEntrySet().iterator();
            while (it.hasNext()) {
                int chunkZ;
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
                long chunkIndex = entry.getLongKey();
                List ragdolls = (List)entry.getValue();
                int chunkX = ChunkHelper.getChunkX(chunkIndex);
                if (this.isInRadius(properLoadDistance, chunkX, chunkZ = ChunkHelper.getChunkZ(chunkIndex))) continue;
                this.unloadRagdolls(ragdolls, false);
                it.remove();
            }
        }
    }

    @Unique
    public boolean isInRadius(int radius, int chunkX, int chunkZ) {
        return Math.abs(chunkX - this.field_16246.field_19204) <= radius && Math.abs(chunkZ - this.field_16246.field_19205) <= radius;
    }

    @Inject(at={@At(value="HEAD")}, method={"drop"})
    public void drop(class_1923 chunkPos, CallbackInfo info) {
        int chunkX = chunkPos.field_9181;
        int chunkZ = chunkPos.field_9180;
        long chunkIndex = ChunkHelper.calcChunkIndex(chunkX, chunkZ);
        this.loadedChunksSodiumFix.remove(chunkIndex);
        if (this.mod != null) {
            this.unloadDynamicBlockChunk(chunkX, chunkZ);
        }
    }

    @Unique
    protected void unloadDynamicBlockChunk(int chunkX, int chunkZ) {
        this.unloadDynamicBlockChunk(chunkX, chunkZ, null, false);
    }

    @Unique
    protected void unloadDynamicBlockChunk(int chunkX, int chunkZ, ObjectSet<Vector3i> affectedChunks, boolean removeOneFrameLater) {
        long chunkIndex = ChunkHelper.calcChunkIndex(chunkX, chunkZ);
        List ragdolls = (List)this.loadedVines.remove(chunkIndex);
        if (affectedChunks != null && ragdolls != null) {
            for (DynamicRagdoll ragdoll : ragdolls) {
                for (class_2338 pos : ragdoll.getBlockPositions()) {
                    affectedChunks.add((Object)new Vector3i(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10264()), class_4076.method_18675((int)pos.method_10260())));
                }
            }
        }
        this.unloadRagdolls(ragdolls, removeOneFrameLater);
    }

    @Unique
    protected void unloadRagdolls(List<DynamicRagdoll> ragdolls, boolean removeOneFrameLater) {
        if (ragdolls != null) {
            for (DynamicRagdoll ragdoll : ragdolls) {
                if (removeOneFrameLater) {
                    this.mod.sodiumRemoveRagdolls.add(ragdoll);
                    continue;
                }
                this.mod.physicsWorld.removeRagdoll(ragdoll);
            }
        }
    }

    @Override
    public void unloadAllRagdolls() {
        for (List ragdolls : this.loadedVines.values()) {
            this.unloadRagdolls(ragdolls, false);
        }
        this.loadedVines.clear();
    }

    @Override
    public void loadAllRagdolls() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        while (it.hasNext()) {
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            class_2818 chunk = ((class_631)this).method_2857(chunkX, chunkZ, null, false);
            if (!VineHelper.isChunkInRange(chunkX, chunkZ)) continue;
            this.loadDynamicBlockChunk(chunk, chunkX, chunkZ);
        }
    }

    @Override
    public void unloadAllSnow() {
    }

    @Override
    public void loadAllSnow() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        while (it.hasNext()) {
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            class_2818 class_28182 = ((class_631)this).method_2857(chunkX, chunkZ, null, false);
        }
    }

    @Override
    public void unloadAllOcean() {
    }

    @Override
    public void loadAllOcean() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        while (it.hasNext()) {
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            class_2818 class_28182 = ((class_631)this).method_2857(chunkX, chunkZ, null, false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"replaceWithPacketData"})
    public void replaceWithPacketDataHead(int x, int z, class_2540 buf, Map<class_2902.class_2903, long[]> map, Consumer<class_6603.class_6605> consumer, CallbackInfoReturnable<class_2818> info) {
        StorageInvoker storageInvoker = (StorageInvoker)this.field_16246;
        if (!storageInvoker.invokeInRange(x, z)) {
            return;
        }
        int storageIndex = storageInvoker.invokeGetIndex(x, z);
        class_2818 levelChunk = storageInvoker.invokeGetChunk(storageIndex);
        if (levelChunk != null) {
            class_1923 chunkPos = levelChunk.method_12004();
            int chunkX = chunkPos.field_9181;
            int chunkZ = chunkPos.field_9180;
            if (chunkX != x || chunkZ != z) {
                long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
                this.loadedChunksSodiumFix.remove(chunkIndex);
                if (this.mod != null) {
                    this.unloadDynamicBlockChunk(chunkX, chunkZ);
                }
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"replaceWithPacketData"})
    public void replaceWithPacketData(int x, int z, class_2540 buf, Map<class_2902.class_2903, long[]> map, Consumer<class_6603.class_6605> consumer, CallbackInfoReturnable<class_2818> info) {
        class_2818 chunk = (class_2818)info.getReturnValue();
        if (chunk == null) {
            return;
        }
        long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
        this.loadedChunksSodiumFix.add(chunkIndex);
        if (this.mod != null) {
            this.loadCombinedPhysicsChunk(chunk, x, z);
        }
    }

    @Unique
    protected void loadCombinedPhysicsChunk(class_2818 chunk, int x, int z) {
        boolean snow = ConfigClient.areSnowPhysicsEnabled();
        boolean ocean = ConfigClient.areOceanPhysicsEnabled();
        boolean dynamicBlocks = ConfigClient.areDynamicBlockPhysicsEnabled() && VineHelper.isChunkInRange(x, z);
    }

    @Unique
    protected boolean isValidStorageChunk(@Nullable class_2818 levelChunk, int x, int z) {
        if (levelChunk == null) {
            return false;
        }
        class_1923 chunkPos = levelChunk.method_12004();
        return chunkPos.field_9181 == x && chunkPos.field_9180 == z;
    }

    @Unique
    protected void loadSnowChunk(class_2818 chunk, int x, int z) {
    }

    @Unique
    protected void loadOceanChunk(class_2818 chunk, int x, int z) {
    }

    @Unique
    protected void loadDynamicBlockChunk(class_2818 chunk, int x, int z) {
        this.loadDynamicBlockChunk(chunk, x, z, null);
    }

    @Unique
    protected void loadDynamicBlockChunk(class_2818 chunk, int x, int z, ObjectSet<Vector3i> affectedChunks) {
        long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
    }

    @Override
    public void addVineRagdoll(DynamicRagdoll ragdoll, class_2338 pos) {
        long chunkIndex = ChunkHelper.calcChunkIndex(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()));
        List ragdolls = (List)this.loadedVines.get(chunkIndex);
        if (ragdolls == null) {
            ragdolls = new ObjectArrayList();
            this.loadedVines.put(chunkIndex, (Object)ragdolls);
        }
        ragdolls.add(ragdoll);
    }

    @Override
    public void removeVineRagdoll(DynamicRagdoll ragdoll) {
        class_2338 pos;
        long chunkIndex;
        List ragdolls;
        if (ragdoll.getBlockPositions().size() > 0 && (ragdolls = (List)this.loadedVines.get(chunkIndex = ChunkHelper.calcChunkIndex(class_4076.method_18675((int)(pos = ragdoll.getBlockPositions().get(0)).method_10263()), class_4076.method_18675((int)pos.method_10260())))) != null) {
            ragdolls.remove(ragdoll);
        }
    }

    @Unique
    protected List<DynamicRagdoll> searchConnections(int chunkX, int chunkZ, Long2ObjectMap<class_2680> vines) {
        ObjectArrayList ragdolls = new ObjectArrayList();
        while (vines.size() > 0) {
            DynamicRagdoll ragdoll;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)vines.long2ObjectEntrySet().iterator().next();
            long index = entry.getLongKey();
            class_2680 current = (class_2680)entry.getValue();
            int x = (int)(index >> 60) & 0xF;
            int y = (int)(index & 0xFFFFFFFFFFFFFFL);
            int z = (int)(index >> 56) & 0xF;
            DynamicSetting setting = VineHelper.getSetting(current);
            if (setting == null || (ragdoll = setting.createRagdoll(this.mod, current, new class_2338(x + chunkX * 16, y, z + chunkZ * 16), vines)) == null) continue;
            ragdolls.add(ragdoll);
        }
        return ragdolls;
    }

    @Override
    public void setPhysicsMod(PhysicsMod physicsMod) {
        if (this.mod != null) {
            if (this.mod != physicsMod) {
                VAO.storePreviouslyBoundState();
                this.unloadAllRagdolls();
                this.unloadAllSnow();
                this.unloadAllOcean();
                this.mod = physicsMod;
                if (physicsMod != null) {
                    this.loadAllRagdolls();
                    this.loadAllSnow();
                    this.loadAllOcean();
                }
                VAO.restorePreviouslyBoundState();
            }
        } else {
            this.mod = physicsMod;
            if (physicsMod != null) {
                VAO.storePreviouslyBoundState();
                this.loadAllRagdolls();
                this.loadAllSnow();
                this.loadAllOcean();
                VAO.restorePreviouslyBoundState();
            }
        }
    }

    @Override
    public class_631.class_3681 getStorage() {
        return this.field_16246;
    }
}

