/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.diebuddies.opengl.TextureHelper;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.class_2382;
import net.minecraft.class_290;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_777;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;

public class BlockEntityVertexConsumer
implements class_4588 {
    private Model model = new Model();
    private Mesh mesh;
    private int vertCount = 0;
    private Vector3f tmpPos = new Vector3f();
    private Vector3f tmpNormal = new Vector3f();
    private Vector3f tmp1 = new Vector3f();
    private Vector3f tmp2 = new Vector3f();

    public BlockEntityVertexConsumer() {
        this.mesh = this.model.mesh = new Mesh();
    }

    public void validateModel() {
        int indicesFaceCount;
        int faceCount = this.mesh.positions.size() / 4;
        if (faceCount != (indicesFaceCount = this.mesh.indices.size() / 6)) {
            int i;
            this.mesh.indices.clear();
            int index = 0;
            for (i = 0; i < faceCount; ++i) {
                this.mesh.indices.add(index);
                this.mesh.indices.add(index + 1);
                this.mesh.indices.add(index + 2);
                this.mesh.indices.add(index);
                this.mesh.indices.add(index + 2);
                this.mesh.indices.add(index + 3);
                index += 4;
            }
            if (this.mesh.positions.size() != this.mesh.normals.size()) {
                for (i = this.mesh.normals.size(); i < this.mesh.positions.size(); ++i) {
                    Vector3f tmp1;
                    int face = i / 4;
                    Vector3f pos0 = this.mesh.positions.get(face * 4 + 1);
                    Vector3f pos1 = this.mesh.positions.get(face * 4 + 2);
                    Vector3f pos2 = this.mesh.positions.get(face * 4 + 3);
                    Vector3f tmp0 = pos1.sub((Vector3fc)pos0, this.tmp1);
                    Vector3f normal = tmp0.cross((Vector3fc)(tmp1 = pos2.sub((Vector3fc)pos0, this.tmp2)));
                    float length = normal.lengthSquared();
                    if ((double)length != 0.0) {
                        normal.mul(1.0f / length);
                    } else {
                        normal.set(0.0, 1.0, 0.0);
                    }
                    this.mesh.normals.add(normal);
                }
            }
        }
    }

    public class_4588 method_22912(float x, float y, float z) {
        this.mesh.positions.add(new Vector3f(x, y, z));
        this.model.textureID = TextureHelper.getLoadedTextures();
        return this;
    }

    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        this.mesh.addColor(red, green, blue, alpha);
        return this;
    }

    public class_4588 method_22913(float u, float v) {
        this.mesh.uvs.add(new Vector2f(u, v));
        return this;
    }

    public class_4588 method_60796(int u, int v) {
        return this;
    }

    public class_4588 method_22921(int u, int v) {
        return this;
    }

    public class_4588 method_22914(float x, float y, float z) {
        this.mesh.normals.add(new Vector3f(x, y, z));
        return this;
    }

    public class_4588 method_22918(Matrix4f matrix, float x, float y, float z) {
        this.tmpPos.set(x, y, z);
        matrix.transformPosition(this.tmpPos);
        this.mesh.positions.add(new Vector3f(this.tmpPos.x(), this.tmpPos.y(), this.tmpPos.z()));
        this.model.textureID = TextureHelper.getLoadedTextures();
        return this;
    }

    public class_4588 method_60831(class_4587.class_4665 pose, float x, float y, float z) {
        this.tmpNormal.set(x, y, z);
        pose.method_56820(x, y, z, this.tmpNormal);
        this.mesh.normals.add(new Vector3f(this.tmpNormal.x(), this.tmpNormal.y(), this.tmpNormal.z()));
        return this;
    }

    public void method_22920(class_4587.class_4665 matrixEntry, class_777 quad, float[] brightnesses, float red, float green, float blue, float alpha, int[] lights, int overlay, boolean useQuadColorData) {
        int[] js = quad.comp_3721();
        class_2382 faceNormal = quad.comp_3723().method_62675();
        this.tmpNormal.set((float)faceNormal.method_10263(), (float)faceNormal.method_10264(), (float)faceNormal.method_10260());
        Matrix4f matrix4f = matrixEntry.method_23761();
        matrixEntry.method_23762().transform(this.tmpNormal);
        int integerSize = class_290.field_1590.getVertexSize() / 4;
        int j = js.length / integerSize;
        this.model.textureID = TextureHelper.getLoadedTextures();
        PhysicsMod.getCurrentInstance().itemStackEntity.shade = quad.comp_3725();
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = stack.malloc(class_290.field_1590.getVertexSize());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                float t;
                float s;
                float r;
                float w;
                float v;
                intBuffer.clear();
                intBuffer.put(js, k * integerSize, integerSize);
                float f = byteBuffer.getFloat(0);
                float g = byteBuffer.getFloat(4);
                float h = byteBuffer.getFloat(8);
                if (useQuadColorData) {
                    float l = (float)(byteBuffer.get(12) & 0xFF) * 0.003921569f;
                    v = (float)(byteBuffer.get(13) & 0xFF) * 0.003921569f;
                    w = (float)(byteBuffer.get(14) & 0xFF) * 0.003921569f;
                    r = l * red;
                    s = v * green;
                    t = w * blue;
                } else {
                    r = red;
                    s = green;
                    t = blue;
                }
                v = byteBuffer.getFloat(16);
                w = byteBuffer.getFloat(20);
                this.tmpPos.set(f, g, h);
                matrix4f.transformPosition(this.tmpPos);
                this.mesh.positions.add(new Vector3f(this.tmpPos.x(), this.tmpPos.y(), this.tmpPos.z()));
                this.mesh.addColor(r, s, t);
                this.mesh.normals.add(new Vector3f(this.tmpNormal.x(), this.tmpNormal.y(), this.tmpNormal.z()));
                this.mesh.uvs.add(new Vector2f(v, w));
            }
            int index = this.mesh.positions.size() - 4;
            this.mesh.indices.add(index);
            this.mesh.indices.add(index + 1);
            this.mesh.indices.add(index + 2);
            this.mesh.indices.add(index);
            this.mesh.indices.add(index + 2);
            this.mesh.indices.add(index + 3);
        }
    }

    public void method_23919(float x, float y, float z, int color, float u, float v, int overlay, int light, float normalX, float normalY, float normalZ) {
        ++this.vertCount;
        this.model.textureID = TextureHelper.getLoadedTextures();
        this.mesh.positions.add(new Vector3f(x, y, z));
        this.mesh.addColor((float)class_9848.method_61327((int)color) / 255.0f, (float)class_9848.method_61329((int)color) / 255.0f, (float)class_9848.method_61331((int)color) / 255.0f, (float)class_9848.method_61320((int)color) / 255.0f);
        this.mesh.normals.add(new Vector3f(normalX, normalY, normalZ));
        this.mesh.uvs.add(new Vector2f(u, v));
        if (this.vertCount == 4) {
            this.vertCount = 0;
            int index = this.mesh.positions.size() - 4;
            this.mesh.indices.add(index);
            this.mesh.indices.add(index + 1);
            this.mesh.indices.add(index + 2);
            this.mesh.indices.add(index);
            this.mesh.indices.add(index + 2);
            this.mesh.indices.add(index + 3);
        }
    }

    public class_4588 method_22915(float red, float green, float blue, float alpha) {
        this.mesh.addColor(red, green, blue, alpha);
        return this;
    }

    public class_4588 method_60803(int uv) {
        return this;
    }

    public class_4588 method_22922(int uv) {
        return this;
    }

    public Model getModel() {
        return this.model;
    }
}

