/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

public class PhysicsIndex {
    private static final int BITS_Y = 12;
    private static final int BITS_XZ = 26;
    private static final long MASK_Y = 4095L;
    private static final long MASK_XZ = 0x3FFFFFFL;
    private static final int BIAS_XZ = 0x2000000;
    private static final int BIAS_Y = 2048;

    public static long pack(int cx, int cy, int cz) {
        long ux = (long)(cx + 0x2000000) & 0x3FFFFFFL;
        long uy = (long)(cy + 2048) & 0xFFFL;
        long uz = (long)(cz + 0x2000000) & 0x3FFFFFFL;
        return ux << 38 | uz << 12 | uy;
    }

    public static int unpackX(long key) {
        return (int)(key >>> 38 & 0x3FFFFFFL) - 0x2000000;
    }

    public static int unpackZ(long key) {
        return (int)(key >>> 12 & 0x3FFFFFFL) - 0x2000000;
    }

    public static int unpackY(long key) {
        return (int)(key & 0xFFFL) - 2048;
    }
}

