/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.ragdoll;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ragdoll.BreakableRagdoll;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.ragdoll.RagdollHook;
import net.diebuddies.physics.ragdoll.VanillaRagdollHook;
import net.diebuddies.physics.settings.mobs.MobPhysicsType;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1492;
import net.minecraft.class_1937;
import net.minecraft.class_578;
import net.minecraft.class_583;
import net.minecraft.class_630;

public class RagdollMapper {
    private static final List<RagdollHook> hooks = new ObjectArrayList();
    private static final RagdollHook vanillaHook = new VanillaRagdollHook();

    public static void addHook(RagdollHook hook) {
        hooks.add(hook);
    }

    public static void removeHook(RagdollHook hook) {
        hooks.remove(hook);
    }

    public static Ragdoll map(MobPhysicsType type, class_1297 entity, class_583 model, class_10017 renderState) {
        BreakableRagdoll ragdoll = type == MobPhysicsType.RAGDOLL ? new BreakableRagdoll(-1.0f) : new BreakableRagdoll(ConfigClient.jointBreakForce);
        ragdoll.bodies.addAll(PhysicsMod.getInstance((class_1937)entity.method_37908()).blockifiedEntity);
        for (RagdollHook hook : hooks) {
            hook.map(ragdoll, entity, model, renderState);
        }
        if (ragdoll.joints.size() > 0) {
            return ragdoll;
        }
        vanillaHook.map(ragdoll, entity, model, renderState);
        if (ragdoll.joints.size() == 0) {
            return null;
        }
        return ragdoll;
    }

    public static void filterCuboidsFromEntities(class_1297 entity, class_583 model) {
        PhysicsMod mod = PhysicsMod.getInstance(entity.method_37908());
        for (RagdollHook hook : hooks) {
            hook.filterCuboidsFromEntities(mod.blockifiedEntity, entity, model);
        }
        vanillaHook.filterCuboidsFromEntities(mod.blockifiedEntity, entity, model);
    }

    public static void printModelParts(class_583 model) {
        int index = 0;
        for (class_630 part : model.method_63513()) {
            index = RagdollMapper.printModelPart(part, index);
        }
        System.out.println(model.getClass());
        System.out.println("total: " + index);
    }

    public static int countModelParts(class_1297 entity, class_583 model) {
        if (model instanceof class_578) {
            int total = 9;
            if (!((class_1492)entity).method_6109() && ((class_1492)entity).method_6703()) {
                total = 11;
            }
            return total;
        }
        int total = 0;
        return RagdollMapper.printModelPart(model.method_63512(), total, true);
    }

    public static boolean areRagdollsEnabled(class_1297 entity) {
        MobPhysicsType type = ConfigMobs.getMobSetting(entity).getType();
        return type == MobPhysicsType.RAGDOLL || type == MobPhysicsType.RAGDOLL_BREAK || type == MobPhysicsType.RAGDOLL_BREAK_BLOOD;
    }

    public static boolean isMobFracturingEnabled(class_1297 entity) {
        MobPhysicsType type = ConfigMobs.getMobSetting(entity).getType();
        return type == MobPhysicsType.FRACTURED || type == MobPhysicsType.FRACTURED_BLOOD;
    }

    public static int printModelPart(class_630 part, int index, boolean hidePrint) {
        if (part.field_3665) {
            for (int i = 0; i < part.field_3663.size(); ++i) {
                ++index;
            }
            for (Map.Entry entry : part.field_3661.entrySet()) {
                if (!hidePrint) {
                    System.out.println((String)entry.getKey() + ": " + index);
                }
                class_630 child = (class_630)entry.getValue();
                index = RagdollMapper.printModelPart(child, index, hidePrint);
            }
        }
        return index;
    }

    public static int getModelPartIndices(class_630 part, Counter counter, Map<String, ModelPartIndex> indices) {
        if (part.field_3665) {
            counter.count += part.field_3663.size();
            for (Map.Entry entry : part.field_3661.entrySet()) {
                String name = (String)entry.getKey();
                class_630 child = (class_630)entry.getValue();
                ModelPartIndex index = indices.get(name);
                if (index == null) {
                    index = new ModelPartIndex(part, counter.count);
                    indices.put(name, index);
                } else {
                    index.overlays.add(new ModelPartIndex(part, counter.count));
                }
                counter.count = RagdollMapper.getModelPartIndices(child, counter, indices);
            }
        }
        return counter.count;
    }

    public static Map<String, ModelPartIndex> getModelPartIndices(class_583 model) {
        Object2ObjectOpenHashMap indices = new Object2ObjectOpenHashMap();
        Counter counter = new Counter();
        for (class_630 part : model.method_63513()) {
            RagdollMapper.getModelPartIndices(part, counter, (Map<String, ModelPartIndex>)indices);
        }
        return indices;
    }

    public static int printModelPart(class_630 part, int index) {
        return RagdollMapper.printModelPart(part, index, false);
    }

    public static int getCuboids(Ragdoll ragdoll, class_630 part, Counter counter, boolean onlyVisual) {
        if (part.field_3665) {
            for (int c = 1; c < part.field_3663.size(); ++c) {
                if (counter.count >= ragdoll.bodies.size()) continue;
                ragdoll.addConnection(counter.count + c, counter.count, true, onlyVisual);
            }
            counter.count += part.field_3663.size();
            for (class_630 p : part.field_3661.values()) {
                counter.count = RagdollMapper.getCuboids(ragdoll, p, counter);
            }
        }
        return counter.count;
    }

    public static int getCuboids(Ragdoll ragdoll, class_630 part, Counter counter) {
        return RagdollMapper.getCuboids(ragdoll, part, counter, false);
    }

    public static void addOverlayConnections(Ragdoll ragdoll, Map<String, ModelPartIndex> indices, boolean onlyVisual) {
        for (ModelPartIndex index : indices.values()) {
            int originalIndex = index.index;
            for (ModelPartIndex overlay : index.overlays) {
                int overlayIndex = overlay.index;
                class_630 part = overlay.part;
                if (overlayIndex < ragdoll.bodies.size()) {
                    ragdoll.addConnection(overlayIndex, originalIndex, true, onlyVisual);
                }
                for (int c = 1; c < part.field_3663.size(); ++c) {
                    if (overlayIndex + c >= ragdoll.bodies.size()) continue;
                    ragdoll.addConnection(overlayIndex + c, originalIndex, true, onlyVisual);
                }
            }
        }
    }

    public static class Counter {
        public int count;
    }

    public static class ModelPartIndex {
        public class_630 part;
        public List<ModelPartIndex> overlays;
        public int index;

        public ModelPartIndex(class_630 part, int index) {
            this.part = part;
            this.overlays = new ObjectArrayList();
            this.index = index;
        }
    }
}

