/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.gui;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import net.diebuddies.physics.settings.gui.GuiPhysicsEntityRenderState;
import net.diebuddies.physics.settings.gui.RendererReset;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class GuiPhysicsEntityRenderer
extends class_11239<GuiPhysicsEntityRenderState>
implements RendererReset {
    private static final Matrix3x2f IDENTITY_POSE = new Matrix3x2f();
    private static final int ATLAS_SIZE = 128;
    private int atlasX;
    private int atlasY;

    public GuiPhysicsEntityRenderer(class_4597.class_4598 bufferSource) {
        super(bufferSource);
    }

    public Class<GuiPhysicsEntityRenderState> method_70903() {
        return GuiPhysicsEntityRenderState.class;
    }

    protected void renderToTexture(GuiPhysicsEntityRenderState guiEntityRenderState, class_4587 poseStack) {
        class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        poseStack.method_22903();
        poseStack.method_34425(guiEntityRenderState.transform());
        try {
            guiEntityRenderState.renderer().method_3936(guiEntityRenderState.renderState(), poseStack, (class_4597)this.field_59933, 0xF000F0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        poseStack.method_22909();
    }

    @Override
    public void reset() {
        if (this.field_59935 != null) {
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(this.field_59935, 0, this.field_59936, 1.0);
            this.atlasX = 0;
            this.atlasY = 0;
        }
    }

    public void prepare(GuiPhysicsEntityRenderState pictureInPictureRenderState, class_11246 guiRenderState, int guiScale) {
        int iconSize = pictureInPictureRenderState.iconSize() * guiScale;
        if (this.atlasX + iconSize >= 128 * guiScale) {
            this.atlasY += iconSize;
            this.atlasX = 0;
            if (this.atlasY + iconSize >= 128 * guiScale) {
                this.atlasX = 128 * guiScale;
                return;
            }
        }
        this.prepareCustomTexturesAndProjection(128 * guiScale, 128 * guiScale);
        RenderSystem.outputColorTextureOverride = this.field_60572;
        RenderSystem.outputDepthTextureOverride = this.field_60573;
        class_4587 poseStack = new class_4587();
        poseStack.method_23760().method_67796((float)(this.atlasX + iconSize / 2), (float)(this.atlasY + iconSize / 2), 0.0f);
        poseStack.method_23760().method_67800((float)guiScale, (float)guiScale, (float)guiScale);
        poseStack.method_23760().method_67797((Matrix4fc)new Matrix4f().mul((Matrix3x2fc)pictureInPictureRenderState.method_72127()));
        this.renderToTexture(pictureInPictureRenderState, poseStack);
        this.field_59933.method_22993();
        RenderSystem.outputColorTextureOverride = null;
        RenderSystem.outputDepthTextureOverride = null;
        float umin = (float)this.atlasX / (float)(128 * guiScale);
        float vmin = (float)this.atlasY / (float)(128 * guiScale);
        float umax = umin + (float)iconSize / (float)(128 * guiScale);
        float vmax = vmin + (float)iconSize / (float)(128 * guiScale);
        guiRenderState.method_71996(new class_11241(class_10799.field_59968, class_11231.method_70900((GpuTextureView)this.field_60572), IDENTITY_POSE, pictureInPictureRenderState.comp_4122(), pictureInPictureRenderState.comp_4123(), pictureInPictureRenderState.comp_4124(), pictureInPictureRenderState.comp_4125(), umin, umax, 1.0f - vmin, 1.0f - vmax, -1, pictureInPictureRenderState.comp_4128(), null));
        this.atlasX += iconSize;
    }

    public final void prepareCustomTexturesAndProjection(int width, int height) {
        if (this.field_59935 != null && (this.field_59935.getWidth(0) != width || this.field_59935.getHeight(0) != height)) {
            this.field_59935.close();
            this.field_59935 = null;
            this.field_60572.close();
            this.field_60572 = null;
            this.field_59936.close();
            this.field_59936 = null;
            this.field_60573.close();
            this.field_60573 = null;
        }
        if (this.field_59935 == null) {
            GpuDevice gpuDevice = RenderSystem.getDevice();
            this.field_59935 = gpuDevice.createTexture(() -> "UI " + this.method_70906() + " texture", 12, TextureFormat.RGBA8, width, height, 1, 1);
            this.field_59935.setTextureFilter(FilterMode.NEAREST, false);
            this.field_60572 = gpuDevice.createTextureView(this.field_59935);
            this.field_59936 = gpuDevice.createTexture(() -> "UI " + this.method_70906() + " depth texture", 8, TextureFormat.DEPTH32, width, height, 1, 1);
            this.field_60573 = gpuDevice.createTextureView(this.field_59936);
            gpuDevice.createCommandEncoder().clearColorAndDepthTextures(this.field_59935, 0, this.field_59936, 1.0);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.field_60042.method_71092((float)width, (float)height), (class_10366)class_10366.field_54954);
    }

    protected float method_70907(int i, int j) {
        return (float)i / 2.0f;
    }

    protected String method_70906() {
        return "physics mod entity";
    }
}

