/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.ux;

import net.diebuddies.mixins.guiphysics.MixinAbstractWidgetAccessor;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.diebuddies.physics.settings.ux.BaseColors;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_9848;
import org.joml.Math;

public class BarRenderer
extends Animator {
    private float oldHoveredPercent;
    private float currentHoveredPercent;
    private float animationSpeed = 0.6f;
    private boolean highlightBarAnimation = false;
    private BarAlignment barAlignment;
    private int hoveredColor = BaseColors.HIGHLIGHT_COLOR;
    private int disabledColor = BaseColors.DISABLED_COLOR;
    private int darkenColor = class_9848.method_61324((int)255, (int)200, (int)200, (int)200);
    private int barColor = BaseColors.BAR_COLOR;
    private boolean active;
    private float barSize;

    public BarRenderer(BarAlignment barAlignment, boolean highlightBarAnimation, float barSize) {
        this.highlightBarAnimation = highlightBarAnimation;
        this.barAlignment = barAlignment;
        this.barSize = barSize;
    }

    @Override
    public boolean render(Animatable animatable, class_332 guiGraphics, int mouseX, int mouseY, float renderPercent, float delta) {
        class_339 widget;
        boolean hovered = false;
        if (animatable instanceof MixinAbstractWidgetAccessor) {
            MixinAbstractWidgetAccessor accessor = (MixinAbstractWidgetAccessor)((Object)animatable);
            hovered = accessor.getIsHovered();
        }
        this.active = true;
        boolean focused = false;
        if (animatable instanceof class_339) {
            class_339 widget2 = (class_339)animatable;
            this.active = widget2.method_37303();
            focused = widget2.method_25370();
        }
        int color = BaseColors.BACKGROUND_COLOR;
        float x = animatable.getAnimX();
        float y = animatable.getAnimY();
        float width = animatable.getAnimWidth();
        float height = animatable.getAnimHeight();
        float depth = animatable.getAnimDepth();
        int n = color = this.active ? this.barColor : this.disabledColor;
        if (!hovered && focused) {
            color = class_9848.method_61322((int)color, (int)this.darkenColor);
        }
        if (this.barAlignment == BarAlignment.BOTTOM) {
            BarRenderer.drawRect(guiGraphics, x, y + height - this.barSize, width, this.barSize, depth, color);
        } else if (this.barAlignment == BarAlignment.RIGHT) {
            BarRenderer.drawRect(guiGraphics, x + width - this.barSize, y, this.barSize, height, depth, color);
        } else if (this.barAlignment == BarAlignment.TOP) {
            BarRenderer.drawRect(guiGraphics, x, y + height, width, this.barSize, depth, color);
        } else if (this.barAlignment == BarAlignment.LEFT) {
            BarRenderer.drawRect(guiGraphics, x, y, this.barSize, height, depth, color);
        }
        if (animatable instanceof class_339 && (widget = (class_339)animatable).method_25367()) {
            int n2 = color = this.active ? this.hoveredColor : this.disabledColor;
            if (!hovered && focused) {
                color = class_9848.method_61322((int)color, (int)this.darkenColor);
            }
            float hoverPercent = Math.lerp((float)this.oldHoveredPercent, (float)this.currentHoveredPercent, (float)renderPercent) * 0.5f;
            if (!this.isHighlightBarAnimation()) {
                hoverPercent = 0.5f;
            }
            if (this.barAlignment == BarAlignment.BOTTOM) {
                BarRenderer.drawRect(guiGraphics, x + width * 0.5f - width * hoverPercent, y + height - this.barSize, width * hoverPercent * 2.0f, this.barSize, depth, color);
            } else if (this.barAlignment == BarAlignment.RIGHT) {
                BarRenderer.drawRect(guiGraphics, x + width - this.barSize, y + height * 0.5f - height * hoverPercent, this.barSize, height * hoverPercent * 2.0f, depth, color);
            } else if (this.barAlignment == BarAlignment.TOP) {
                BarRenderer.drawRect(guiGraphics, x + width * 0.5f - width * hoverPercent, y, width * hoverPercent * 2.0f, this.barSize, depth, color);
            } else if (this.barAlignment == BarAlignment.LEFT) {
                BarRenderer.drawRect(guiGraphics, x, y + height * 0.5f - height * hoverPercent, this.barSize, height * hoverPercent * 2.0f, depth, color);
            }
        }
        return false;
    }

    public static void renderHighlightBar(class_332 guiGraphics, BarAlignment barAlignment, float x, float y, float width, float height, float depth, float barSize, int color) {
        if (barAlignment == BarAlignment.BOTTOM) {
            BarRenderer.drawRect(guiGraphics, x, y + height - barSize, width, barSize, depth, color);
        } else if (barAlignment == BarAlignment.RIGHT) {
            BarRenderer.drawRect(guiGraphics, x + width - barSize, y, barSize, height, depth, color);
        } else if (barAlignment == BarAlignment.TOP) {
            BarRenderer.drawRect(guiGraphics, x, y + height, width, barSize, depth, color);
        } else if (barAlignment == BarAlignment.LEFT) {
            BarRenderer.drawRect(guiGraphics, x, y, barSize, height, depth, color);
        }
    }

    @Override
    public void tick(Animatable animatable) {
        MixinAbstractWidgetAccessor accessor;
        super.tick(animatable);
        this.oldHoveredPercent = this.currentHoveredPercent;
        float hovered = 0.0f;
        if (animatable instanceof MixinAbstractWidgetAccessor && (accessor = (MixinAbstractWidgetAccessor)((Object)animatable)).getIsHovered()) {
            hovered = 1.0f;
        }
        this.currentHoveredPercent = Math.lerp((float)this.currentHoveredPercent, (float)hovered, (float)this.animationSpeed);
    }

    public int getActiveColor() {
        if (this.active) {
            return this.hoveredColor;
        }
        return this.disabledColor;
    }

    public BarRenderer setAnimationSpeed(float animationSpeed) {
        this.animationSpeed = animationSpeed;
        return this;
    }

    public float getAnimationSpeed() {
        return this.animationSpeed;
    }

    public BarRenderer setBarAlignment(BarAlignment barAlignment) {
        this.barAlignment = barAlignment;
        return this;
    }

    public BarAlignment getBarAlignment() {
        return this.barAlignment;
    }

    public BarRenderer setHighlightBarAnimation(boolean highlightBarAnimation) {
        this.highlightBarAnimation = highlightBarAnimation;
        return this;
    }

    public boolean isHighlightBarAnimation() {
        return this.highlightBarAnimation;
    }

    public BarRenderer setHoveredColor(int hoveredColor) {
        this.hoveredColor = hoveredColor;
        return this;
    }

    public BarRenderer setDisabledColor(int disabledColor) {
        this.disabledColor = disabledColor;
        return this;
    }

    public BarRenderer setBarColor(int barColor) {
        this.barColor = barColor;
        return this;
    }

    public BarRenderer setDarkenColor(int darkenColor) {
        this.darkenColor = darkenColor;
        return this;
    }

    public static enum BarAlignment {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

