/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.bridge;

import com.mojang.blaze3d.platform.InputConstants;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.settings.PhysicsSettingsScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class KeyBindingsRegistry {
    public static final Lazy<KeyMapping> GRAB_PHYSICS = Lazy.of(() -> new KeyMapping("physicsmod.keybinding.grabobject", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "physicsmod.keybinding.category"));
    public static final Lazy<KeyMapping> GUI_PHYSICS = Lazy.of(() -> new KeyMapping("physicsmod.keybinding.guiphysics", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 295, "physicsmod.keybinding.category"));
    public static final Lazy<KeyMapping> PHYISCS_MENU = Lazy.of(() -> new KeyMapping("physicsmod.keybinding.physicsmenu", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM, 296, "physicsmod.keybinding.category"));
    public static final Lazy<KeyMapping> TOGGLE_PHYSICS = Lazy.of(() -> new KeyMapping("physicsmod.keybinding.togglephysics", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "physicsmod.keybinding.category"));
    public static final Lazy<KeyMapping> PHYSICS_DEBUG_OVERLAY = Lazy.of(() -> new KeyMapping("physicsmod.keybinding.debug", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "physicsmod.keybinding.category"));

    public static void register(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.addListener(KeyBindingsRegistry::onClientTick);
        context.getModEventBus().addListener(KeyBindingsRegistry::registerBindings);
    }

    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)GRAB_PHYSICS.get());
        event.register((KeyMapping)GUI_PHYSICS.get());
        event.register((KeyMapping)PHYISCS_MENU.get());
        event.register((KeyMapping)TOGGLE_PHYSICS.get());
        event.register((KeyMapping)PHYSICS_DEBUG_OVERLAY.get());
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (((KeyMapping)GRAB_PHYSICS.get()).consumeClick()) {
            }
            while (((KeyMapping)GUI_PHYSICS.get()).consumeClick()) {
            }
            while (((KeyMapping)PHYISCS_MENU.get()).consumeClick()) {
                Minecraft.getInstance().setScreen((Screen)new PhysicsSettingsScreen(null));
            }
            while (((KeyMapping)TOGGLE_PHYSICS.get()).consumeClick()) {
                ConfigClient.toggleSettings();
            }
            while (((KeyMapping)PHYSICS_DEBUG_OVERLAY.get()).consumeClick()) {
                ConfigClient.renderPhysicsDebugOverlay = !ConfigClient.renderPhysicsDebugOverlay;
            }
        }
    }
}

