/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.bridge;

import net.diebuddies.minecraft.weather.DustParticle;
import net.diebuddies.minecraft.weather.RainParticle;
import net.diebuddies.minecraft.weather.SnowParticle;
import net.diebuddies.physics.ocean.ExplosionOceanSplashParticle;
import net.diebuddies.physics.ocean.OceanSplashParticle;
import net.diebuddies.physics.ocean.SmallOceanSplashParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class WeatherParticlesRegistry {
    private static final ResourceLocation RAIN_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"rain");
    private static final ResourceLocation SNOW_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"snow");
    private static final ResourceLocation DUST_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"dust");
    private static final ResourceLocation SPLASH_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"splash");
    private static final ResourceLocation SPLASH_SMALL_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"splash_small");
    private static final ResourceLocation SPLASH_EXPLOSION_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"splash_explosion");
    public static ParticleProvider<ParticleOptions> RAIN;
    public static ParticleProvider<ParticleOptions> SNOW;
    public static ParticleProvider<ParticleOptions> DUST;
    public static ParticleProvider<ParticleOptions> SPLASH;
    public static ParticleProvider<ParticleOptions> SPLASH_SMALL;
    public static ParticleProvider<ParticleOptions> SPLASH_EXPLOSION;

    public static void register(FMLJavaModLoadingContext context) {
        context.getModEventBus().register(WeatherParticlesRegistry.class);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        RAIN = WeatherParticlesRegistry.registerSpriteSet(RAIN_RESOURCE, sprite -> new RainParticle.Provider(sprite));
        SNOW = WeatherParticlesRegistry.registerSpriteSet(SNOW_RESOURCE, sprite -> new SnowParticle.Provider(sprite));
        DUST = WeatherParticlesRegistry.registerSpriteSet(DUST_RESOURCE, sprite -> new DustParticle.Provider(sprite));
        SPLASH = WeatherParticlesRegistry.registerSpriteSet(SPLASH_RESOURCE, sprite -> new OceanSplashParticle.Provider(sprite));
        SPLASH_SMALL = WeatherParticlesRegistry.registerSpriteSet(SPLASH_SMALL_RESOURCE, sprite -> new SmallOceanSplashParticle.Provider(sprite));
        SPLASH_EXPLOSION = WeatherParticlesRegistry.registerSpriteSet(SPLASH_EXPLOSION_RESOURCE, sprite -> new ExplosionOceanSplashParticle.Provider(sprite));
    }

    private static <T extends ParticleOptions> ParticleProvider<ParticleOptions> registerSpriteSet(ResourceLocation resource, ParticleEngine.SpriteParticleRegistration<T> registration) {
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        ParticleEngine.MutableSpriteSet spriteSet = new ParticleEngine.MutableSpriteSet();
        particleEngine.spriteSets.put(resource, spriteSet);
        return registration.create((SpriteSet)spriteSet);
    }
}

