/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.EntityRenderStateExtended;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntityRenderer.class})
public abstract class MixinItemEntityRenderer
extends EntityRenderer<ItemEntity, ItemEntityRenderState> {
    protected MixinItemEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    public void render(ItemEntityRenderState itemRenderState, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, CallbackInfo info) {
        ItemEntity itemEntity = (ItemEntity)((EntityRenderStateExtended)itemRenderState).getEntity();
        float tickDelta = ((EntityRenderStateExtended)itemRenderState).getTickDelta();
        if (ConfigClient.hasItemPhysics() && !itemRenderState.item.isEmpty()) {
            matrixStack.pushPose();
            ItemStack itemStack = itemEntity.getItem();
            AABB.Builder builder = new AABB.Builder();
            itemRenderState.item.visitExtents(arg_0 -> ((AABB.Builder)builder).include(arg_0));
            AABB aABB = builder.build();
            boolean isBlock = aABB.getZsize() > 0.0625;
            float passedTimeMillis = tickDelta * 1.0f / 20.0f * 1000.0f * 0.1f;
            double rotationSpeed = 0.05 * (double)ConfigClient.itemRotationSpeed;
            if (itemEntity.isInWater()) {
                rotationSpeed = 0.002;
            }
            if (itemEntity.onGround()) {
                if (!(isBlock & !(itemStack.is(Items.TRIDENT) | itemStack.is(Items.SPYGLASS)))) {
                    itemEntity.flyDist = 0.0f;
                }
            } else {
                itemEntity.flyDist = (float)((double)itemEntity.flyDist + (double)passedTimeMillis * rotationSpeed);
            }
            int k = 1;
            if (itemStack.getCount() > 48) {
                k = 5;
            } else if (itemStack.getCount() > 32) {
                k = 4;
            } else if (itemStack.getCount() > 16) {
                k = 3;
            } else if (itemStack.getCount() > 1) {
                k = 2;
            }
            float offset = 0.05f;
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotation(itemEntity.bobOffs));
            matrixStack.mulPose((Quaternionfc)Axis.XP.rotation((float)Math.toRadians(90.0) + itemEntity.flyDist));
            if (!isBlock) {
                matrixStack.translate(0.0f, 0.0f, (float)(-(k - 1)) * offset);
            }
            if (!isBlock) {
                for (int i = 0; i < k; ++i) {
                    itemRenderState.item.render(matrixStack, vertexConsumerProvider, light, OverlayTexture.NO_OVERLAY);
                    matrixStack.translate(0.0f, 0.0f, offset);
                }
            } else {
                itemRenderState.item.render(matrixStack, vertexConsumerProvider, light, OverlayTexture.NO_OVERLAY);
            }
            matrixStack.popPose();
            super.render((EntityRenderState)itemRenderState, matrixStack, vertexConsumerProvider, light);
            info.cancel();
        }
    }
}

