/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.diebuddies.minecraft.LevelRendererAccessor;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.render.MainRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public class MixinLevelRenderer
implements LevelRendererAccessor {
    @Shadow
    private ClientLevel level;
    @Unique
    private MainRenderer mainRenderer = new MainRenderer();
    @Unique
    private Matrix4f prjSnow = new Matrix4f();
    @Unique
    private Matrix4f viewSnow = new Matrix4f();

    @Inject(at={@At(value="TAIL")}, method={"renderSectionLayer"})
    private void renderClothOptifine(RenderType blockLayerIn, double xIn, double yIn, double zInm, Matrix4f viewMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (blockLayerIn == RenderType.translucent()) {
            // empty if block
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"renderSectionLayer"})
    private void renderMain(RenderType blockLayerIn, double xIn, double yIn, double zInm, Matrix4f viewMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (blockLayerIn == RenderType.cutout()) {
            this.mainRenderer.renderAll(this.level, blockLayerIn, xIn, yIn, zInm, viewMatrix, projectionMatrix);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderSectionLayer"})
    private void renderLiquid(RenderType blockLayerIn, double xIn, double yIn, double zInm, Matrix4f viewMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (blockLayerIn == RenderType.translucent()) {
            this.mainRenderer.renderLiquid(this.level, blockLayerIn, xIn, yIn, zInm, viewMatrix, projectionMatrix);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"renderBlockEntities"})
    private void renderBlockEntities(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, MultiBufferSource.BufferSource bufferSource2, Camera camera, float f, Frustum frustum, CallbackInfoReturnable<Boolean> info) {
        this.mainRenderer.renderStaticCloth(this.level);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderEntities"})
    private void renderEntities(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, Camera camera, DeltaTracker deltaTracker, List<Entity> list, CallbackInfo info) {
        Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
        this.mainRenderer.renderDynamicCloth(this.level);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderLevel"})
    public void getSnowWorldViewProjection(GraphicsResourceAllocator graphicsResourceAllocator, DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, Matrix4f viewMatrix, Matrix4f projectionMatrix, CallbackInfo info) {
        if (this.level != null) {
            PhysicsMod mod = PhysicsMod.getInstance((Level)this.level);
            this.prjSnow.set((Matrix4fc)projectionMatrix);
            this.viewSnow.set((Matrix4fc)viewMatrix);
            this.prjSnow.mul((Matrix4fc)this.viewSnow, mod.getPhysicsWorld().getSnowWorld().viewProjection);
        }
    }

    @Override
    public MainRenderer getMainRenderer() {
        return this.mainRenderer;
    }

    @Override
    public ClientLevel physicsmod$getLevel() {
        return this.level;
    }
}

