/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.verlet.VerletLine;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Matrix4fStack;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class FishingHookConstraint
implements VerletConstraint {
    private Vector3d playerPosAsync = new Vector3d();
    private Vector3d hookPosAsync = new Vector3d();
    private Vector3d playerPos = new Vector3d();
    private Vector3d hookPos = new Vector3d();
    private FishingHook fishingHook;
    private Player player;
    private FishingHookRenderer fishingHookRenderer;

    public FishingHookConstraint(VerletSimulation simulation, FishingHookRenderer fishingHookRenderer, FishingHook fishingHook, Player player, float tickDelta) {
        int i;
        this.fishingHook = fishingHook;
        this.player = player;
        this.fishingHookRenderer = fishingHookRenderer;
        this.calculatePlayerAndHookPos(tickDelta, this.playerPos, this.hookPos);
        int pointCount = 48;
        double totalLength = ConfigClient.fishingLineLength;
        for (i = 0; i < pointCount; ++i) {
            float perc = (float)(i - 1) / (float)pointCount;
            Vector3d position = new Vector3d(Math.lerp((double)this.playerPos.x, (double)this.hookPos.x, (double)perc), Math.lerp((double)this.playerPos.y, (double)this.hookPos.y, (double)perc), Math.lerp((double)this.playerPos.z, (double)this.hookPos.z, (double)perc));
            VerletPoint point = new VerletPoint(position);
            point.uv.set(0.01f, 0.99f);
            point.rgba.set(0.0f, 0.0f, 0.0f, 1.0f);
            point.locked = i == 0 || i == pointCount - 1;
            simulation.addPoint(point);
        }
        for (i = 0; i < pointCount - 1; ++i) {
            simulation.addStick(new VerletStick(simulation.getPoints().get(i), simulation.getPoints().get(i + 1), totalLength / (double)pointCount));
            simulation.addLine(new VerletLine(simulation.getPoints().get(i), simulation.getPoints().get(i + 1)));
        }
    }

    private void calculatePlayerAndHookPos(float tickDelta, Vector3d playerPos, Vector3d hookPos) {
        float attackAnim = this.player.getAttackAnim(tickDelta);
        float attackAnim2 = Mth.sin((float)(Mth.sqrt((float)attackAnim) * (float)java.lang.Math.PI));
        Vec3 handPos = this.fishingHookRenderer.getPlayerHandPos(this.player, attackAnim2, tickDelta);
        double playerX = handPos.x;
        double playerY = handPos.y;
        double playerZ = handPos.z;
        double hookX = Mth.lerp((double)tickDelta, (double)this.fishingHook.xo, (double)this.fishingHook.getX());
        double hookY = Mth.lerp((double)tickDelta, (double)this.fishingHook.yo, (double)this.fishingHook.getY()) + 0.25;
        double hookZ = Mth.lerp((double)tickDelta, (double)this.fishingHook.zo, (double)this.fishingHook.getZ());
        playerPos.set(playerX, playerY, playerZ);
        hookPos.set(hookX, hookY, hookZ);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        this.calculatePlayerAndHookPos(1.0f, this.playerPosAsync, this.hookPosAsync);
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        VerletPoint armPoint = simulation.getPoints().get(0);
        VerletPoint hookPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        armPoint.position.set((Vector3dc)this.playerPosAsync).sub((Vector3dc)simulation.getOffset());
        hookPoint.position.set((Vector3dc)this.hookPosAsync).sub((Vector3dc)simulation.getOffset());
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderBefore(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
        this.calculatePlayerAndHookPos((float)delta, this.playerPos, this.hookPos);
        VerletPoint armPoint = simulation.getPoints().get(0);
        VerletPoint hookPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        armPoint.bufferPosition.set((Vector3dc)this.playerPos).sub((Vector3dc)simulation.getOffset());
        armPoint.bufferPrevPosition.set((Vector3dc)armPoint.bufferPosition);
        hookPoint.bufferPosition.set((Vector3dc)this.hookPos).sub((Vector3dc)simulation.getOffset());
        hookPoint.bufferPrevPosition.set((Vector3dc)hookPoint.bufferPosition);
    }
}

