/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL32C;

public class ClothRenderer {
    private MainRenderer mainRenderer;
    private double lastRenderPercent;
    private PoseStack tmpStack = new PoseStack();

    public ClothRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void renderDynamicCloth(ClientLevel level, Matrix4f viewMatrix, Matrix4f projectionMatrix) {
        if (level == null) {
            return;
        }
        List<VerletSimulation> dynamicCloth = PhysicsMod.dynamicCloth.get((Object)PhysicsMod.getRenderPass());
        if (dynamicCloth != null && dynamicCloth.size() > 0) {
            GlStateManager._enableDepthTest();
            GlStateManager._disableBlend();
            GlStateManager._disableCull();
            for (int i = 0; i < dynamicCloth.size(); ++i) {
                dynamicCloth.get(i).renderSlow((Level)level);
            }
            dynamicCloth.clear();
            GlStateManager._enableBlend();
        }
    }

    public void renderStaticCloth(ClientLevel level, Matrix4f viewMatrix, Matrix4f projectionMatrix) {
        if (level == null) {
            return;
        }
        VAO.storePreviouslyBoundState();
        for (int i = 0; i < PhysicsMod.clothRenderFast.size(); ++i) {
            ClothRenderCommand renderCommand = PhysicsMod.clothRenderFast.get(i);
            LivingEntity entity = renderCommand.entity;
            if (renderCommand.cloth.playerVAO == null || !(entity instanceof AbstractClientPlayer)) continue;
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            Minecraft.getInstance().getTextureManager().getTexture(player.getSkin().texture()).getTexture();
        }
        PhysicsMod.storeShaderLightDirections();
        PerformanceTracker.startNoFlush("cloth_rendering");
        RenderPass renderPass = this.mainRenderer.bindProperShader(this.mainRenderer.getProperSolidRenderType());
        this.mainRenderer.resetColor();
        this.mainRenderer.setupShader(renderPass);
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (ProjectionType)ProjectionType.PERSPECTIVE);
        GlStateManager._enableDepthTest();
        GlStateManager._enableBlend();
        GlStateManager._blendFuncSeparate((int)GlConst.toGl((SourceFactor)SourceFactor.SRC_ALPHA), (int)GlConst.toGl((DestFactor)DestFactor.ONE_MINUS_SRC_ALPHA), (int)GlConst.toGl((SourceFactor)SourceFactor.ONE), (int)GlConst.toGl((DestFactor)DestFactor.ZERO));
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        GlStateManager._activeTexture((int)33984);
        GlStateManager._disableCull();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL32C.glVertexAttribI2ui((int)Data.OVERLAY.getAttribute(), (int)0, (int)10);
        GL32C.glVertexAttrib4f((int)Data.COLOR.getAttribute(), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (StarterClient.optifabric) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f);
        } else {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_SHADER.getAttribute(), (float)0.0f, (float)0.0f);
        }
        for (int i = 0; i < PhysicsMod.clothRenderFast.size(); ++i) {
            ClothRenderCommand renderCommand = PhysicsMod.clothRenderFast.get(i);
            this.renderFast(renderPass, level, renderCommand);
        }
        PhysicsMod.clothRenderFast.clear();
        renderPass.close();
        VAO.restorePreviouslyBoundState();
        GlStateManager._activeTexture((int)33984);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager._enableCull();
        PhysicsMod.restoreShaderLightDirections();
        PerformanceTracker.end("cloth_rendering");
    }

    private void renderFast(RenderPass renderPass, ClientLevel level, ClothRenderCommand renderCommand) {
        GL32C.glVertexAttribI2ui((int)Data.LIGHT.getAttribute(), (int)(renderCommand.brightness & 0xF0), (int)(renderCommand.brightness >> 16 & 0xF0));
        Vec3 view = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        double renderPercent = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true);
        if (Minecraft.getInstance().isPaused()) {
            renderPercent = this.lastRenderPercent;
        } else {
            this.lastRenderPercent = renderPercent;
        }
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.pushMatrix();
        GpuTexture glID = renderCommand.textureID;
        GlStateManager._activeTexture((int)33984);
        RenderSystem.setShaderTexture((int)0, (GpuTexture)glID);
        GlStateManager._bindTexture((int)((GlTexture)glID).glId());
        LivingEntity entity = renderCommand.entity;
        double px = Mth.lerp((double)renderPercent, (double)entity.xOld, (double)entity.getX());
        double py = Mth.lerp((double)renderPercent, (double)entity.yOld, (double)entity.getY());
        double pz = Mth.lerp((double)renderPercent, (double)entity.zOld, (double)entity.getZ());
        matrixStack.translation((float)(-view.x + px), (float)(-view.y + py), (float)(-view.z + pz));
        renderCommand.modelPart.loadPose(renderCommand.modelPose);
        this.tmpStack.last().pose().set((Matrix4fc)matrixStack);
        ModelPartConstraint.entityTransformation(this.tmpStack, entity, (float)renderPercent);
        ModelPartConstraint.modelPartTransformation(renderCommand.modelPart, this.tmpStack);
        Matrix4f transformation = this.tmpStack.last().pose();
        this.mainRenderer.setupLighting(transformation, renderPass, level, true);
        PhysicsMod.viewMatrix.mul((Matrix4fc)transformation, transformation);
        this.mainRenderer.setupModelViewMatrix(renderPass, transformation, null, true);
        this.mainRenderer.setupPBRTextures();
        this.mainRenderer.setupShaderUniforms(renderPass);
        if (!renderCommand.onlyRenderPlayer) {
            if (ConfigClient.clothSmoothShading) {
                renderCommand.cloth.vao.render();
            } else {
                renderCommand.cloth.vaoFlatShaded.render();
            }
        }
        if (renderCommand.cloth.playerVAO != null && entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            glID = Minecraft.getInstance().getTextureManager().getTexture(player.getSkin().texture()).getTexture();
            RenderSystem.setShaderTexture((int)0, (GpuTexture)glID);
            GlStateManager._bindTexture((int)((GlTexture)glID).glId());
            this.mainRenderer.setupPBRTextures();
            renderCommand.cloth.playerVAO.render();
        }
        matrixStack.popMatrix();
    }
}

