/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPass;
import com.mojang.blaze3d.opengl.GlRenderPipeline;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.mixins.ocean.MixinLightTextureAccessor;
import net.diebuddies.opengl.ArenaBuffer;
import net.diebuddies.opengl.Data;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.OceanMesh;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.ocean.ProxyOceanLayer;
import net.diebuddies.physics.snow.math.AABB3D;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.OceanRippleRenderer;
import net.diebuddies.render.shader.PhysicsShaders;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL32C;

public class OceanRenderer {
    private MainRenderer mainRenderer;
    private OceanRippleRenderer rippleRenderer;
    private int mcEntityLocation = -1;
    private Matrix4f transformation = new Matrix4f();
    private Matrix4f currentPose = new Matrix4f();
    private Matrix3f tmp = new Matrix3f();
    private int wavinessLocation = -1;
    private int waveOffsetLocation = -1;
    private int textureOffsetLocation = -1;
    private int modelOffsetLocation = -1;
    private int physicsGameTimeLocation = -1;
    private int globalGameTimeLocation = -1;
    private int physicsIterationsNormalLocation = -1;
    private int physicsOceanHeightLocation = -1;
    private int oceanWaveHorizontalScaleLocation = -1;
    private int rippleLocation = -1;
    private int foamLocation = -1;
    private int rippleRangeLocation = -1;
    private int foamAmountLocation = -1;
    private int foamOpacityLocation = -1;
    private int lightmapLocation = -1;
    private int rippleActiveTexture = 0;
    private int foamActiveTexture = 26;
    private int lightmapActiveTexture = 27;
    private int activeTexture = 0;
    private int oldTexture;
    private int oldRippleTexture;
    private List<OceanMesh> drawList;

    public OceanRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
        this.drawList = new ObjectArrayList();
        this.rippleRenderer = new OceanRippleRenderer(mainRenderer);
    }

    public void render(PhysicsWorld physics, ClientLevel level, Matrix4fStack matrixStackIn, Vec3 view) {
    }

    private void initRenderingStates(OceanWorld oceanWorld) {
        int shaderId = GL32C.glGetInteger((int)35725);
        this.physicsGameTimeLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_gameTime");
        this.globalGameTimeLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_globalTime");
        this.physicsIterationsNormalLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_iterationsNormal");
        this.physicsOceanHeightLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_oceanHeight");
        this.oceanWaveHorizontalScaleLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_oceanWaveHorizontalScale");
        this.rippleLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_ripples");
        this.foamLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_foam");
        this.lightmapLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_lightmap");
        this.rippleRangeLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_rippleRange");
        this.foamAmountLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_foamAmount");
        this.foamOpacityLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_foamOpacity");
        this.wavinessLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_waviness");
        this.waveOffsetLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_waveOffset");
        this.textureOffsetLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_textureOffset");
        this.modelOffsetLocation = GL32C.glGetUniformLocation((int)shaderId, (CharSequence)"physics_modelOffset");
        if (StarterClient.optifabric) {
            GL32C.glVertexAttrib3f((int)Data.NORMAL.getAttribute(), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL32C.glVertexAttrib3f((int)Data.NORMAL_SHADER.getAttribute(), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (StarterClient.iris) {
            Vector2f midCoord = oceanWorld.getWaterMidCoord();
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_TERRAIN_SHADER.getAttribute(), (float)midCoord.x, (float)midCoord.y);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_TERRAIN_SHADER.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            this.mcEntityLocation = GL20.glGetAttribLocation((int)shaderId, (CharSequence)"mc_Entity");
            if (this.mcEntityLocation != -1) {
                GL32C.glVertexAttrib4f((int)this.mcEntityLocation, (float)Iris.getMaterialID(Blocks.WATER.defaultBlockState()), (float)1.0f, (float)-1.0f, (float)-1.0f);
            }
            this.activeTexture = 15;
        } else if (StarterClient.optifabric) {
            Vector2f midCoord = oceanWorld.getWaterMidCoord();
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)midCoord.x, (float)midCoord.y);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            this.mcEntityLocation = Optifine.isUsingShadersNoInternal() ? 11 : GL20.glGetAttribLocation((int)shaderId, (CharSequence)"mc_Entity");
            if (this.mcEntityLocation != -1) {
                GL32C.glVertexAttrib4f((int)this.mcEntityLocation, (float)Optifine.getMaterialID(Blocks.WATER.defaultBlockState()), (float)Optifine.getRenderType(Blocks.WATER.defaultBlockState()), (float)-1.0f, (float)-1.0f);
            }
            this.activeTexture = 15;
        } else {
            this.activeTexture = 11;
        }
        this.rippleActiveTexture = this.activeTexture - 1;
        GlStateManager._activeTexture((int)(33984 + this.activeTexture));
        this.oldTexture = GL32C.glGetInteger((int)32873);
        GlStateManager._activeTexture((int)(33984 + this.rippleActiveTexture));
        this.oldRippleTexture = GL32C.glGetInteger((int)32873);
        GlStateManager._activeTexture((int)33984);
        GlStateManager._disableCull();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void setupOceanRendering(PhysicsWorld physics, @Nullable ProxyOceanLayer layer, ClientLevel level, RenderPass renderPass, GpuTexture waterTexture) {
        if (level.effects().constantAmbientLight()) {
            RenderSystem.shaderLightDirections[0] = MainRenderer.NETHER_DIFFUSE_LIGHT_0;
            RenderSystem.shaderLightDirections[1] = MainRenderer.NETHER_DIFFUSE_LIGHT_1;
        } else {
            RenderSystem.shaderLightDirections[0] = MainRenderer.DIFFUSE_LIGHT_0;
            RenderSystem.shaderLightDirections[1] = MainRenderer.DIFFUSE_LIGHT_1;
        }
        GlProgram program = ((GlRenderPass)renderPass).pipeline.program();
        if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            if (program.LIGHT0_DIRECTION != null) {
                program.LIGHT0_DIRECTION.set(RenderSystem.shaderLightDirections[0]);
                program.LIGHT0_DIRECTION.upload();
            }
            if (program.LIGHT1_DIRECTION != null) {
                program.LIGHT1_DIRECTION.set(RenderSystem.shaderLightDirections[1]);
                program.LIGHT1_DIRECTION.upload();
            }
        }
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            Optifine.setColorModulator(RenderSystem.getShaderColor());
        } else if (program.COLOR_MODULATOR != null) {
            program.COLOR_MODULATOR.set(RenderSystem.getShaderColor());
            program.COLOR_MODULATOR.upload();
        }
        if (this.physicsGameTimeLocation != -1) {
            GL32C.glUniform1f((int)this.physicsGameTimeLocation, (float)physics.getOceanWorld().getOceanTime());
        }
        if (this.globalGameTimeLocation != -1) {
            GL32C.glUniform1f((int)this.globalGameTimeLocation, (float)physics.getOceanWorld().getGlobalTime());
        }
        if (this.physicsIterationsNormalLocation != -1) {
            GL32C.glUniform1i((int)this.physicsIterationsNormalLocation, (int)(13 + (int)(ConfigClient.oceanDetail * 35.0f)));
        }
        if (this.physicsOceanHeightLocation != -1) {
            GL32C.glUniform1f((int)this.physicsOceanHeightLocation, (float)physics.getOceanWorld().getOceanHeight());
        }
        if (this.oceanWaveHorizontalScaleLocation != -1) {
            GL32C.glUniform1f((int)this.oceanWaveHorizontalScaleLocation, (float)ConfigClient.oceanHorizontalWaveScale);
        }
        if (this.rippleLocation != -1) {
            GL32C.glUniform1i((int)this.rippleLocation, (int)this.rippleActiveTexture);
        }
        if (this.foamLocation != -1) {
            GL32C.glUniform1i((int)this.foamLocation, (int)this.foamActiveTexture);
        }
        if (this.lightmapLocation != -1) {
            GL32C.glUniform1i((int)this.lightmapLocation, (int)this.lightmapActiveTexture);
        }
        if (this.rippleRangeLocation != -1) {
            GL32C.glUniform1f((int)this.rippleRangeLocation, (float)((float)this.rippleRenderer.getRippleRange()));
        }
        if (this.foamAmountLocation != -1) {
            GL32C.glUniform1f((int)this.foamAmountLocation, (float)ConfigClient.oceanFoamAmount);
        }
        if (this.foamOpacityLocation != -1) {
            GL32C.glUniform1f((int)this.foamOpacityLocation, (float)ConfigClient.oceanFoamOpacity);
        }
        if (this.wavinessLocation != -1) {
            GL32C.glUniform1i((int)this.wavinessLocation, (int)this.activeTexture);
        }
        RenderSystem.setShaderTexture((int)0, (GpuTexture)waterTexture);
        GlStateManager._activeTexture((int)33984);
        GlStateManager._bindTexture((int)((GlTexture)waterTexture).glId());
        if (this.foamLocation != -1) {
            int foamTextureID = ((GlTexture)PhysicsMod.foamTexture).glId();
            GlStateManager._activeTexture((int)(33984 + this.foamActiveTexture));
            GL32C.glBindTexture((int)32879, (int)foamTextureID);
        }
        if (this.lightmapLocation != -1) {
            Minecraft mc = Minecraft.getInstance();
            int lightmapTextureID = ((GlTexture)((MixinLightTextureAccessor)mc.gameRenderer.lightTexture()).getTarget()).glId();
            GlStateManager._activeTexture((int)(33984 + this.lightmapActiveTexture));
            GL32C.glBindTexture((int)3553, (int)lightmapTextureID);
        }
        this.bindRippleTexture(layer);
        physics.getOceanWorld().bindForRendering();
    }

    private void bindRippleTexture(ProxyOceanLayer layer) {
        int rippleTextureID = this.rippleRenderer.getRippleTexture(layer);
        GlStateManager._activeTexture((int)(33984 + this.rippleActiveTexture));
        GlStateManager._bindTexture((int)rippleTextureID);
        GlStateManager._activeTexture((int)(33984 + this.activeTexture));
    }

    private RenderPass bindOceanShader() {
        RenderType renderType = RenderType.translucent();
        GlRenderPipeline customPipeline = null;
        if (StarterClient.iris && Iris.isExtending()) {
            if (Iris.isShadowPass()) {
                if (!Iris.renderOceanShadow()) {
                    return null;
                }
                if (Iris.getOceanShadowProgram() != null) {
                    customPipeline = new GlRenderPipeline(renderType.getRenderPipeline(), Iris.getOceanShadowProgram());
                } else {
                    renderType = RenderType.solid();
                }
            } else if (Iris.getOceanProgram() != null) {
                customPipeline = new GlRenderPipeline(renderType.getRenderPipeline(), Iris.getOceanProgram());
            } else {
                renderType = RenderType.translucent();
            }
        } else if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            renderType = PhysicsShaders.OCEAN_PHYSICS;
        }
        RenderPass renderPass = this.mainRenderer.bindProperShader(renderType, customPipeline);
        GlRenderPass glRenderPass = (GlRenderPass)renderPass;
        glRenderPass.encoder.trySetup(glRenderPass);
        return renderPass;
    }

    private boolean isVisible(OceanWorld oceanWorld, OceanMesh oceanMesh, Vec3 view) {
        AABB3D modelBoundingBox = oceanMesh.aabb;
        Vector3d start = modelBoundingBox.start;
        Vector3d end = modelBoundingBox.end;
        float halfHeight = Math.max(0.5f, oceanWorld.getOceanHeight() * 0.5f * oceanMesh.maxInfluence);
        return this.mainRenderer.frustumInt.testAab((float)(start.x - view.x), (float)(start.y - view.y - (double)halfHeight), (float)(start.z - view.z), (float)(end.x - view.x), (float)(end.y - view.y + (double)halfHeight), (float)(end.z - view.z));
    }

    public void renderOcean(RenderPass renderPass, OceanWorld oceanWorld, ClientLevel level, Matrix4f cameraRotationMatrix, Matrix3f normalMatrix, Vec3 view, OceanMesh oceanMesh) {
        int glID = oceanMesh.texture.getID();
        GlStateManager._activeTexture((int)(33984 + this.activeTexture));
        GlStateManager._bindTexture((int)glID);
        Matrix4d oceanTransformation = oceanMesh.transformation;
        this.transformation.m00((float)oceanTransformation.m00());
        this.transformation.m11((float)oceanTransformation.m11());
        this.transformation.m22((float)oceanTransformation.m22());
        this.transformation.m30((float)(oceanTransformation.m30() - view.x));
        this.transformation.m31((float)(oceanTransformation.m31() - view.y));
        this.transformation.m32((float)(oceanTransformation.m32() - view.z));
        cameraRotationMatrix.mul((Matrix4fc)this.transformation, this.currentPose);
        GlProgram program = ((GlRenderPass)renderPass).pipeline.program();
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            Optifine.setModelViewMatrix(this.currentPose);
        } else {
            program.MODEL_VIEW_MATRIX.set(this.currentPose);
            program.MODEL_VIEW_MATRIX.upload();
        }
        if (this.modelOffsetLocation != -1) {
            GL32C.glUniform3f((int)this.modelOffsetLocation, (float)((float)(oceanTransformation.m30() - view.x)), (float)((float)(oceanTransformation.m31() - view.y)), (float)((float)(oceanTransformation.m32() - view.z)));
        }
        if (this.waveOffsetLocation != -1) {
            GL32C.glUniform2f((int)this.waveOffsetLocation, (float)oceanMesh.offsetX, (float)oceanMesh.offsetZ);
        }
        if (this.textureOffsetLocation != -1) {
            GL32C.glUniform2i((int)this.textureOffsetLocation, (int)oceanMesh.textureOffsetX, (int)oceanMesh.textureOffsetZ);
        }
        if (StarterClient.iris) {
            Iris.setNormalMatrix(renderPass, this.currentPose, normalMatrix);
        }
        ArenaBuffer.MemorySegment vertexSegment = oceanMesh.vertexSegment;
        ArenaBuffer.MemorySegment indexSegment = oceanMesh.indexSegment;
        int baseVertex = vertexSegment.offset / oceanWorld.format.getStride();
        GL32C.glDrawElementsBaseVertex((int)4, (int)(indexSegment.size / 2), (int)5123, (long)indexSegment.offset, (int)baseVertex);
    }

    public void setupAttribute(int location, float v0, float v1, float v2, float v3) {
        if (location != -1) {
            GL20.glVertexAttrib4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
        }
    }

    public static void destroy() {
        OceanRippleRenderer.destroy();
    }
}

