/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.vines;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.diebuddies.compat.Sodium;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.minecraft.ChunkHelper;
import net.diebuddies.minecraft.ClientChunkCacheAccessor;
import net.diebuddies.mixins.vines.StorageInvoker;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.vines.DynamicLoader;
import net.diebuddies.physics.vines.DynamicSetting;
import net.diebuddies.physics.vines.VineHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkCache.class})
public class MixinClientChunkManager
implements DynamicLoader,
ClientChunkCacheAccessor {
    @Shadow
    @Final
    protected volatile ClientChunkCache.Storage storage;
    @Shadow
    @Final
    protected ClientLevel level;
    @Unique
    protected Long2ObjectMap<List<DynamicRagdoll>> loadedVines = new Long2ObjectOpenHashMap();
    @Unique
    protected PhysicsMod mod;
    @Unique
    protected LongSet loadedChunksSodiumFix = new LongOpenHashSet();

    @Override
    public void chunkPosChanged() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        ObjectOpenHashSet affectedChunks = new ObjectOpenHashSet();
        while (it.hasNext()) {
            boolean shouldBeLoaded;
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            boolean isLoaded = this.loadedVines.containsKey(chunkIndex);
            if (isLoaded == (shouldBeLoaded = VineHelper.isChunkInRange(chunkX, chunkZ))) continue;
            if (isLoaded) {
                this.unloadDynamicBlockChunk(chunkX, chunkZ, (ObjectSet<Vector3i>)affectedChunks, true);
            } else {
                this.loadDynamicBlockChunk(((ClientChunkCache)this).getChunk(chunkX, chunkZ, false), chunkX, chunkZ, (ObjectSet<Vector3i>)affectedChunks);
            }
            for (Vector3i affectedChunk : affectedChunks) {
                if (StarterClient.sodium) {
                    Sodium.scheduleChunkRebuild(Minecraft.getInstance().levelRenderer, affectedChunk.x, affectedChunk.y, affectedChunk.z, true);
                    continue;
                }
                Minecraft.getInstance().levelRenderer.setSectionDirty(affectedChunk.x, affectedChunk.y, affectedChunk.z, true);
            }
            affectedChunks.clear();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"updateViewRadius"})
    public void updateLoadDistance(int loadDistance, CallbackInfo info) {
        int properLoadDistance = Math.max(loadDistance, 2) + 3;
        LongIterator itLoaded = this.loadedChunksSodiumFix.iterator();
        while (itLoaded.hasNext()) {
            int chunkZ;
            long chunkIndex = itLoaded.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            if (this.isInRadius(properLoadDistance, chunkX, chunkZ = ChunkHelper.getChunkZ(chunkIndex))) continue;
            itLoaded.remove();
        }
        if (this.mod != null) {
            ObjectIterator it = this.loadedVines.long2ObjectEntrySet().iterator();
            while (it.hasNext()) {
                int chunkZ;
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
                long chunkIndex = entry.getLongKey();
                List ragdolls = (List)entry.getValue();
                int chunkX = ChunkHelper.getChunkX(chunkIndex);
                if (this.isInRadius(properLoadDistance, chunkX, chunkZ = ChunkHelper.getChunkZ(chunkIndex))) continue;
                this.unloadRagdolls(ragdolls, false);
                it.remove();
            }
        }
    }

    @Unique
    public boolean isInRadius(int radius, int chunkX, int chunkZ) {
        return Math.abs(chunkX - this.storage.viewCenterX) <= radius && Math.abs(chunkZ - this.storage.viewCenterZ) <= radius;
    }

    @Inject(at={@At(value="HEAD")}, method={"drop"})
    public void drop(ChunkPos chunkPos, CallbackInfo info) {
        int chunkX = chunkPos.x;
        int chunkZ = chunkPos.z;
        long chunkIndex = ChunkHelper.calcChunkIndex(chunkX, chunkZ);
        this.loadedChunksSodiumFix.remove(chunkIndex);
        if (this.mod != null) {
            this.unloadDynamicBlockChunk(chunkX, chunkZ);
        }
    }

    @Unique
    protected void unloadDynamicBlockChunk(int chunkX, int chunkZ) {
        this.unloadDynamicBlockChunk(chunkX, chunkZ, null, false);
    }

    @Unique
    protected void unloadDynamicBlockChunk(int chunkX, int chunkZ, ObjectSet<Vector3i> affectedChunks, boolean removeOneFrameLater) {
        long chunkIndex = ChunkHelper.calcChunkIndex(chunkX, chunkZ);
        List ragdolls = (List)this.loadedVines.remove(chunkIndex);
        if (affectedChunks != null && ragdolls != null) {
            for (DynamicRagdoll ragdoll : ragdolls) {
                for (BlockPos pos : ragdoll.getBlockPositions()) {
                    affectedChunks.add((Object)new Vector3i(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getY()), SectionPos.blockToSectionCoord((int)pos.getZ())));
                }
            }
        }
        this.unloadRagdolls(ragdolls, removeOneFrameLater);
    }

    @Unique
    protected void unloadRagdolls(List<DynamicRagdoll> ragdolls, boolean removeOneFrameLater) {
        if (ragdolls != null) {
            for (DynamicRagdoll ragdoll : ragdolls) {
                if (removeOneFrameLater) {
                    this.mod.sodiumRemoveRagdolls.add(ragdoll);
                    continue;
                }
                this.mod.physicsWorld.removeRagdoll(ragdoll);
            }
        }
    }

    @Override
    public void unloadAllRagdolls() {
        for (List ragdolls : this.loadedVines.values()) {
            this.unloadRagdolls(ragdolls, false);
        }
        this.loadedVines.clear();
    }

    @Override
    public void loadAllRagdolls() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        while (it.hasNext()) {
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            LevelChunk chunk = ((ClientChunkCache)this).getChunk(chunkX, chunkZ, null, false);
            if (!VineHelper.isChunkInRange(chunkX, chunkZ)) continue;
            this.loadDynamicBlockChunk(chunk, chunkX, chunkZ);
        }
    }

    @Override
    public void unloadAllSnow() {
    }

    @Override
    public void loadAllSnow() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        while (it.hasNext()) {
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            LevelChunk levelChunk = ((ClientChunkCache)this).getChunk(chunkX, chunkZ, null, false);
        }
    }

    @Override
    public void unloadAllOcean() {
    }

    @Override
    public void loadAllOcean() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        while (it.hasNext()) {
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            LevelChunk levelChunk = ((ClientChunkCache)this).getChunk(chunkX, chunkZ, null, false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"replaceWithPacketData"})
    public void replaceWithPacketDataHead(int x, int z, FriendlyByteBuf buf, Map<Heightmap.Types, long[]> map, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer, CallbackInfoReturnable<LevelChunk> info) {
        StorageInvoker storageInvoker = (StorageInvoker)this.storage;
        if (!storageInvoker.invokeInRange(x, z)) {
            return;
        }
        int storageIndex = storageInvoker.invokeGetIndex(x, z);
        LevelChunk levelChunk = storageInvoker.invokeGetChunk(storageIndex);
        if (levelChunk != null) {
            ChunkPos chunkPos = levelChunk.getPos();
            int chunkX = chunkPos.x;
            int chunkZ = chunkPos.z;
            if (chunkX != x || chunkZ != z) {
                long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
                this.loadedChunksSodiumFix.remove(chunkIndex);
                if (this.mod != null) {
                    this.unloadDynamicBlockChunk(chunkX, chunkZ);
                }
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"replaceWithPacketData"})
    public void replaceWithPacketData(int x, int z, FriendlyByteBuf buf, Map<Heightmap.Types, long[]> map, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer, CallbackInfoReturnable<LevelChunk> info) {
        LevelChunk chunk = (LevelChunk)info.getReturnValue();
        if (chunk == null) {
            return;
        }
        long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
        this.loadedChunksSodiumFix.add(chunkIndex);
        if (this.mod != null) {
            this.loadCombinedPhysicsChunk(chunk, x, z);
        }
    }

    @Unique
    protected void loadCombinedPhysicsChunk(LevelChunk chunk, int x, int z) {
        boolean snow = ConfigClient.areSnowPhysicsEnabled();
        boolean ocean = ConfigClient.areOceanPhysicsEnabled();
        boolean dynamicBlocks = ConfigClient.areDynamicBlockPhysicsEnabled() && VineHelper.isChunkInRange(x, z);
    }

    @Unique
    protected boolean isValidStorageChunk(@Nullable LevelChunk levelChunk, int x, int z) {
        if (levelChunk == null) {
            return false;
        }
        ChunkPos chunkPos = levelChunk.getPos();
        return chunkPos.x == x && chunkPos.z == z;
    }

    @Unique
    protected void loadSnowChunk(LevelChunk chunk, int x, int z) {
    }

    @Unique
    protected void loadOceanChunk(LevelChunk chunk, int x, int z) {
    }

    @Unique
    protected void loadDynamicBlockChunk(LevelChunk chunk, int x, int z) {
        this.loadDynamicBlockChunk(chunk, x, z, null);
    }

    @Unique
    protected void loadDynamicBlockChunk(LevelChunk chunk, int x, int z, ObjectSet<Vector3i> affectedChunks) {
        long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
    }

    @Override
    public void addVineRagdoll(DynamicRagdoll ragdoll, BlockPos pos) {
        long chunkIndex = ChunkHelper.calcChunkIndex(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        List ragdolls = (List)this.loadedVines.get(chunkIndex);
        if (ragdolls == null) {
            ragdolls = new ObjectArrayList();
            this.loadedVines.put(chunkIndex, (Object)ragdolls);
        }
        ragdolls.add(ragdoll);
    }

    @Override
    public void removeVineRagdoll(DynamicRagdoll ragdoll) {
        BlockPos pos;
        long chunkIndex;
        List ragdolls;
        if (ragdoll.getBlockPositions().size() > 0 && (ragdolls = (List)this.loadedVines.get(chunkIndex = ChunkHelper.calcChunkIndex(SectionPos.blockToSectionCoord((int)(pos = ragdoll.getBlockPositions().get(0)).getX()), SectionPos.blockToSectionCoord((int)pos.getZ())))) != null) {
            ragdolls.remove(ragdoll);
        }
    }

    @Unique
    protected List<DynamicRagdoll> searchConnections(int chunkX, int chunkZ, Long2ObjectMap<BlockState> vines) {
        ObjectArrayList ragdolls = new ObjectArrayList();
        while (vines.size() > 0) {
            DynamicRagdoll ragdoll;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)vines.long2ObjectEntrySet().iterator().next();
            long index = entry.getLongKey();
            BlockState current = (BlockState)entry.getValue();
            int x = (int)(index >> 60) & 0xF;
            int y = (int)(index & 0xFFFFFFFFFFFFFFL);
            int z = (int)(index >> 56) & 0xF;
            DynamicSetting setting = VineHelper.getSetting(current);
            if (setting == null || (ragdoll = setting.createRagdoll(this.mod, current, new BlockPos(x + chunkX * 16, y, z + chunkZ * 16), vines)) == null) continue;
            ragdolls.add(ragdoll);
        }
        return ragdolls;
    }

    @Override
    public void setPhysicsMod(PhysicsMod physicsMod) {
        if (this.mod != null) {
            if (this.mod != physicsMod) {
                VAO.storePreviouslyBoundState();
                this.unloadAllRagdolls();
                this.unloadAllSnow();
                this.unloadAllOcean();
                this.mod = physicsMod;
                if (physicsMod != null) {
                    this.loadAllRagdolls();
                    this.loadAllSnow();
                    this.loadAllOcean();
                }
                VAO.restorePreviouslyBoundState();
            }
        } else {
            this.mod = physicsMod;
            if (physicsMod != null) {
                this.loadAllRagdolls();
                this.loadAllSnow();
                this.loadAllOcean();
            }
        }
    }

    @Override
    public ClientChunkCache.Storage getStorage() {
        return this.storage;
    }
}

