/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.bridge;

import java.nio.file.Path;
import net.diebuddies.physics.Version;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2960;

public class ModLoaderFunctions {
    public static Version getModID() {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModMetadata mod = container.getMetadata();
            if (!mod.getId().equalsIgnoreCase("physicsmod")) continue;
            return new Version(mod.getVersion().getFriendlyString());
        }
        return null;
    }

    public static boolean isModLoaded(String modID) {
        return FabricLoader.getInstance().isModLoaded(modID);
    }

    public static boolean isModVersionOrNewer(String modID, String version) {
        try {
            return net.fabricmc.loader.api.Version.parse((String)version).compareTo((Object)((ModContainer)FabricLoader.getInstance().getModContainer(modID).get()).getMetadata().getVersion()) <= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static String getModloader() {
        return "fabric";
    }

    public static void registerResourcePack(String namespace, String packname) {
        FabricLoader.getInstance().getModContainer("physicsmod").ifPresent(modContainer -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)namespace, (String)packname), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED));
    }
}

