/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.PhysicsIndex;
import net.diebuddies.physics.PhysicsRenderable;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.wind.WeatherDomain;
import net.diebuddies.util.DoublyLinkedList;
import net.minecraft.class_3532;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxActorFlagEnum;
import physx.physics.PxForceModeEnum;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxRigidDynamic;
import physx.physics.PxShape;

public abstract class IRigidBody
implements DoublyLinkedList.NodeStorage<IRigidBody> {
    private static int counter;
    private int hashCode;
    protected PhysicsWorld physics;
    protected PxShape shape;
    protected PxRigidActor rigidBody;
    protected PhysicsRenderable entity;
    private float mass;
    private long lastChunk = Long.MAX_VALUE;
    private float angularDamping;
    private float linearDamping;
    private boolean kinematic;
    private boolean frozen;
    private boolean gravity = true;
    public boolean separateController;
    private boolean destroyed = false;
    private DoublyLinkedList.Node<IRigidBody> node;

    public IRigidBody() {
        this.hashCode = counter++;
    }

    public void destroy() {
        if (!this.destroyed) {
            if (this.entity != null) {
                this.entity.destroy();
            }
            if (this.shape != null) {
                this.shape.release();
            }
            if (this.rigidBody != null) {
                this.rigidBody.release();
            }
        }
        this.destroyed = true;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public PhysicsRenderable getEntity() {
        return this.entity;
    }

    public PxShape getShape() {
        return this.shape;
    }

    public PxRigidActor getRigidBody() {
        return this.rigidBody;
    }

    public void updateTransformations(PhysicsWorld physics, double diff) {
    }

    public void setPhysicsWorld(PhysicsWorld physics) {
        this.physics = physics;
    }

    public void updatePhysics(PhysicsWorld physics, double diff, boolean blocksChanged) {
        PxRigidActor pxRigidActor;
        if (ConfigClient.windPhysics && (pxRigidActor = this.getRigidBody()) instanceof PxRigidBody) {
            PxRigidBody rigidBody = (PxRigidBody)pxRigidActor;
            if (!this.isKinematicOrFrozen()) {
                int rz;
                int ry;
                int rx;
                PxTransform transform = rigidBody.getGlobalPose();
                float posX = MemoryUtil.memGetFloat((long)(transform.getAddress() + 16L));
                float posY = MemoryUtil.memGetFloat((long)(transform.getAddress() + 20L));
                float posZ = MemoryUtil.memGetFloat((long)(transform.getAddress() + 24L));
                Vector3d offset = physics.getOffset();
                WeatherDomain weatherDomain = physics.getWeatherDomain();
                float forceStrength = weatherDomain.getWindStrength(rx = class_3532.method_15357((double)((double)posX + offset.x)), ry = class_3532.method_15357((double)((double)posY + offset.y)), rz = class_3532.method_15357((double)((double)posZ + offset.z)));
                if (forceStrength > 0.001f) {
                    Vector3f windDirection = weatherDomain.getWindDirection(rx, ry, rz);
                    try (MemoryStack mem = MemoryStack.stackPush();){
                        float strengthMultiplier = 0.35f;
                        PxVec3 counterForce = PxVec3.createAt(mem, MemoryStack::nmalloc, windDirection.x * (forceStrength *= strengthMultiplier), windDirection.y * forceStrength * 0.2f, windDirection.z * forceStrength);
                        rigidBody.addForce(counterForce, PxForceModeEnum.eVELOCITY_CHANGE, true);
                    }
                }
            }
        }
    }

    protected void loadChunkPhysics(float x, float y, float z) {
        int cz;
        int cy;
        int cx;
        long chunkIndex;
        Vector3d offset = this.physics.getOffset();
        if (!this.isKinematicOrFrozen() && (chunkIndex = PhysicsIndex.pack(cx = class_3532.method_15357((double)((double)x + offset.x)) >> PhysicsWorld.CHUNK_SIZE_NUM_BITS, cy = class_3532.method_15357((double)((double)y + offset.y)) >> PhysicsWorld.CHUNK_SIZE_NUM_BITS, cz = class_3532.method_15357((double)((double)z + offset.z)) >> PhysicsWorld.CHUNK_SIZE_NUM_BITS)) != this.lastChunk) {
            if (this.lastChunk != Long.MAX_VALUE) {
                this.physics.removeLoadedChunkEntity(this.lastChunk);
            }
            this.lastChunk = chunkIndex;
            this.physics.addLoadedChunkEntity(this.lastChunk);
        }
    }

    public boolean hasTransformationChanged() {
        return !this.kinematic && !this.frozen;
    }

    public void setKinematic(boolean kinematic) {
        if (this.kinematic != kinematic) {
            if (this.rigidBody instanceof PxRigidDynamic) {
                ((PxRigidDynamic)this.rigidBody).setRigidBodyFlag(PxRigidBodyFlagEnum.eKINEMATIC, kinematic);
                if (!this.isKinematicOrFrozen() && this.physics != null && this.lastChunk != Long.MAX_VALUE && kinematic) {
                    this.physics.removeLoadedChunkEntity(this.lastChunk);
                    this.lastChunk = Long.MAX_VALUE;
                }
            }
            this.kinematic = kinematic;
        }
    }

    public boolean isKinematicOrFrozen() {
        return this.kinematic || this.frozen;
    }

    public void setFrozen(boolean frozen) {
        if (this.frozen != frozen) {
            if (frozen) {
                if (!this.isKinematicOrFrozen() && this.physics != null && this.lastChunk != Long.MAX_VALUE) {
                    this.physics.removeLoadedChunkEntity(this.lastChunk);
                    this.lastChunk = Long.MAX_VALUE;
                }
                this.entity.oldPosition.set((Vector3fc)this.entity.position);
                this.entity.oldRotation.set((Quaternionfc)this.entity.rotation);
            }
            this.rigidBody.setActorFlag(PxActorFlagEnum.eDISABLE_SIMULATION, frozen);
            this.frozen = frozen;
        }
    }

    public void recalculateLight() {
        this.entity.invalidateBrightness();
    }

    public void setGravity(boolean gravity) {
        if (this.gravity != gravity) {
            this.rigidBody.setActorFlag(PxActorFlagEnum.eDISABLE_GRAVITY, !gravity);
            this.gravity = gravity;
        }
    }

    public void applyRandomSpawnForces(float strength) {
        PxRigidActor pxRigidActor = this.getRigidBody();
        if (pxRigidActor instanceof PxRigidDynamic) {
            PxRigidDynamic rigidBody = (PxRigidDynamic)pxRigidActor;
            PxVec3 v = rigidBody.getLinearVelocity();
            v.setX((Math.random() - 0.5f) * strength);
            v.setY((Math.random() - 0.5f) * strength);
            v.setZ((Math.random() - 0.5f) * strength);
            rigidBody.setLinearVelocity(v);
        }
    }

    public void applyRandomSpawnForces() {
        this.applyRandomSpawnForces(9.0f);
    }

    public boolean hasGravity() {
        return this.gravity;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setMass(float mass) {
        this.mass = mass;
    }

    public float getMass() {
        return this.mass;
    }

    public void setAngularDamping(float angularDamping) {
        if (this.angularDamping != angularDamping) {
            this.angularDamping = angularDamping;
            ((PxRigidBody)this.rigidBody).setAngularDamping(angularDamping);
        }
    }

    public void setLinearDamping(float linearDamping) {
        if (this.linearDamping != linearDamping) {
            this.linearDamping = linearDamping;
            ((PxRigidBody)this.rigidBody).setLinearDamping(linearDamping);
        }
    }

    public long getLastChunk() {
        return this.lastChunk;
    }

    @Override
    public void setNode(DoublyLinkedList.Node<IRigidBody> node) {
        this.node = node;
    }

    @Override
    public DoublyLinkedList.Node<IRigidBody> getNode() {
        return this.node;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

