/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.math.Math;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.animation.Animation;
import net.diebuddies.physics.animation.AnimationType;
import net.diebuddies.physics.animation.ParticleSpawn;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_761;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PhysicsRenderable {
    public Vector3f position;
    public Vector3f oldPosition;
    public Quaternionf rotation;
    public Quaternionf oldRotation;
    public Vector3f scale;
    public final Matrix4f renderTransformation;
    public List<Model> models = new ObjectArrayList(1);
    private float boundingSphereRadius;
    public Object info;
    public class_2498 sound;
    public long lastSoundTime;
    public PhysicsEntity.Type type;
    private Animation animation;
    public float time;
    private int color;
    private int cachedBrightness;
    private long cachedBrightnessPos = Long.MAX_VALUE;
    public boolean backfaceCulling;
    public boolean shade;
    private boolean dead;

    public PhysicsRenderable(PhysicsEntity entity) {
        this.models = entity.models;
        this.renderTransformation = new Matrix4f((Matrix4dc)entity.getTransformation());
        this.position = this.renderTransformation.getTranslation(new Vector3f());
        this.rotation = this.renderTransformation.getNormalizedRotation(new Quaternionf());
        this.scale = this.renderTransformation.getScale(new Vector3f());
        this.oldPosition = new Vector3f((Vector3fc)this.position);
        this.oldRotation = new Quaternionf((Quaternionfc)this.rotation);
        this.animation = entity.getAnimation();
        this.info = entity.info;
        this.type = entity.type;
        this.time = entity.time;
        this.color = entity.getBGRA();
        this.sound = entity.sound;
        this.backfaceCulling = entity.backfaceCulling;
        this.shade = entity.shade;
        this.calculateBoundingSphereRadius();
    }

    public Matrix4f getRenderTransformation() {
        return this.renderTransformation;
    }

    private void calculateBoundingSphereRadius() {
        if (this.models == null || this.models.size() == 0) {
            return;
        }
        for (int i = 0; i < this.models.size(); ++i) {
            Mesh mesh = this.models.get((int)i).mesh;
            if (mesh == null) continue;
            this.boundingSphereRadius = java.lang.Math.max(this.boundingSphereRadius, mesh.getRadius());
        }
        this.boundingSphereRadius *= java.lang.Math.max(this.scale.x, java.lang.Math.max(this.scale.y, this.scale.z));
    }

    public float getBoundingSphereRadius() {
        return this.boundingSphereRadius;
    }

    public void destroy() {
        this.destroyModels();
    }

    public void destroyModels() {
        if (this.models != null) {
            for (int i = 0; i < this.models.size(); ++i) {
                Model model = this.models.get(i);
                if (model.memorySegment == null) continue;
                model.memorySegment.free();
                model.memorySegment = null;
            }
        }
    }

    public int getLight(class_1937 level, class_2338.class_2339 blockPos) {
        if (!StarterClient.disableLightingCache) {
            long newPos = class_2338.class_2339.method_10064((int)blockPos.method_10263(), (int)blockPos.method_10264(), (int)blockPos.method_10260());
            if (this.cachedBrightnessPos == newPos) {
                return this.cachedBrightness;
            }
            this.cachedBrightnessPos = newPos;
        }
        class_2680 bState = level.method_8320((class_2338)blockPos);
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        int brightness = 0;
        if (!bState.method_26225()) {
            brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
        } else {
            bState = level.method_8320((class_2338)blockPos.method_10103(x, y + 1, z));
            if (!bState.method_26225()) {
                brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
            } else {
                bState = level.method_8320((class_2338)blockPos.method_10103(x, y - 1, z));
                if (!bState.method_26225()) {
                    brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                } else {
                    bState = level.method_8320((class_2338)blockPos.method_10103(x, y, z - 1));
                    if (!bState.method_26225()) {
                        brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                    } else {
                        bState = level.method_8320((class_2338)blockPos.method_10103(x + 1, y, z));
                        if (!bState.method_26225()) {
                            brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                        } else {
                            bState = level.method_8320((class_2338)blockPos.method_10103(x, y, z + 1));
                            if (!bState.method_26225()) {
                                brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                            } else {
                                bState = level.method_8320((class_2338)blockPos.method_10103(x - 1, y, z));
                                if (!bState.method_26225()) {
                                    brightness = class_761.method_23794((class_1920)level, (class_2338)blockPos);
                                }
                            }
                        }
                    }
                }
            }
        }
        blockPos.method_10103(x, y, z);
        if (!StarterClient.disableLightingCache) {
            this.cachedBrightness = brightness;
        }
        return brightness;
    }

    public void invalidateBrightness() {
        this.cachedBrightnessPos = Long.MAX_VALUE;
    }

    public long getCachedBrightnessPos() {
        return this.cachedBrightnessPos;
    }

    public double getDespawnSpeed() {
        return this.animation.speed;
    }

    public void spawnDeathAnimation(PhysicsWorld world, boolean playSound) {
        if (!this.dead) {
            class_1937 level = world.getWorld();
            List<ParticleSpawn> particleSpawns = this.animation.particleSpawns;
            for (int i = 0; i < particleSpawns.size(); ++i) {
                ParticleSpawn particleSpawn = particleSpawns.get(i);
                if (particleSpawn.particle == null || !((double)Math.random() < particleSpawn.spawnChance)) continue;
                for (int j = 0; j < particleSpawn.amount; ++j) {
                    double halfSpread = particleSpawn.spread * 0.5;
                    double px = (double)this.position.x + world.getOffset().x + (double)Math.random() * particleSpawn.spread - halfSpread;
                    double py = (double)this.position.y + world.getOffset().y + (double)Math.random() * particleSpawn.spread - halfSpread;
                    double pz = (double)this.position.z + world.getOffset().z + (double)Math.random() * particleSpawn.spread - halfSpread;
                    level.method_8406(particleSpawn.particle, px, py, pz, particleSpawn.vx, particleSpawn.vy, particleSpawn.vz);
                }
                if (particleSpawn.sound == null || !playSound) continue;
                float pitch = 0.85f + Math.random() * 0.3f;
                level.method_8486((double)this.position.x + world.getOffset().x, (double)this.position.y + world.getOffset().y, (double)this.position.z + world.getOffset().z, particleSpawn.sound, class_3419.field_15251, (float)particleSpawn.soundVolume, pitch, true);
            }
            this.dead = true;
        }
    }

    public void startDespawnAnimation(class_1937 level) {
        if (this.time > this.animation.speed) {
            this.time = this.animation.speed;
        }
    }

    public boolean isDespawning() {
        return this.time <= this.animation.speed;
    }

    public float getDespawnScale(class_1937 level) {
        if (this.time > this.animation.speed) {
            return 1.0f;
        }
        if ((double)this.time <= 0.0) {
            return 0.0f;
        }
        return this.animation.getCurve().get(this.time / this.animation.speed);
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public AnimationType getAnimationType() {
        return this.animation.despawnType;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public float getRed() {
        return (float)(this.color >> 16 & 0xFF) * 0.003921569f;
    }

    public float getGreen() {
        return (float)(this.color >> 8 & 0xFF) * 0.003921569f;
    }

    public float getBlue() {
        return (float)(this.color & 0xFF) * 0.003921569f;
    }

    public float getAlpha() {
        return (float)(this.color >> 24 & 0xFF) * 0.003921569f;
    }

    public int getBGRA() {
        return this.color;
    }
}

