/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.animation;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.diebuddies.config.ConfigAnimations;
import net.diebuddies.physics.animation.Animation;
import net.diebuddies.physics.settings.animation.AnimationEditScreen;
import net.diebuddies.physics.settings.cloth.BaseEntry;
import net.diebuddies.physics.settings.cloth.LabelEntry;
import net.diebuddies.physics.settings.gui.EditButton;
import net.diebuddies.physics.settings.gui.RemoveButton;
import net.diebuddies.physics.settings.gui.legacy.LegacyObjectSelectionList;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class AnimationEditList
extends LegacyObjectSelectionList<BaseEntry> {
    private Long2ObjectMap<Animation> settings;
    private Map<BaseEntry, class_4185> buttons1 = new Object2ObjectOpenHashMap();
    private Map<BaseEntry, class_4185> buttons2 = new Object2ObjectOpenHashMap();

    public AnimationEditList(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.settings = ConfigAnimations.animations;
        this.refreshEntries();
        if (this.getEntry(0) != null) {
            this.setSelected((BaseEntry)this.getEntry(0));
        }
    }

    public void refreshEntries() {
        this.clearEntries();
        this.buttons1 = new Object2ObjectOpenHashMap();
        this.buttons2 = new Object2ObjectOpenHashMap();
        for (Long2ObjectMap.Entry entry : this.settings.long2ObjectEntrySet()) {
            long identifier = entry.getLongKey();
            LabelEntry labelEntry = new LabelEntry((LegacyObjectSelectionList)this, ((Animation)entry.getValue()).name);
            labelEntry.setUserData(identifier);
            this.addEntry(labelEntry);
        }
    }

    public void addSetting(long identifier, Animation animation) {
        this.settings.put(identifier, (Object)animation);
        this.refreshEntries();
    }

    @Override
    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        return super.method_25402(mouseButtonEvent, bl) | this.listButtons(null, mouseButtonEvent, bl, 0.0f, false);
    }

    public boolean listButtons(class_332 guiGraphics, class_11909 mouseButtonEvent, boolean bl, float tickDelta, boolean render) {
        boolean clicked = false;
        for (int i = 0; i < this.getItemCount(); ++i) {
            int entryY = this.getRowTop(i);
            int p = this.getRowBottomCustom(i);
            if (p < this.y0 || entryY > this.y1) continue;
            int entryHeight = this.itemHeight - 4;
            BaseEntry entry = (BaseEntry)this.getEntry(i);
            class_4185 editButton = this.buttons1.computeIfAbsent(entry, key -> new EditButton(this.getRowRight() + 3, entryY, entryHeight, entryHeight - 1, (class_2561)class_2561.method_43470((String)""), source -> {
                Long identifier = (Long)entry.getUserData();
                if (identifier != null) {
                    this.minecraft.method_1507((class_437)new AnimationEditScreen(this.minecraft.field_1755, (Animation)this.settings.get(identifier.longValue()), identifier));
                }
            }));
            editButton.method_46421(this.getRowRight() + 3);
            editButton.method_46419(entryY);
            class_4185 removeButton = this.buttons2.computeIfAbsent(entry, key -> new RemoveButton(this.getRowRight() + 26, entryY, entryHeight, entryHeight - 1, (class_2561)class_2561.method_43470((String)""), source -> {
                this.removeEntry(entry);
                this.settings.remove(((Long)entry.getUserData()).longValue());
                ConfigAnimations.save();
            }));
            removeButton.method_46421(this.getRowRight() + 26);
            removeButton.method_46419(entryY);
            if (!render) {
                if (editButton.method_25402(mouseButtonEvent, bl)) {
                    return true;
                }
                if (!removeButton.method_25402(mouseButtonEvent, bl)) continue;
                return true;
            }
            removeButton.method_25394(guiGraphics, (int)mouseButtonEvent.comp_4798(), (int)mouseButtonEvent.comp_4799(), tickDelta);
            editButton.method_25394(guiGraphics, (int)mouseButtonEvent.comp_4798(), (int)mouseButtonEvent.comp_4799(), tickDelta);
        }
        return clicked;
    }

    @Override
    protected void renderList(class_332 guiGraphics, int x, int scrollAmount, int mouseX, int mouseY, float tickDelta) {
        super.renderList(guiGraphics, x, scrollAmount, mouseX, mouseY, tickDelta);
        this.listButtons(guiGraphics, new class_11909((double)mouseX, (double)mouseY, new class_11910(0, 0)), false, tickDelta, true);
    }

    private int getRowBottomCustom(int i) {
        return this.getRowTop(i) + this.itemHeight;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.width - 20;
    }

    @Override
    public int getRowLeft() {
        return this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    @Override
    public int getRowWidth() {
        return 220;
    }

    @Override
    public void setSelected(BaseEntry entry) {
        super.setSelected(entry);
    }
}

