/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.minecraft.DynamicUniformsExtension;
import net.diebuddies.minecraft.LightUniform;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.render.DynamicUniformStorageExtension;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.PBRDrawCall;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.class_10366;
import net.minecraft.class_10859;
import net.minecraft.class_10866;
import net.minecraft.class_10868;
import net.minecraft.class_11282;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_284;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL32C;

public class ClothRenderer {
    private MainRenderer mainRenderer;
    private List<ClothDrawCall> drawCalls = new ObjectArrayList();
    private double lastRenderPercent;
    private class_4587 tmpStack = new class_4587();

    public ClothRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void renderDynamicCloth(class_638 level, Matrix4f viewMatrix, Matrix4f projectionMatrix) {
        if (level == null) {
            return;
        }
        List<VerletSimulation> dynamicCloth = PhysicsMod.dynamicCloth.get((Object)PhysicsMod.getRenderPass());
        if (dynamicCloth != null && dynamicCloth.size() > 0) {
            for (int i = 0; i < dynamicCloth.size(); ++i) {
                dynamicCloth.get(i).renderSlow((class_1937)level);
            }
            dynamicCloth.clear();
        }
    }

    public void renderStaticCloth(class_638 level, Matrix4f viewMatrix, Matrix4f projectionMatrix) {
        if (level == null || PhysicsMod.clothRenderFast.size() == 0) {
            return;
        }
        VAO.storePreviouslyBoundState();
        PhysicsMod.storeShaderLightDirections();
        PerformanceTracker.startNoFlush("cloth_rendering");
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)MainRenderer.levelProjectionMatrixBuffer.method_71123(projectionMatrix), (class_10366)class_10366.field_54953);
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_310.method_1551().field_1773.method_22975().method_23209();
        class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60025);
        for (int i = 0; i < PhysicsMod.clothRenderFast.size(); ++i) {
            ClothRenderCommand renderCommand = PhysicsMod.clothRenderFast.get(i);
            this.queueDrawCall(level, renderCommand);
        }
        PhysicsMod.clothRenderFast.clear();
        this.uploadDrawCallTransforms();
        RenderPass renderPass = this.mainRenderer.bindProperShader(() -> "Physics Mod Static Cloth", this.mainRenderer.getProperSolidRenderPipeline());
        this.mainRenderer.setupShader(renderPass);
        this.executeDrawCalls(renderPass);
        renderPass.close();
        VAO.restorePreviouslyBoundState();
        GlStateManager._activeTexture((int)33984);
        GlStateManager._enableCull();
        PhysicsMod.restoreShaderLightDirections();
        RenderSystem.restoreProjectionMatrix();
        PerformanceTracker.end("cloth_rendering");
    }

    private void queueDrawCall(class_638 level, ClothRenderCommand renderCommand) {
        class_243 view = class_310.method_1551().field_1773.method_19418().method_19326();
        double renderPercent = class_310.method_1551().method_61966().method_60637(true);
        if (class_310.method_1551().method_1493()) {
            renderPercent = this.lastRenderPercent;
        } else {
            this.lastRenderPercent = renderPercent;
        }
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.pushMatrix();
        class_1309 entity = renderCommand.entity;
        double px = class_3532.method_16436((double)renderPercent, (double)entity.field_6038, (double)entity.method_23317());
        double py = class_3532.method_16436((double)renderPercent, (double)entity.field_5971, (double)entity.method_23318());
        double pz = class_3532.method_16436((double)renderPercent, (double)entity.field_5989, (double)entity.method_23321());
        matrixStack.translation((float)(-view.field_1352 + px), (float)(-view.field_1351 + py), (float)(-view.field_1350 + pz));
        renderCommand.modelPart.method_32085(renderCommand.modelPose);
        this.tmpStack.method_23760().method_23761().set((Matrix4fc)matrixStack);
        ModelPartConstraint.entityTransformation(this.tmpStack, entity, (float)renderPercent);
        ModelPartConstraint.modelPartTransformation(renderCommand.modelPart, this.tmpStack);
        Matrix4f transformation = this.tmpStack.method_23760().method_23761();
        ClothDrawCall drawCall = new ClothDrawCall(this);
        drawCall.light = this.mainRenderer.setupLighting(transformation, level, true);
        drawCall.brightness = renderCommand.brightness;
        drawCall.player = renderCommand.cloth.playerVAO;
        PhysicsMod.viewMatrix.mul((Matrix4fc)transformation, transformation);
        drawCall.transform = MainRenderer.createTransformUniform(transformation);
        if (!renderCommand.onlyRenderPlayer) {
            drawCall.texture = renderCommand.textureID;
            drawCall.fetchPBRTextures(drawCall.texture);
            drawCall.cloth = ConfigClient.clothSmoothShading ? renderCommand.cloth.vao : renderCommand.cloth.vaoFlatShaded;
        }
        if (renderCommand.cloth.playerVAO != null && entity instanceof class_742) {
            class_742 player = (class_742)entity;
            drawCall.playerTexture = class_310.method_1551().method_1531().method_4619(player.method_52814().comp_1626().comp_3627()).method_71659();
            drawCall.fetchPBRTextures(drawCall.playerTexture);
        }
        this.drawCalls.add(drawCall);
        matrixStack.popMatrix();
    }

    public void uploadDrawCallTransforms() {
        DynamicUniformsExtension dynamicUniforms = (DynamicUniformsExtension)RenderSystem.getDynamicUniforms();
        ((DynamicUniformStorageExtension)dynamicUniforms.physicsmod$getDynamicUniformStorage()).physicsmod$writeUniforms(this.drawCalls, drawCall -> drawCall.transform, (drawCall, gpuSlice) -> {
            drawCall.transformBuffer = gpuSlice;
        });
        ((DynamicUniformStorageExtension)dynamicUniforms.physicsmod$getLightUniformStorage()).physicsmod$writeUniforms(this.drawCalls, drawCall -> drawCall.light, (drawCall, gpuSlice) -> {
            drawCall.lightBuffer = gpuSlice;
        });
    }

    private void executeDrawCalls(RenderPass renderPass) {
        int size = this.drawCalls.size();
        class_10866 glRenderPass = (class_10866)renderPass;
        class_5944 program = glRenderPass.field_57868.comp_3802();
        class_284.class_11272 dynamicTransforms = (class_284.class_11272)program.method_34582("DynamicTransforms");
        class_284.class_11272 lighting = (class_284.class_11272)program.method_34582("Lighting");
        GlStateManager._activeTexture((int)33984);
        GlStateManager._disableCull();
        GL32C.glVertexAttribI2ui((int)Data.OVERLAY.getAttribute(), (int)0, (int)10);
        GL32C.glVertexAttrib4f((int)Data.COLOR.getAttribute(), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (StarterClient.optifabric) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f);
        } else {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_SHADER.getAttribute(), (float)0.0f, (float)0.0f);
        }
        for (int i = 0; i < size; ++i) {
            GpuBufferSlice slice;
            ClothDrawCall drawCall = this.drawCalls.get(i);
            GL32C.glVertexAttribI2ui((int)Data.LIGHT.getAttribute(), (int)(drawCall.brightness & 0xF0), (int)(drawCall.brightness >> 16 & 0xF0));
            if (dynamicTransforms != null) {
                slice = drawCall.transformBuffer;
                GL32C.glBindBufferRange((int)35345, (int)dynamicTransforms.comp_4150(), (int)((class_10859)slice.buffer()).field_57842, (long)slice.offset(), (long)slice.length());
            }
            if (lighting != null) {
                slice = drawCall.lightBuffer;
                GL32C.glBindBufferRange((int)35345, (int)lighting.comp_4150(), (int)((class_10859)slice.buffer()).field_57842, (long)slice.offset(), (long)slice.length());
            }
            if (drawCall.cloth != null) {
                GpuTextureView glID = drawCall.texture;
                GlStateManager._activeTexture((int)33984);
                GlStateManager._bindTexture((int)((class_10868)glID.texture()).method_68427());
                drawCall.bindPBRTextures();
                drawCall.cloth.render();
            }
            if (drawCall.player == null) continue;
            GlStateManager._activeTexture((int)33984);
            GlStateManager._bindTexture((int)((class_10868)drawCall.playerTexture.texture()).method_68427());
            drawCall.bindPBRTextures();
            drawCall.player.render();
        }
        this.drawCalls.clear();
    }

    private class ClothDrawCall
    extends PBRDrawCall {
        public class_11282.class_11283 transform;
        public GpuBufferSlice transformBuffer;
        public LightUniform light;
        public GpuBufferSlice lightBuffer;
        @Nullable
        public VAO cloth;
        @Nullable
        public GpuTextureView texture;
        @Nullable
        public VAO player;
        @Nullable
        public GpuTextureView playerTexture;
        public int brightness;

        private ClothDrawCall(ClothRenderer clothRenderer) {
        }
    }
}

