/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.weather;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.minecraft.weather.WindSoundInstance;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.wind.WeatherDomain;
import net.minecraft.class_1117;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public class MixinLevelRenderer {
    @Shadow
    @Final
    private class_310 field_4088;
    @Unique
    private final Long2ObjectMap<class_6880<class_1959>> cachedBiomes = new Long2ObjectOpenHashMap(169);
    @Unique
    private WindSoundInstance windSound;

    @Inject(at={@At(value="TAIL")}, method={"renderLevel"})
    public void resetWeatherLightInvalidation(class_9779 deltaTracker, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f viewMatrix, Matrix4f projectionMatrix, CallbackInfo info) {
        WeatherEffects.invalidateLight = false;
    }

    @Inject(at={@At(value="HEAD")}, method={"setLevel"})
    public void setLevel(@Nullable class_638 clientLevel, CallbackInfo info) {
        if (this.windSound != null) {
            this.windSound.stopWind();
        }
        if (clientLevel != null) {
            this.windSound = new WindSoundInstance(WeatherEffects.WIND_SOUND_EVENT, class_3419.field_15252);
            this.field_4088.method_1483().method_22140((class_1117)this.windSound);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tickRain"}, cancellable=true)
    private void tickRain(class_4184 camera, CallbackInfo info) {
        if (!ConfigClient.weatherParticles) {
            return;
        }
        float precipitationAmount = this.field_4088.field_1687.method_8430(1.0f);
        if (precipitationAmount <= 0.0f) {
            return;
        }
        int checkRange = 6;
        int camX = class_3532.method_15357((double)camera.method_19326().field_1352);
        int camY = class_3532.method_15357((double)camera.method_19326().field_1351);
        int camZ = class_3532.method_15357((double)camera.method_19326().field_1350);
        int spawnableRain = 0;
        int particlesPerBlock = 0;
        particlesPerBlock += (int)(precipitationAmount * (float)ConfigClient.weatherRainParticleAmount);
        particlesPerBlock += (int)(this.field_4088.field_1687.method_8478(1.0f) * (float)ConfigClient.weatherThunderParticleAmount);
        class_638 level = this.field_4088.field_1687;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        this.cachedBiomes.clear();
        for (int zo = camZ - checkRange; zo <= camZ + checkRange; ++zo) {
            for (int xo = camX - checkRange; xo <= camX + checkRange; ++xo) {
                int diffX = xo - camX;
                int diffZ = zo - camZ;
                if (diffX * diffX + diffZ * diffZ > 36) continue;
                mutableBlockPos.method_10103(xo, camY, zo);
                class_6880 biomeHolder = level.method_23753((class_2338)mutableBlockPos);
                class_1959 biome = (class_1959)biomeHolder.comp_349();
                this.cachedBiomes.put(mutableBlockPos.method_10063(), (Object)biomeHolder);
                if (biome.method_48162((class_2338)mutableBlockPos) == class_1959.class_1963.field_9384 && !biomeHolder.method_40225(class_1972.field_9424)) continue;
                int rainToThisHeight = level.method_8624(class_2902.class_2903.field_13197, xo, zo);
                int rainBottom = camY - checkRange;
                int rainTop = camY + checkRange;
                if (rainBottom < rainToThisHeight) {
                    rainBottom = rainToThisHeight;
                }
                if (rainTop < rainToThisHeight) {
                    rainTop = rainToThisHeight;
                }
                if (rainBottom == rainTop) continue;
                int height = rainTop - rainBottom;
                spawnableRain += height * particlesPerBlock;
            }
        }
        int range = 14;
        PhysicsWorld world = PhysicsMod.getInstance((class_1937)level).getPhysicsWorld();
        WeatherDomain weatherDomain = world.getWeatherDomain();
        while (WeatherEffects.aliveParticles < spawnableRain) {
            int rainToThisHeight;
            double zo;
            double yo;
            double xo;
            double distance;
            while ((distance = (xo = (double)Math.random() * 2.0 - 1.0) * xo + (yo = (double)Math.random() * 2.0 - 1.0) * yo + (zo = (double)Math.random() * 2.0 - 1.0) * zo) > 1.0) {
            }
            int x = class_3532.method_15357((double)(camera.method_19326().field_1352 + xo * (double)range));
            int y = class_3532.method_15357((double)(camera.method_19326().field_1351 + yo * (double)range));
            int z = class_3532.method_15357((double)(camera.method_19326().field_1350 + zo * (double)range));
            mutableBlockPos.method_10103(x, camY, z);
            long blockPosUnique = mutableBlockPos.method_10063();
            class_6880 biomeHolder = (class_6880)this.cachedBiomes.computeIfAbsent(blockPosUnique, key -> level.method_23753((class_2338)mutableBlockPos));
            class_1959 biome = (class_1959)biomeHolder.comp_349();
            if (biome.method_48162((class_2338)mutableBlockPos) == class_1959.class_1963.field_9384 && !biomeHolder.method_40225(class_1972.field_9424) || y < (rainToThisHeight = level.method_8624(class_2902.class_2903.field_13197, x, z))) continue;
            int rainBottom = y - range;
            int rainTop = y + range;
            if (rainBottom < rainToThisHeight) {
                rainBottom = rainToThisHeight;
            }
            if (rainTop < rainToThisHeight) {
                rainTop = rainToThisHeight;
            }
            if (rainBottom == rainTop) continue;
            mutableBlockPos.method_10103(x, rainBottom, z);
            level.method_8320((class_2338)mutableBlockPos).method_26215();
            Vector3f windDirection = weatherDomain.getWindDirection(x, y, z);
            float forceStrength = weatherDomain.getWindStrengthFast();
            if (biomeHolder.method_40225(class_1972.field_9424)) {
                strength = 0.3;
                baseVX = (double)Math.random() * strength - strength * 0.5;
                baseVY = -0.05;
                baseVZ = (double)Math.random() * strength - strength * 0.5;
                level.method_17452((class_2394)WeatherEffects.PHYSICS_DUST, true, (double)((float)x + Math.random()), (double)((float)y + Math.random()), (double)((float)z + Math.random()), baseVX += (double)(windDirection.x * forceStrength) * 2.0, baseVY, baseVZ += (double)(windDirection.z * forceStrength) * 2.0);
            } else if (biome.method_39927((class_2338)mutableBlockPos)) {
                strength = 0.13;
                baseVX = (double)Math.random() * strength - strength * 0.5;
                baseVY = -0.6;
                baseVZ = (double)Math.random() * strength - strength * 0.5;
                level.method_17452((class_2394)WeatherEffects.PHYSICS_RAIN, true, (double)((float)x + Math.random()), (double)((float)y + Math.random()), (double)((float)z + Math.random()), baseVX += (double)(windDirection.x * forceStrength), baseVY, baseVZ += (double)(windDirection.z * forceStrength));
            } else {
                strength = 0.2;
                baseVX = (double)Math.random() * strength - strength * 0.5;
                baseVY = -0.05;
                baseVZ = (double)Math.random() * strength - strength * 0.5;
                level.method_17452((class_2394)WeatherEffects.PHYSICS_SNOW, true, (double)((float)x + Math.random()), (double)((float)y + Math.random()), (double)((float)z + Math.random()), baseVX += (double)(windDirection.x * forceStrength), baseVY, baseVZ += (double)(windDirection.z * forceStrength));
            }
            ++WeatherEffects.aliveParticles;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderSnowAndRain"}, cancellable=true)
    private void renderSnowAndRain(class_765 lightTexture, float f, double d, double e, double g, CallbackInfo info) {
        if (ConfigClient.weatherParticles) {
            info.cancel();
        }
    }
}

