/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.settings.cloth.ClothConstants;
import net.diebuddies.physics.verlet.Cloth;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.physics.verlet.constraints.OceanPhysicsDisplacementConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.diebuddies.util.EntityLevelPacked;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_638;
import org.joml.Matrix4d;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class PhysicsClothLayer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    private Map<EntityLevelPacked, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    private EntityLevelPacked tmp = new EntityLevelPacked();

    public PhysicsClothLayer(class_3883<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(class_4587 poseStack, class_4597 multiBufferSource, int light, class_1309 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        boolean renderCloth;
        boolean bl = renderCloth = class_310.method_1551().field_1724 != entity;
        if (renderCloth && !PhysicsMod.hudRendering && ConfigClient.capePhysics) {
            class_1937 level;
            Iterator<Map.Entry<EntityLevelPacked, VerletSimulation>> it = this.simulations.entrySet().iterator();
            while (it.hasNext()) {
                if (!it.next().getValue().destroyed) continue;
                it.remove();
            }
            Map<String, ConfigCloth.ClothList> customizationParts = ConfigCloth.getCustomizationParts((class_1297)entity);
            if (customizationParts == null || entity.method_5767()) {
                return;
            }
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            boolean renderFast = false;
            if (camera.method_19328().method_10262((class_2382)entity.method_24515()) > (double)(ConfigClient.clothEntityRange * ConfigClient.clothEntityRange)) {
                renderFast = true;
            }
            if (!((level = entity.method_5770()) instanceof class_638)) {
                return;
            }
            for (Map.Entry<String, ConfigCloth.ClothList> customizationPart : customizationParts.entrySet()) {
                String part = customizationPart.getKey();
                ConfigCloth.ClothList clothList = customizationPart.getValue();
                for (String clothPiece : clothList.getClothPieces()) {
                    class_630 modelPart;
                    class_583 model;
                    Cloth cloth = PhysicsClothLayer.getCloth(clothPiece);
                    if (cloth == null || ClothConstants.doesArmorHideCloth(cloth, entity) || ClothConstants.isElytraHidingCloth(cloth, part, entity)) continue;
                    if (renderFast || !cloth.rules.isDynamic()) {
                        model = this.method_17165();
                        modelPart = ModelPartConstraint.getPart((class_3879)model, part);
                        if (cloth == null || modelPart == null) continue;
                        PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, entity, modelPart, light));
                        continue;
                    }
                    this.renderAndCreateClothSimulation(level, entity, part, cloth, clothPiece, light);
                    if (cloth.playerMesh == null) continue;
                    model = this.method_17165();
                    modelPart = ModelPartConstraint.getPart((class_3879)model, part);
                    if (cloth == null || modelPart == null) continue;
                    PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, entity, modelPart, light).setOnlyRenderPlayer(true));
                }
            }
        }
    }

    private void renderAndCreateClothSimulation(class_1937 level, class_1309 entity, String attachedTo, Cloth cloth, String clothPiece, int light) {
        this.tmp.set((class_1297)entity, attachedTo, clothPiece, level);
        VerletSimulation simulation = this.simulations.get(this.tmp);
        if (simulation == null) {
            boolean alwaysInstantlyUpdate;
            class_583 model = this.method_17165();
            if (!ModelPartConstraint.exists((class_583<class_1309>)model, attachedTo)) {
                return;
            }
            int quality = entity == class_310.method_1551().field_1724 ? 90 : 45;
            simulation = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(level.method_27983().method_29177())), quality, 0.855);
            ModelPartConstraint modelPartConstraint = new ModelPartConstraint(simulation, cloth.rules.getIgnoreParts(), entity, attachedTo, (class_3879)model);
            class_4587 modelMatrix = new class_4587();
            ModelPartConstraint.entityTransformation(modelMatrix, simulation, entity, (class_3879)model, 1.0f);
            modelPartConstraint.modelPartTransformation(modelMatrix.method_23760().method_23761());
            Matrix4d partTransformation = new Matrix4d();
            partTransformation.set((Matrix4fc)modelMatrix.method_23760().method_23761());
            simulation.getConstraints().clear();
            simulation.addConstraint(new OceanPhysicsDisplacementConstraint((class_1297)entity));
            simulation.addConstraint(modelPartConstraint);
            simulation.addConstraint(new WorldConstraint((class_1297)entity));
            simulation.brightness = light;
            simulation.addCloth(cloth, cloth.getTexture((class_1297)entity), partTransformation, false);
            simulation.setOffset(new Vector3d(entity.method_23317(), entity.method_23318(), entity.method_23321()).add((Vector3dc)simulation.getOffset()), false);
            simulation.setTransformation(partTransformation);
            simulation.setBufferTransformation(partTransformation);
            simulation.updateOffsets();
            PhysicsWorld physicsWorld = PhysicsMod.getInstance((class_1937)level).physicsWorld;
            modelPartConstraint.initAsyncData(physicsWorld, simulation);
            modelPartConstraint.changeInstantly = true;
            modelPartConstraint.updateAfter(0.0, simulation);
            simulation.downloadData();
            simulation.alwaysFetchInstantly = alwaysInstantlyUpdate = entity == class_310.method_1551().field_1724;
            this.simulations.put(new EntityLevelPacked((class_1297)entity, attachedTo, clothPiece, level), simulation);
            if (alwaysInstantlyUpdate) {
                physicsWorld.addVerletSimulation(0, simulation);
            } else {
                physicsWorld.addVerletSimulation(simulation);
            }
        } else {
            if (!simulation.destroyed) {
                simulation.active = true;
                simulation.brightness = light;
            }
            if (cloth != simulation.cloth) {
                simulation.destroyed = true;
            }
        }
        if (StarterClient.optifabric) {
            PhysicsMod.optifineClothCompat.add(simulation);
        } else {
            simulation.renderSlow(level);
        }
    }

    public static Cloth getCloth(String cloth) {
        return PhysicsMod.cloth.get(cloth);
    }
}

