/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.mobs;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.cloth.BaseEntry;
import net.diebuddies.physics.settings.gui.EditButton;
import net.diebuddies.physics.settings.gui.legacy.LegacyObjectSelectionList;
import net.diebuddies.physics.settings.mobs.MobEntry;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class MobSelectionList
extends LegacyObjectSelectionList<BaseEntry> {
    public String filter = "";
    public Consumer<String> editMob;
    public boolean hasEditButton;
    private Map<BaseEntry, class_4185> buttons = new Object2ObjectOpenHashMap();

    public MobSelectionList(class_310 minecraft, int i, int j, int k, int l, int m, Consumer<String> editMob) {
        super(minecraft, i, j, k, l, m);
        this.editMob = editMob;
        this.hasEditButton = editMob != null;
        this.refreshEntries();
    }

    public MobSelectionList(class_310 minecraft, int i, int j, int k, int l, int m) {
        this(minecraft, i, j, k, l, m, null);
    }

    public void refreshEntries() {
        this.clearEntries();
        this.buttons = new Object2ObjectOpenHashMap();
        ObjectArrayList ids = new ObjectArrayList();
        for (class_1299<?> type : PhysicsMod.renderers.keySet()) {
            ids.add(class_1299.method_5890(type).toString());
        }
        Collections.sort(ids);
        MobEntry first = null;
        for (String id : ids) {
            if (!id.toLowerCase().contains(this.filter.toLowerCase())) continue;
            MobEntry entry = new MobEntry((LegacyObjectSelectionList)this, id);
            this.addEntry(entry);
            if (first != null) continue;
            first = entry;
        }
        if (first != null) {
            this.ensureVisible(first);
        }
    }

    @Override
    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        return super.method_25402(mouseButtonEvent, bl) | this.listButtons(null, mouseButtonEvent, bl, 0.0f, false);
    }

    public boolean listButtons(class_332 guiGraphics, class_11909 mouseButtonEvent, boolean bl, float tickDelta, boolean render) {
        if (this.editMob != null) {
            boolean clicked = false;
            int m = this.getItemCount();
            for (int index = 0; index < m; ++index) {
                int entryY = this.getRowTop(index);
                int p = this.getRowBottomCustom(index);
                if (p < this.y0 || entryY > this.y1) continue;
                int entryHeight = this.itemHeight - 4;
                BaseEntry entry = (BaseEntry)this.getEntry(index);
                class_4185 button = this.buttons.computeIfAbsent(entry, key -> new EditButton(this.getRowRight() + 3, entryY, entryHeight, entryHeight - 1, (class_2561)class_2561.method_43470((String)""), source -> this.editMob.accept((String)entry.getUserData())));
                button.method_46421(this.getRowRight() + 3);
                button.method_46419(entryY);
                if (!render) {
                    if (!button.method_25402(mouseButtonEvent, bl)) continue;
                    return true;
                }
                button.method_25394(guiGraphics, (int)mouseButtonEvent.comp_4798(), (int)mouseButtonEvent.comp_4799(), tickDelta);
            }
            return clicked;
        }
        return false;
    }

    private int getRowBottomCustom(int i) {
        return this.getRowTop(i) + this.itemHeight;
    }

    @Override
    protected int getScrollbarPosition() {
        if (this.hasEditButton) {
            return this.width - 20;
        }
        return super.getScrollbarPosition();
    }

    @Override
    protected void renderList(class_332 guiGraphics, int x, int scrollAmount, int mouseX, int mouseY, float tickDelta) {
        super.renderList(guiGraphics, x, scrollAmount, mouseX, mouseY, tickDelta);
        this.listButtons(guiGraphics, new class_11909((double)mouseX, (double)mouseY, new class_11910(0, 0)), false, tickDelta, true);
    }
}

