/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.smoke;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsRenderable;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.SmokeRigidBody;
import net.diebuddies.physics.animation.Animation;
import net.diebuddies.physics.animation.AnimationType;
import net.diebuddies.physics.animation.CurveType;
import net.diebuddies.physics.smoke.SmokeDomain;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxForceModeEnum;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidDynamic;

public class SmokeDomainBasic
extends SmokeDomain {
    private static final double EFFECT_DISTANCE = 0.5;
    private static final double EFFECT_DISTANCE_INV = 2.0;
    private static final double EFFECT_DISTANCE_SQUARED = 0.25;
    private static final double DENSITY_DISTANCE = 1.0;
    private static final double DENSITY_DISTANCE_SQUARED = 1.0;
    private static final double EFFECT_STRENGTH = 2.25;
    private static final float MAX_SPEED = 2.9f;
    private static final float DESPAWN_ANIMATION_TIME = 2.0f;
    private static final float DAMPING = 0.07f;
    private static final float GRAVITY_MODIFIER = 0.7f;
    private static final int CHUNK_SIZE = (int)java.lang.Math.round(java.lang.Math.ceil(0.5));
    private Animation smokeDespawn;
    private final Map<Vector3i, ChunkInfo> chunks;
    private final Object2BooleanMap<Vector3i> masks;
    private final List<SmokeRigidBody> allParticles;
    private final List<SmokeRigidBody> changedParticles;
    private final Vector3i tmp = new Vector3i();
    private final class_2338.class_2339 blockPos = new class_2338.class_2339();
    public int density;
    public Random random;

    public SmokeDomainBasic(PhysicsWorld world) {
        super(world);
        this.chunks = new Object2ObjectOpenHashMap();
        this.masks = new Object2BooleanOpenHashMap();
        this.masks.defaultReturnValue(false);
        this.changedParticles = new ObjectArrayList();
        this.allParticles = new ObjectArrayList();
        this.random = new Random(System.nanoTime());
        this.smokeDespawn = new Animation("smoke_vanish", CurveType.Ease_out, 2.0f);
        this.smokeDespawn.despawnType = AnimationType.Vanish;
    }

    @Override
    public void update(double diff) {
        this.updateParticles(diff);
        super.update(diff);
    }

    private void updateParticles(double diff) {
        Vector3i chunk;
        int i;
        Iterator<Map.Entry<Vector3i, ChunkInfo>> it = this.chunks.entrySet().iterator();
        this.changedParticles.clear();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        double maxSmokeDistance = ConfigClient.smokePhysicsRange * ConfigClient.smokePhysicsRange;
        Vector3d physicsOffset = this.world.getOffset();
        for (i = 0; i < this.allParticles.size(); ++i) {
            SmokeRigidBody body = this.allParticles.get(i);
            if (body.isDestroyed()) continue;
            PxTransform transform = body.getRigidBody().getGlobalPose();
            float posX = MemoryUtil.memGetFloat((long)(transform.getAddress() + 16L));
            float posY = MemoryUtil.memGetFloat((long)(transform.getAddress() + 20L));
            float posZ = MemoryUtil.memGetFloat((long)(transform.getAddress() + 24L));
            body.pos.set((double)posX, (double)posY, (double)posZ);
            PhysicsRenderable entity = body.getEntity();
            entity.oldPosition.set((Vector3fc)entity.position);
            entity.position.set(posX, posY, posZ);
            body.averagedDensity = org.joml.Math.lerp((float)body.density, (float)body.averagedDensity, (float)0.94f);
            body.density = 1.0f;
            if (!(camPos.method_1028(body.pos.x + physicsOffset.x, body.pos.y + physicsOffset.y, body.pos.z + physicsOffset.z) > maxSmokeDistance)) continue;
            this.world.removeBody(body);
            if (body.getLastChunk() != Long.MAX_VALUE && !body.isKinematicOrFrozen()) {
                this.world.removeLoadedChunkEntity(body.getLastChunk());
            }
            this.world.getDynamicsWorld().removeActor(body.getRigidBody());
            body.destroy();
        }
        while (it.hasNext()) {
            Map.Entry<Vector3i, ChunkInfo> entry = it.next();
            chunk = entry.getKey();
            ChunkInfo chunkInfo = entry.getValue();
            List<SmokeRigidBody> particles = chunkInfo.bodies;
            for (int i2 = 0; i2 < particles.size(); ++i2) {
                SmokeRigidBody particle = particles.get(i2);
                if (particle.isDestroyed()) {
                    this.allParticles.remove(particle);
                    particles.remove(i2--);
                    continue;
                }
                Vector3d pos = particle.pos;
                int cx = Math.fastRound(pos.x) / CHUNK_SIZE;
                int cy = Math.fastRound(pos.y) / CHUNK_SIZE;
                int cz = Math.fastRound(pos.z) / CHUNK_SIZE;
                if (cx == chunk.x && cy == chunk.y && cz == chunk.z) continue;
                particles.remove(i2--);
                this.changedParticles.add(particle);
            }
            if (particles.size() != 0) continue;
            it.remove();
        }
        for (i = 0; i < this.changedParticles.size(); ++i) {
            SmokeRigidBody particle = this.changedParticles.get(i);
            Vector3d pos = particle.pos;
            int cx = Math.fastRound(pos.x) / CHUNK_SIZE;
            int cy = Math.fastRound(pos.y) / CHUNK_SIZE;
            int cz = Math.fastRound(pos.z) / CHUNK_SIZE;
            this.tmp.set(cx, cy, cz);
            ChunkInfo chunkInfo = this.chunks.get(this.tmp);
            if (chunkInfo == null) {
                chunkInfo = new ChunkInfo(this);
                this.chunks.put(new Vector3i((Vector3ic)this.tmp), chunkInfo);
            }
            chunkInfo.bodies.add(particle);
        }
        for (Map.Entry<Vector3i, ChunkInfo> entry : this.chunks.entrySet()) {
            chunk = entry.getKey();
            ChunkInfo info = entry.getValue();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        this.tmp.set(chunk.x + x, chunk.y + y, chunk.z + z);
                        ChunkInfo otherInfo = this.chunks.get(this.tmp);
                        if (otherInfo == null || !this.masks.getBoolean((Object)this.tmp)) continue;
                        this.repellParticles(info.bodies, otherInfo.bodies);
                    }
                }
            }
            this.repellParticles(info.bodies, info.bodies);
            for (int i3 = 0; i3 < info.bodies.size(); ++i3) {
                this.updateParticle(info.bodies.get(i3), diff);
            }
            this.masks.put((Object)chunk, true);
        }
        this.masks.clear();
    }

    private void updateParticle(SmokeRigidBody particle, double diff) {
        PhysicsRenderable entity = particle.getEntity();
        Vector3d pos = particle.pos;
        double x = pos.x;
        double y = pos.y;
        double z = pos.z;
        Vector3d offset = this.world.getOffset();
        if (!particle.airDespawn && SmokeDomainBasic.isInOpenAir(this.world.getLevel(), class_3532.method_15357((double)(x + offset.x)), class_3532.method_15357((double)(y + offset.y)), class_3532.method_15357((double)(z + offset.z)))) {
            entity.time = (float)java.lang.Math.min((double)entity.time, java.lang.Math.max(2.0, ConfigClient.particleDespawnTimeSmoke + (double)Math.random() * ConfigClient.particleDespawnTimeVarianceSmoke));
            particle.airDespawn = true;
        }
        PxRigidBody rigidBody = (PxRigidBody)particle.getRigidBody();
        Vector3f gravity = this.world.getDynamicsWorld().getGravity();
        Vector3d velocity = particle.vel;
        try (MemoryStack mem = MemoryStack.stackPush();){
            PxVec3 v = rigidBody.getLinearVelocity();
            float vx = MemoryUtil.memGetFloat((long)v.getAddress());
            float vy = MemoryUtil.memGetFloat((long)(v.getAddress() + 4L));
            float vz = MemoryUtil.memGetFloat((long)(v.getAddress() + 8L));
            float cvx = (float)Math.clamp(velocity.x, (double)-2.9f, (double)2.9f);
            float cvy = (float)Math.clamp(velocity.y, (double)-2.9f, (double)2.9f);
            float cvz = (float)Math.clamp(velocity.z, (double)-2.9f, (double)2.9f);
            PxVec3 repellForce = PxVec3.createAt(mem, MemoryStack::nmalloc, -vx * 0.07f - gravity.x * (float)diff * 0.7f + cvx, -vy * 0.07f - gravity.y * (float)diff * 0.7f + cvy, -vz * 0.07f - gravity.z * (float)diff * 0.7f + cvz);
            rigidBody.addForce(repellForce, PxForceModeEnum.eVELOCITY_CHANGE);
        }
        velocity.set(0.0);
    }

    private void repellParticles(List<SmokeRigidBody> particles, List<SmokeRigidBody> otherParticles) {
        boolean same = particles == otherParticles;
        for (int i = 0; i < particles.size(); ++i) {
            SmokeRigidBody particle1 = particles.get(i);
            Vector3d pos1 = particle1.pos;
            if (this.density != -1) {
                particle1.density = this.density;
            }
            for (int j = 0; j < otherParticles.size(); ++j) {
                SmokeRigidBody particle2 = otherParticles.get(j);
                if (particle1 == particle2) continue;
                Vector3d pos2 = particle2.pos;
                double dx = pos1.x - pos2.x;
                double dy = pos1.y - pos2.y;
                double dz = pos1.z - pos2.z;
                double distanceSquared = dx * dx + dy * dy + dz * dz;
                if (distanceSquared < 1.0) {
                    particle1.density += 1.0f;
                    particle2.density += 1.0f;
                }
                if (!(distanceSquared < 0.25)) continue;
                double length = java.lang.Math.sqrt(distanceSquared);
                double effect = 1.0 - length * 2.0;
                double invLength = 1.0 / length;
                if (length <= 0.001) {
                    dy = 1.0;
                    effect = 1.0;
                    invLength = 1.0;
                }
                double totalStrength = 2.25 * effect;
                particle1.vel.add((dx *= invLength) * totalStrength, (dy *= invLength) * totalStrength, (dz *= invLength) * totalStrength);
                if (same) continue;
                particle2.vel.add(-dx * totalStrength, -dy * totalStrength, -dz * totalStrength);
            }
        }
    }

    @Override
    public void clearParticles() {
        for (int i = 0; i < this.allParticles.size(); ++i) {
            this.allParticles.get((int)i).getEntity().time = -1.0f;
        }
    }

    @Override
    public void spawnParticle(double x, double y, double z, float scale) {
        if (!ConfigClient.smokePhysics) {
            return;
        }
        if (this.allParticles.size() > ConfigClient.smokeParticleLimit) {
            for (int i = 0; i < this.allParticles.size(); ++i) {
                IRigidBody body = this.allParticles.get(i);
                if (body.isDestroyed() || !((double)body.getEntity().time >= 0.0)) continue;
                body.getEntity().time = -1.0f;
                break;
            }
        }
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.SMOKE, null);
        entity.models = null;
        int cx = Math.fastRound(x) / CHUNK_SIZE;
        int cy = Math.fastRound(y) / CHUNK_SIZE;
        int cz = Math.fastRound(z) / CHUNK_SIZE;
        this.tmp.set(cx, cy, cz);
        ChunkInfo chunkInfo = this.chunks.get(this.tmp);
        if (chunkInfo == null) {
            chunkInfo = new ChunkInfo(this);
            this.chunks.put(new Vector3i((Vector3ic)this.tmp), chunkInfo);
        }
        entity.getTransformation().translation(x, y, z);
        entity.setAnimation(this.smokeDespawn);
        entity.setColor(this.random.nextInt());
        SmokeRigidBody body = this.world.addSmokeSphere(entity, 0.15f * scale);
        body.pos.set(x, y, z);
        ((PxRigidDynamic)body.getRigidBody()).setMaxAngularVelocity(0.0f);
        body.setGravity(false);
        chunkInfo.bodies.add(body);
        this.allParticles.add(body);
    }

    @Override
    public void executeExplosion(Explosion explosion) {
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (int i = 0; i < 300; ++i) {
            double x = (double)Math.random() - 0.5;
            double y = (double)Math.random() - 0.5;
            double z = (double)Math.random() - 0.5;
            double vectorLength = java.lang.Math.sqrt(x * x + y * y + z * z);
            while (vectorLength == 0.0) {
                x = (double)Math.random() - 0.5;
                y = (double)Math.random() - 0.5;
                z = (double)Math.random() - 0.5;
                vectorLength = java.lang.Math.sqrt(x * x + y * y + z * z);
            }
            x /= vectorLength;
            y /= vectorLength;
            z /= vectorLength;
            double length = (double)Math.random() * java.lang.Math.max(1.0, (double)explosion.strength);
            x = x * length + explosion.position.x;
            y = y * length + explosion.position.y;
            z = z * length + explosion.position.z;
            blockPos.method_10102(x, y, z);
            class_1937 level = this.world.getLevel();
            class_2680 state = level.method_8320((class_2338)blockPos);
            class_3610 fluidState = state.method_26227();
            if (fluidState.method_15761() != 0 || class_2248.method_9614((class_265)state.method_26218((class_1922)level, (class_2338)blockPos)) && !state.method_26220((class_1922)level, (class_2338)blockPos).method_1110()) continue;
            this.spawnParticle(x, y, z, Math.random() * 2.5f + 1.0f);
        }
    }

    @Override
    public int particleCount() {
        return this.allParticles.size();
    }

    @Override
    public int fillInstances(class_243 cameraPos, float[] smokepos, float[] smokeposnew, byte[] smokelight) {
        PhysicsWorld physics = this.getWorld();
        Vector3d physicsOffset = physics.getOffset();
        List<SmokeRigidBody> smokeParticles = this.allParticles;
        int count = 0;
        for (int i = 0; i < smokeParticles.size(); ++i) {
            SmokeRigidBody body = smokeParticles.get(i);
            if (body.isDestroyed()) continue;
            this.prepareSmokeInstances(physics, physics.getLevel(), cameraPos, body.getEntity(), body, physicsOffset.x, physicsOffset.y, physicsOffset.z, count, smokepos, smokeposnew, smokelight);
            ++count;
        }
        return count;
    }

    private void prepareSmokeInstances(PhysicsWorld physics, class_1937 level, class_243 view, PhysicsRenderable particle, SmokeRigidBody body, double ox, double oy, double oz, int offset, float[] smokepos, float[] smokeposnew, byte[] smokelight) {
        Vector3f oldPosition = particle.oldPosition;
        Vector3f position = particle.position;
        this.blockPos.method_10102((double)position.x + ox, (double)position.y + oy, (double)position.z + oz);
        int brightness = particle.getLight(level, this.blockPos);
        int dstOffset = offset * 4;
        byte scale = (byte)(Math.remapClamp((double)particle.scale.x, 0.25, 5.0, 0.0, 1.0) * 255.0);
        smokelight[dstOffset] = (byte)(particle.getBGRA() & 0xFF);
        smokelight[dstOffset + 1] = (byte)(particle.getBGRA() >> 8 & 0xFF);
        smokelight[dstOffset + 2] = (byte)(brightness >> 4 & 0xF | brightness >> 16 & 0xF0);
        smokelight[dstOffset + 3] = scale;
        double animationScale = particle.getDespawnScale(level);
        smokepos[dstOffset] = oldPosition.x;
        smokepos[dstOffset + 1] = oldPosition.y;
        smokepos[dstOffset + 2] = oldPosition.z;
        smokepos[dstOffset + 3] = java.lang.Math.min(1.0f, (float)animationScale);
        smokeposnew[dstOffset] = position.x;
        smokeposnew[dstOffset + 1] = position.y;
        smokeposnew[dstOffset + 2] = position.z;
        smokeposnew[dstOffset + 3] = body.averagedDensity;
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.allParticles.size(); ++i) {
            this.allParticles.get(i).destroy();
        }
        this.allParticles.clear();
    }

    class ChunkInfo {
        public List<SmokeRigidBody> bodies = new ObjectArrayList();

        public ChunkInfo(SmokeDomainBasic this$0) {
        }
    }
}

