/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.compat.Iris;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletQuad;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.ModelCube;
import net.diebuddies.physics.verlet.constraints.RenderConstraint;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.shader.PhysicsShaders;
import net.minecraft.class_10378;
import net.minecraft.class_1058;
import net.minecraft.class_11701;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2215;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2546;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import net.minecraft.class_9307;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.lwjgl.system.MemoryUtil;

public class BannerConstraint
implements VerletConstraint {
    private List<ModelCube> partsToCheck;
    private Matrix4d transformation = new Matrix4d();
    private Matrix4d invTransformation = new Matrix4d();
    private VerletHelper helper = new VerletHelper();
    private Vector3d invPoint = new Vector3d();
    private Vector2f[] tmpUV;
    private Matrix4f[] textureMatrices;
    private class_9307 patterns;
    private class_1767 baseColor;
    private class_11701 materialSet;
    private class_2338 blockPos;
    private class_2680 blockState;

    public BannerConstraint(VerletSimulation simulation, class_10378 bannerModel, class_9307 patterns, class_1767 baseColor, class_2338 pos, class_2680 state, class_11701 materialSet) {
        int i;
        this.materialSet = materialSet;
        this.patterns = patterns;
        this.baseColor = baseColor;
        this.blockPos = pos;
        this.blockState = state;
        List<VerletConstraint> constraints = simulation.getConstraints();
        for (int i2 = 0; i2 < constraints.size(); ++i2) {
            if (!(constraints.get(i2) instanceof RenderConstraint)) continue;
            constraints.remove(i2--);
        }
        this.partsToCheck = new ObjectArrayList();
        bannerModel.method_63513().forEach(part -> this.partsToCheck.add(new ModelCube((class_630)part)));
        this.calculateTransformation(simulation, 1.0f);
        int capeXPoints = 9;
        int capeYPoints = 17;
        double distance = 0.15000000001500002;
        VerletPoint[][] points = new VerletPoint[capeXPoints][capeYPoints];
        float uvXOff = 0.015625f;
        float uvYOff = 0.015625f;
        float uvXMod = 0.3125f;
        float uvYMod = 0.625f;
        for (int y = 0; y < points[0].length; ++y) {
            for (int x = 0; x < points.length; ++x) {
                Vector3d position = new Vector3d((double)x * distance - (double)capeXPoints * 0.5 * distance + distance * 0.5, (double)y * distance, -0.08928571428571429);
                this.transformation.transformPosition(position);
                VerletPoint point = new VerletPoint(position);
                point.uv.set((float)x / (float)(points.length - 1) * uvXMod + uvXOff, (float)y / (float)(points[0].length - 1) * uvYMod + uvYOff);
                if (y == 0) {
                    point.locked = true;
                }
                points[x][y] = point;
                simulation.addPoint(points[x][y]);
            }
        }
        for (int x = 0; x < points.length; ++x) {
            for (int y = 0; y < points[0].length; ++y) {
                if (x < points.length - 1) {
                    simulation.addStick(new VerletStick(points[x][y], points[x + 1][y]));
                }
                if (y < points[0].length - 1) {
                    simulation.addStick(new VerletStick(points[x][y], points[x][y + 1]));
                }
                if (x >= points.length - 1 || y >= points[0].length - 1) continue;
                simulation.addQuad(new VerletQuad(points[x][y + 1], points[x + 1][y + 1], points[x + 1][y], points[x][y]));
                simulation.addStick(new VerletStick(points[x][y], points[x + 1][y + 1]));
                simulation.addStick(new VerletStick(points[x + 1][y], points[x][y + 1]));
            }
        }
        simulation.calculateNormals();
        simulation.downloadData();
        this.calculateTransformation(simulation, 1.0f);
        List<VerletQuad> quads = simulation.getQuads();
        int drawCalls = java.lang.Math.min(17, patterns.comp_2428().size() + 1);
        int size = quads.size();
        this.tmpUV = new Vector2f[drawCalls * size * 4];
        this.textureMatrices = new Matrix4f[drawCalls];
        for (i = 0; i < this.tmpUV.length; ++i) {
            this.tmpUV[i] = new Vector2f();
        }
        for (i = 0; i < 17 && i < patterns.comp_2428().size() + 1; ++i) {
            class_4730 bannerMaterial = null;
            if (i == 0) {
                bannerMaterial = class_4722.field_49769;
            } else {
                class_9307.class_9308 layer = (class_9307.class_9308)patterns.comp_2428().get(i - 1);
                bannerMaterial = class_4722.method_33081((class_6880)layer.comp_2429());
            }
            if (bannerMaterial == null) {
                this.textureMatrices[i] = new Matrix4f();
                continue;
            }
            class_1058 sprite = materialSet.method_73030(bannerMaterial);
            float minU = sprite.method_4594();
            float maxU = sprite.method_4577();
            float minV = sprite.method_4593();
            float maxV = sprite.method_4575();
            float xScale = maxU - minU;
            float yScale = maxV - minV;
            this.textureMatrices[i] = new Matrix4f().translate(minU, minV, 0.0f).scale(xScale, yScale, 0.0f);
            for (int j = 0; j < quads.size(); ++j) {
                VerletQuad quad = quads.get(j);
                this.remap(quad.point1.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4]);
                this.remap(quad.point2.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 1]);
                this.remap(quad.point3.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 2]);
                this.remap(quad.point4.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 3]);
            }
        }
    }

    private void calculateTransformation(VerletSimulation simulation, float tickDelta) {
        Vector3d offset = simulation.getOffset();
        Matrix4d test = new Matrix4d();
        if (offset != null) {
            test.translate((double)this.blockPos.method_10263() - offset.x, (double)this.blockPos.method_10264() - offset.y, (double)this.blockPos.method_10260() - offset.z);
        } else {
            test.translate((double)this.blockPos.method_10263(), (double)this.blockPos.method_10264(), (double)this.blockPos.method_10260());
        }
        if (this.blockState.method_26204() instanceof class_2215) {
            test.translate(0.5, 0.5, 0.5);
            blockRotation = (float)(-((Integer)this.blockState.method_11654((class_2769)class_2215.field_9924)).intValue() * 360) / 16.0f;
            test.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(blockRotation));
        } else {
            test.translate(0.5, -0.1666666716337204, 0.5);
            blockRotation = -((class_2350)this.blockState.method_11654((class_2769)class_2546.field_11722)).method_10144();
            test.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(blockRotation));
            test.translate(0.0, -0.3125, -0.4375);
        }
        test.scale(0.6666667, -0.6666667, -0.6666667);
        if (simulation.getOffset() == null) {
            long gameTime = 0L;
            float n = ((float)java.lang.Math.floorMod((long)(this.blockPos.method_10263() * 7 + this.blockPos.method_10264() * 9 + this.blockPos.method_10260() * 13) + gameTime, 100L) + tickDelta) / 100.0f;
            float xRot = (-0.0125f + 0.01f * class_3532.method_15362((float)((float)java.lang.Math.PI * 2 * n))) * (float)java.lang.Math.PI;
            double yPos = -32.0;
            test.translate(0.0, yPos / 16.0, 0.0);
            if (xRot != 0.0f) {
                test.rotate((Quaternionfc)class_7833.field_40714.rotation(xRot));
            }
        }
        this.transformation.set((Matrix4dc)test);
        this.transformation.invert(this.invTransformation);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        for (int i = 0; i < this.partsToCheck.size(); ++i) {
            ModelCube cube = this.partsToCheck.get(i);
            cube.pose = cube.part.method_32084();
            cube.updateHitbox();
        }
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
        this.doCollisionCheck(percent, simulation);
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    private void doCollisionCheck(double percent, VerletSimulation simulation) {
    }

    public void translateAndRotate(class_4587 poseStack, class_5603 pose) {
        poseStack.method_22904((double)pose.comp_2997() / 16.0, (double)pose.comp_2998() / 16.0, (double)pose.comp_2999() / 16.0);
        if (pose.comp_3002() != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotation(pose.comp_3002()));
        }
        if (pose.comp_3001() != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(pose.comp_3001()));
        }
        if (pose.comp_3000() != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(pose.comp_3000()));
        }
    }

    @Override
    public void renderBefore(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderAfter(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(Matrix4fStack matrixStack, double renderPercent, VerletSimulation simulation) {
        int brightness = simulation.brightness;
        List<VerletQuad> quads = simulation.getQuads();
        int size = quads.size();
        RenderSystem.setTextureMatrix((Matrix4f)new Matrix4f());
        float[] color = new float[4];
        if (simulation.getQuads().size() > 0) {
            List<VerletPoint> points = simulation.getPoints();
            for (int i = 0; i < points.size(); ++i) {
                points.get(i).updateRenderPosition(renderPercent);
            }
            class_4597.class_4598 buffer = MainRenderer.bufferSource;
            for (int i = 0; i < 17 && i < this.patterns.comp_2428().size() + 1; ++i) {
                class_4730 bannerMaterial;
                int icolor;
                if (i == 0) {
                    icolor = this.baseColor.method_7787();
                    bannerMaterial = class_4722.field_49769;
                } else {
                    class_9307.class_9308 layer = (class_9307.class_9308)this.patterns.comp_2428().get(i - 1);
                    icolor = layer.comp_2430().method_7787();
                    bannerMaterial = class_4722.method_33081((class_6880)layer.comp_2429());
                }
                color[0] = (float)class_9848.method_61327((int)icolor) / 255.0f;
                color[1] = (float)class_9848.method_61329((int)icolor) / 255.0f;
                color[2] = (float)class_9848.method_61331((int)icolor) / 255.0f;
                color[3] = (float)class_9848.method_61320((int)icolor) / 255.0f;
                if (bannerMaterial == null) continue;
                class_1058 sprite = this.materialSet.method_73030(bannerMaterial);
                int drawCallIndex = i * size * 4;
                GpuTextureView bannerTexture = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_71659();
                class_1921 renderType = StarterClient.iris && Iris.isExtending() ? (i == 0 ? PhysicsShaders.PHYSICS_CLOTH_RENDER_IRIS.apply(bannerTexture) : PhysicsShaders.PHYSICS_BANNER_RENDER_IRIS.apply(bannerTexture)) : PhysicsShaders.PHYSICS_BANNER_RENDER.apply(bannerTexture);
                class_4588 vertexConsumer = buffer.method_73477(renderType);
                for (int j = 0; j < quads.size(); ++j) {
                    VerletQuad quad = quads.get(j);
                    int multiple = j * 4;
                    int uvIndex = drawCallIndex + multiple;
                    if (ConfigClient.clothSmoothShading) {
                        this.bufferVertex(vertexConsumer, renderPercent, quad.point1.renderPosition, this.tmpUV[uvIndex], quad.point1.bufferNormal, brightness, color);
                        this.bufferVertex(vertexConsumer, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.point2.bufferNormal, brightness, color);
                        this.bufferVertex(vertexConsumer, renderPercent, quad.point3.renderPosition, this.tmpUV[uvIndex + 2], quad.point3.bufferNormal, brightness, color);
                        this.bufferVertex(vertexConsumer, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.point4.bufferNormal, brightness, color);
                        continue;
                    }
                    this.bufferVertex(vertexConsumer, renderPercent, quad.point1.renderPosition, this.tmpUV[uvIndex], quad.bufferNormal, brightness, color);
                    this.bufferVertex(vertexConsumer, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.bufferNormal, brightness, color);
                    this.bufferVertex(vertexConsumer, renderPercent, quad.point3.renderPosition, this.tmpUV[uvIndex + 2], quad.bufferNormal, brightness, color);
                    this.bufferVertex(vertexConsumer, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.bufferNormal, brightness, color);
                }
            }
            buffer.method_22993();
        }
    }

    public void drawWithShader(class_9801 renderedBuffer) {
    }

    private void _drawWithShader(class_9801 renderedBuffer) {
    }

    private void remap(Vector2f uv, float minU, float maxU, float minV, float maxV, Vector2f dst) {
        dst.set(Math.remap(uv.x, 0.0f, 1.0f, minU, maxU), Math.remap(uv.y, 0.0f, 1.0f, minV, maxV));
    }

    private void bufferVertex(class_4588 bufferbuilder, double renderPercent, Vector3d position, Vector2f uv, Vector3d normal, int brightness, float[] color) {
        bufferbuilder.method_22912((float)position.x, (float)position.y, (float)position.z).method_22915(color[0], color[1], color[2], 1.0f).method_22913(uv.x, uv.y).method_22922(class_4608.field_21444).method_60803(brightness).method_22914((float)normal.x, (float)normal.y, (float)normal.z);
    }

    private void updateUV(long pointer, int offset, Vector2f uv) {
        MemoryUtil.memPutFloat((long)(pointer + (long)offset + 16L), (float)uv.x);
        MemoryUtil.memPutFloat((long)(pointer + (long)offset + 20L), (float)uv.y);
    }

    private void updateColor(long pointer, int offset, float[] color) {
        MemoryUtil.memPutByte((long)(pointer + (long)offset + 12L), (byte)((byte)(color[0] * 255.0f)));
        MemoryUtil.memPutByte((long)(pointer + (long)offset + 13L), (byte)((byte)(color[1] * 255.0f)));
        MemoryUtil.memPutByte((long)(pointer + (long)offset + 14L), (byte)((byte)(color[2] * 255.0f)));
    }
}

