/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.diebuddies.config.ConfigBlocks;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.AABBf;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.physics.BlockUpdate;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.JsonUnbakedModelHolder;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsRenderable;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.settings.blocks.BlockPhysicsType;
import net.diebuddies.physics.settings.blocks.BlockSetting;
import net.minecraft.class_10419;
import net.minecraft.class_1058;
import net.minecraft.class_10802;
import net.minecraft.class_10819;
import net.minecraft.class_10820;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11954;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6677;
import net.minecraft.class_776;
import net.minecraft.class_783;
import net.minecraft.class_7833;
import net.minecraft.class_785;
import net.minecraft.class_789;
import net.minecraft.class_824;
import net.minecraft.class_827;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import physx.common.PxVec3;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidDynamic;

public class PhysicsUpdater {
    private static final Map<class_2248, class_2350> textureSides = new Object2ObjectOpenHashMap();
    private Matrix4d tmpMatrix = new Matrix4d();

    public void updatePhysics(PhysicsMod mod, class_638 level, class_243 cameraPos, PhysicsWorld physics) {
        if (mod.updatedLightBlocks.size() > 0) {
            LongIterator it = mod.updatedLightBlocks.iterator();
            if (!StarterClient.disableLightingCache) {
                for (IRigidBody body : physics.getBodies()) {
                    PhysicsRenderable entity = body.getEntity();
                    long cached = entity.getCachedBrightnessPos();
                    if (cached == Long.MAX_VALUE || !mod.updatedLightBlocks.contains(cached)) continue;
                    entity.invalidateBrightness();
                }
                physics.getSmokeDomain().invalidateBrightness(mod.updatedLightBlocks);
                for (Liquid liquid : physics.getLiquids()) {
                    liquid.invalidateBrightness(mod.updatedLightBlocks);
                }
            }
            WeatherEffects.invalidateLight = true;
            mod.updatedLightBlocks.clear();
        }
        mod.removeUpdates.clear();
        for (int i = mod.updateQueue.size() - 1; i >= 0; --i) {
            BlockUpdate blockUpdate = mod.updateQueue.get(i);
            if (!mod.fallingBlocks.isEmpty() && mod.fallingBlocks.contains(blockUpdate.pos)) continue;
            mod.removeUpdates.add(blockUpdate);
        }
        mod.fallingBlocks.clear();
        mod.updateQueue.clear();
        ObjectArrayList newParts = new ObjectArrayList();
        ObjectArrayList newPartsVoxel = new ObjectArrayList();
        double maxActivationDistanceSqr = ConfigClient.blockPhysicsRange * ConfigClient.blockPhysicsRange;
        class_824 berd = class_310.method_1551().method_31975();
        for (BlockUpdate bu : mod.removeUpdates) {
            BlockSetting blockSetting;
            class_827 renderer;
            if (bu.blockEntity != null && (renderer = berd.method_3550(bu.blockEntity)) != null) {
                blockSetting = ConfigBlocks.getBlockSetting(bu.state.method_26204());
                if (!(cameraPos.method_1028((double)bu.pos.method_10263(), (double)bu.pos.method_10264(), (double)bu.pos.method_10260()) < maxActivationDistanceSqr) && !(ConfigClient.blockPhysicsRange > 319.999)) continue;
                if (blockSetting.getType() == BlockPhysicsType.FRACTURED || blockSetting.getType() == BlockPhysicsType.FRACTURED_VOXEL || blockSetting.getType() == BlockPhysicsType.BLOCKY) {
                    PhysicsEntity blocky;
                    PhysicsEntity entity = mod.renderBlockIntoEntity(PhysicsEntity.Type.BLOCK, (class_827<class_2586, class_11954>)renderer, bu.blockEntity, bu.state, bu.pos);
                    if (entity != null) {
                        physics.addBlockParticle(entity).applyRandomSpawnForces();
                    }
                    if (blockSetting.getType() == BlockPhysicsType.FRACTURED) {
                        newParts.addAll(this.getBlockData(physics, bu, bu.level));
                        continue;
                    }
                    if (blockSetting.getType() == BlockPhysicsType.FRACTURED_VOXEL) {
                        newPartsVoxel.addAll(this.getBlockData(physics, bu, bu.level));
                        continue;
                    }
                    if (blockSetting.getType() != BlockPhysicsType.BLOCKY || (blocky = mod.renderBlockIntoEntity(bu.level, PhysicsEntity.Type.BLOCK, bu.state, bu.pos, false)) == null) continue;
                    physics.addBlockParticle(blocky).applyRandomSpawnForces();
                    continue;
                }
                if (blockSetting.getType() != BlockPhysicsType.PARTICLES) continue;
                double percent = this.calculateChance(physics.getBodies().size());
                if (mod.removeUpdates.size() > 8) {
                    percent = java.lang.Math.min(percent, 0.1);
                } else if (mod.removeUpdates.size() == 1) {
                    percent = java.lang.Math.max(0.1, percent);
                }
                this.spawnBlockBreakParticles(bu.level, bu.state, bu.pos, percent);
                continue;
            }
            if (bu.state.method_26204() == class_2246.field_10375 || bu.state.method_26204() == class_2246.field_10379 || bu.state.method_26217() == class_2464.field_11455) continue;
            blockSetting = ConfigBlocks.getBlockSetting(bu.state.method_26204());
            if (!(cameraPos.method_1028((double)bu.pos.method_10263(), (double)bu.pos.method_10264(), (double)bu.pos.method_10260()) < maxActivationDistanceSqr) && !(ConfigClient.blockPhysicsRange > 319.999)) continue;
            if (blockSetting.getType() == BlockPhysicsType.FRACTURED) {
                newParts.addAll(this.getBlockData(physics, bu, bu.level));
                continue;
            }
            if (blockSetting.getType() == BlockPhysicsType.FRACTURED_VOXEL) {
                newPartsVoxel.addAll(this.getBlockData(physics, bu, bu.level));
                continue;
            }
            if (blockSetting.getType() == BlockPhysicsType.BLOCKY) {
                PhysicsEntity entity = mod.renderBlockIntoEntity(bu.level, PhysicsEntity.Type.BLOCK, bu.state, bu.pos, false);
                if (entity == null) continue;
                physics.addBlockParticle(entity).applyRandomSpawnForces();
                continue;
            }
            if (blockSetting.getType() != BlockPhysicsType.PARTICLES) continue;
            double percent = this.calculateChance(physics.getBodies().size());
            if (mod.removeUpdates.size() > 8) {
                percent = java.lang.Math.min(percent, 0.1);
            } else if (mod.removeUpdates.size() == 1) {
                percent = java.lang.Math.max(0.1, percent);
            }
            this.spawnBlockBreakParticles(bu.level, bu.state, bu.pos, percent);
        }
        double chance = this.calculateChance(physics.getBodies().size());
        int qsize = newParts.size() + newPartsVoxel.size();
        if (qsize == 1) {
            chance = 1.0;
        } else if (qsize > 10) {
            chance = java.lang.Math.min(chance, 0.3);
        }
        this.addPhysicsBlocks((List<PhysicsEntity>)newParts, chance, physics, false);
        this.addPhysicsBlocks((List<PhysicsEntity>)newPartsVoxel, chance, physics, true);
        while (!mod.entityBlocks.isEmpty()) {
            PhysicsEntity particle = mod.entityBlocks.poll();
            if (particle.noVolume) continue;
            physics.addBlockParticle(particle).applyRandomSpawnForces();
        }
        while (!mod.ragdolls.isEmpty()) {
            Ragdoll ragdoll = mod.ragdolls.poll();
            physics.addRagdoll(ragdoll);
        }
        while (!mod.blockUpdates.isEmpty()) {
            class_2338 pos = mod.blockUpdates.poll();
            physics.queue(() -> physics.blockUpdate(pos));
        }
        while (!mod.explosions.isEmpty()) {
            physics.applyExplosion(mod.explosions.poll());
        }
    }

    private void addPhysicsBlocks(List<PhysicsEntity> newParts, double chance, PhysicsWorld physics, boolean voxel) {
        for (PhysicsEntity particle : newParts) {
            int index;
            double volume = particle.getVolume();
            List<Mesh> mesh = PhysicsMod.brokenBlock;
            List<Mesh> physicsMesh = null;
            if (!((double)Math.random() < chance)) continue;
            if (chance < 0.5 || (double)physics.getBodies().size() > (double)ConfigClient.maxPhysicsObjects * 0.4) {
                index = Math.randomInt(PhysicsMod.brokenBlocksLittle.size());
                if (voxel) {
                    mesh = PhysicsMod.brokenBlocksLittleVoxel.get(index);
                    physicsMesh = PhysicsMod.brokenBlocksLittle.get(index);
                } else {
                    mesh = PhysicsMod.brokenBlocksLittle.get(index);
                }
            } else {
                index = Math.randomInt(PhysicsMod.brokenBlocksLots.size());
                if (voxel) {
                    mesh = PhysicsMod.brokenBlocksLotsVoxel.get(index);
                    physicsMesh = PhysicsMod.brokenBlocksLots.get(index);
                } else {
                    mesh = PhysicsMod.brokenBlocksLots.get(index);
                }
            }
            if (volume < 0.05) {
                mesh = PhysicsMod.brokenBlock;
            } else if (volume < 0.9) {
                index = Math.randomInt(PhysicsMod.brokenBlocksLittle.size());
                if (voxel) {
                    mesh = PhysicsMod.brokenBlocksLittleVoxel.get(index);
                    physicsMesh = PhysicsMod.brokenBlocksLittle.get(index);
                } else {
                    mesh = PhysicsMod.brokenBlocksLittle.get(index);
                }
            }
            physics.addBlockParticle(mesh, physicsMesh, particle);
        }
    }

    private List<PhysicsEntity> getBlockData(PhysicsWorld physics, BlockUpdate update, class_1937 level) {
        ObjectArrayList particles = new ObjectArrayList();
        class_2338 pos = update.pos;
        class_2680 state = update.state;
        class_1087 bakedModel = class_310.method_1551().method_1554().method_4743().method_3335(state);
        List parts = bakedModel.method_68512((class_5819)new class_6677(42L));
        for (class_10889 part : parts) {
            JsonUnbakedModelHolder unbakedModel = PhysicsMod.loadedModels.get(part);
            if (state.method_26204() == class_2246.field_10580 || state.method_26204() == class_2246.field_10240 || state.method_26204() == class_2246.field_10556) {
                unbakedModel = null;
            }
            if (unbakedModel != null) {
                PhysicsEntity entity;
                this.addParticles((List<PhysicsEntity>)particles, unbakedModel, level, update);
                if (particles.size() != 0 || bakedModel == null || (entity = PhysicsMod.getInstance(level).renderBlockIntoEntity(PhysicsEntity.Type.BLOCK, bakedModel, update.state, update.pos, false)) == null) continue;
                physics.addBlockParticle(entity).applyRandomSpawnForces();
                continue;
            }
            PhysicsEntity particle = new PhysicsEntity(PhysicsEntity.Type.BLOCK, update.state);
            class_310 minecraft = class_310.method_1551();
            class_776 ren = minecraft.method_1541();
            class_1087 model = ren.method_3349(state);
            class_243 blockOffset = update.state.method_26226(update.pos);
            particle.getTransformation().translation((double)pos.method_10263() + 0.5 + blockOffset.field_1352, (double)pos.method_10264() + 0.5 + blockOffset.field_1351, (double)pos.method_10260() + 0.5 + blockOffset.field_1350);
            BlockSetting blockSetting = ConfigBlocks.getBlockSetting(state.method_26204());
            particle.getTransformation().scale((double)((float)blockSetting.getScale()));
            particle.models.get((int)0).texture = model.method_68511();
            particle.models.get((int)0).textureID = class_310.method_1551().method_1531().method_4619(model.method_68511().method_45852()).method_71659();
            int color = class_310.method_1551().method_1505().method_1697(update.state, (class_1920)level, update.pos, 0);
            if (color == -1) {
                color = -1;
            }
            particle.setColor(color);
            if (update.state.method_26204() == class_2246.field_10593 || update.state.method_26204() == class_2246.field_10219) {
                particle.setColor(-1);
            }
            particles.add(particle);
        }
        return particles;
    }

    public List<class_785> getBlockModelElements(class_10819 model) {
        class_10820 class_108202 = model.method_68044();
        if (class_108202 instanceof class_10802) {
            class_10802 simpleGeometry = (class_10802)class_108202;
            return simpleGeometry.comp_3753();
        }
        return new ObjectArrayList();
    }

    private void addParticles(List<PhysicsEntity> particles, JsonUnbakedModelHolder unbakedModel, class_1937 level, BlockUpdate update) {
        class_2680 state = update.state;
        class_2338 pos = update.pos;
        class_243 blockOffset = state.method_26226(pos);
        class_2350 textureDirection = textureSides.getOrDefault(state.method_26204(), class_2350.field_11033);
        for (class_785 element : this.getBlockModelElements(unbakedModel.model)) {
            int color;
            PhysicsEntity particle = new PhysicsEntity(PhysicsEntity.Type.BLOCK, state);
            if (element.comp_3727().x() != 0.0f || element.comp_3727().y() != 0.0f || element.comp_3727().z() != 0.0f || element.comp_3728().x() != 16.0f || element.comp_3728().y() != 16.0f || element.comp_3728().z() != 16.0f) {
                particle.rescale = new AABBf(new Vector3f(element.comp_3727().x() / 16.0f, element.comp_3727().y() / 16.0f, element.comp_3727().z() / 16.0f), new Vector3f(element.comp_3728().x() / 16.0f, element.comp_3728().y() / 16.0f, element.comp_3728().z() / 16.0f));
            }
            particle.shade = element.comp_3731();
            class_310 minecraft = class_310.method_1551();
            class_776 ren = minecraft.method_1541();
            class_1087 model = ren.method_3349(state);
            Matrix4f m = unbakedModel.transformation;
            Matrix4d modelTransformation = new Matrix4d();
            modelTransformation.set((Matrix4fc)m);
            Matrix4d transformation = new Matrix4d();
            transformation.mul((Matrix4dc)modelTransformation);
            if (element.comp_3730() != null) {
                transformation.translate((double)element.comp_3730().comp_1118().x() - 0.5, (double)element.comp_3730().comp_1118().y() - 0.5, (double)element.comp_3730().comp_1118().z() - 0.5);
                transformation.mul((Matrix4dc)this.tmpMatrix.set((Matrix4fc)this.getElementRotation(element.comp_3730())));
                transformation.translate(-((double)element.comp_3730().comp_1118().x() - 0.5), -((double)element.comp_3730().comp_1118().y() - 0.5), -((double)element.comp_3730().comp_1118().z() - 0.5));
            }
            transformation.m30(transformation.m30() + (double)pos.method_10263() + 0.5 + blockOffset.field_1352);
            transformation.m31(transformation.m31() + (double)pos.method_10264() + 0.5 + blockOffset.field_1351);
            transformation.m32(transformation.m32() + (double)pos.method_10260() + 0.5 + blockOffset.field_1350);
            particle.getTransformation().set((Matrix4dc)transformation);
            BlockSetting blockSetting = ConfigBlocks.getBlockSetting(state.method_26204());
            particle.getTransformation().scale((double)((float)blockSetting.getScale()));
            particle.models.get((int)0).texture = model.method_68511();
            if (element.comp_3729().values().size() > 0) {
                class_10419 textureSlots;
                class_4730 material;
                class_10819 unbaked = unbakedModel.model;
                class_783 face = (class_783)element.comp_3729().get(textureDirection);
                if (face == null && element.comp_3729().size() > 0) {
                    face = (class_783)element.comp_3729().values().iterator().next();
                }
                if ((material = (textureSlots = unbaked.method_68045()).method_65545(face.comp_2869())) != null) {
                    class_1058 sprite;
                    particle.models.get((int)0).texture = sprite = class_310.method_1551().method_72703().method_73030(material);
                    if (face.comp_2869().startsWith("#overlay")) continue;
                }
            }
            if (particle.models.get((int)0).texture != null) {
                particle.models.get((int)0).textureID = class_310.method_1551().method_1531().method_4619(particle.models.get((int)0).texture.method_45852()).method_71659();
            }
            if ((color = class_310.method_1551().method_1505().method_1697(update.state, (class_1920)level, update.pos, 0)) == -1) {
                color = -1;
            }
            particle.setColor(color);
            if (update.state.method_26204() == class_2246.field_10593 || update.state.method_26204() == class_2246.field_10219) {
                particle.setColor(-1);
            }
            particles.add(particle);
        }
    }

    private Matrix4f getElementRotation(class_789 blockElementRotation) {
        class_7833 rotationAxis = class_7833.field_40716;
        switch (blockElementRotation.comp_1119()) {
            case field_11048: {
                rotationAxis = class_7833.field_40714;
                break;
            }
            case field_11052: {
                rotationAxis = class_7833.field_40716;
                break;
            }
            case field_11051: {
                rotationAxis = class_7833.field_40718;
            }
        }
        return new Matrix4f().rotation((Quaternionfc)rotationAxis.rotationDegrees(blockElementRotation.comp_1120()));
    }

    private double calculateChance(int count) {
        double chance = 1.0;
        if ((double)count > (double)ConfigClient.maxPhysicsObjects * 0.4) {
            chance = 0.3;
            if ((double)count > (double)ConfigClient.maxPhysicsObjects * 0.7) {
                chance = 0.05;
            }
        }
        if (count > ConfigClient.maxPhysicsObjects) {
            chance = 0.0;
        }
        return chance;
    }

    private void spawnBlockBreakParticles(class_1937 level, class_2680 state, class_2338 pos, double spawnRate) {
        class_265 voxelShape = state.method_26218((class_1922)level, pos);
        voxelShape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double width = java.lang.Math.min(1.0, maxX - minX);
            double height = java.lang.Math.min(1.0, maxY - minY);
            double depth = java.lang.Math.min(1.0, maxZ - minZ);
            int stepX = java.lang.Math.max(2, class_3532.method_15384((double)(width / 0.25)));
            int stepY = java.lang.Math.max(2, class_3532.method_15384((double)(height / 0.25)));
            int stepZ = java.lang.Math.max(2, class_3532.method_15384((double)(depth / 0.25)));
            for (int xp = 0; xp < stepX; ++xp) {
                for (int yp = 0; yp < stepY; ++yp) {
                    for (int zp = 0; zp < stepZ; ++zp) {
                        if ((double)Math.random() > spawnRate) continue;
                        double xSpeed = ((double)xp + 0.5) / (double)stepX;
                        double ySpeed = ((double)yp + 0.5) / (double)stepY;
                        double zSpeed = ((double)zp + 0.5) / (double)stepZ;
                        double xPos = xSpeed * width + minX;
                        double yPos = ySpeed * height + minY;
                        double zPos = zSpeed * depth + minZ;
                        class_1058 sprite = class_310.method_1551().method_1541().method_3351().method_3339(state);
                        PhysicsMod mod = PhysicsMod.getInstance(level);
                        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.BLOCK, state);
                        entity.getTransformation().translation((double)pos.method_10263() + xPos, (double)pos.method_10264() + yPos, (double)pos.method_10260() + zPos).scale((double)Math.random() * 0.06 + 0.07);
                        Model model = entity.models.get(0);
                        model.texture = sprite;
                        model.textureID = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_71659();
                        entity.backfaceCulling = true;
                        model.mesh = PhysicsMod.brokenBlock.get(0);
                        int color = class_310.method_1551().method_1505().method_1697(state, (class_1920)level, pos, 0);
                        if (color == -1) {
                            color = -1;
                        }
                        entity.setColor(color);
                        if (state.method_26204() == class_2246.field_10593 || state.method_26204() == class_2246.field_10219) {
                            entity.setColor(-1);
                        }
                        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
                        mod.physicsWorld.queue(() -> {
                            PxRigidActor patt0$temp = body.getRigidBody();
                            if (patt0$temp instanceof PxRigidDynamic) {
                                PxRigidDynamic rigidBody = (PxRigidDynamic)patt0$temp;
                                float strength = 3.0f;
                                Vector3f speed = new Vector3f(0.0f, 0.2f, 0.0f);
                                speed.x += (Math.random() - 0.5f) * 0.4f;
                                speed.y += (Math.random() - 0.5f) * 0.4f;
                                speed.z += (Math.random() - 0.5f) * 0.4f;
                                speed.normalize();
                                try (MemoryStack mem = MemoryStack.stackPush();){
                                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                                    rigidBody.setLinearVelocity(velocity);
                                }
                            }
                        });
                        float uo = Math.random() * 3.0f;
                        float vo = Math.random() * 3.0f;
                        Vector4f customUVs = new Vector4f(sprite.method_4580(uo / 4.0f), sprite.method_4580((uo + 1.0f) / 4.0f), sprite.method_4570(vo / 4.0f), sprite.method_4570((vo + 1.0f) / 4.0f));
                        float xScale = customUVs.y - customUVs.x;
                        float yScale = customUVs.w - customUVs.z;
                        model.textureMatrix = new Matrix4f().translate(customUVs.x, customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
                    }
                }
            }
        });
    }

    static {
        textureSides.put(class_2246.field_10533, class_2350.field_11039);
        textureSides.put(class_2246.field_10431, class_2350.field_11039);
        textureSides.put(class_2246.field_10511, class_2350.field_11039);
        textureSides.put(class_2246.field_10306, class_2350.field_11039);
        textureSides.put(class_2246.field_10010, class_2350.field_11039);
        textureSides.put(class_2246.field_10037, class_2350.field_11039);
        textureSides.put(class_2246.field_42729, class_2350.field_11039);
        textureSides.put(class_2246.field_37545, class_2350.field_11039);
        textureSides.put(class_2246.field_54715, class_2350.field_11039);
        textureSides.put(class_2246.field_10622, class_2350.field_11039);
        textureSides.put(class_2246.field_10519, class_2350.field_11039);
        textureSides.put(class_2246.field_10366, class_2350.field_11039);
        textureSides.put(class_2246.field_10254, class_2350.field_11039);
        textureSides.put(class_2246.field_10244, class_2350.field_11039);
        textureSides.put(class_2246.field_10436, class_2350.field_11039);
        textureSides.put(class_2246.field_42732, class_2350.field_11039);
        textureSides.put(class_2246.field_37548, class_2350.field_11039);
        textureSides.put(class_2246.field_54716, class_2350.field_11039);
    }
}

