/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.compat;

import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPass;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.Nullable;
import net.diebuddies.mixins.iris.MixinExtendedShaderAccessor;
import net.diebuddies.mixins.iris.MixinHandRendererAccessor;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.PhysicsExtendedPipeline;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.PBRDrawCall;
import net.diebuddies.util.ShaderType;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.pathways.HandRenderer;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPhase;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings;
import net.irisshaders.iris.shadows.ShadowRenderer;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class Iris {
    public static String oceanError = "";
    public static String liquidsError = "";
    public static String smokeError = "";
    public static int normalTextureUnit = -1;
    public static int specularTextureUnit = -1;
    public static final ThreadLocal<Boolean> compilingLiquidShadowShader = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static final ThreadLocal<Boolean> vertexShaderSupportsOcean = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static final ThreadLocal<Boolean> fragmentShaderSupportsOcean = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static final ThreadLocal<Boolean> geometryShaderSupportsOcean = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static final ThreadLocal<ShaderType> preprocessOceanStage = ThreadLocal.withInitial(() -> null);
    public static final ThreadLocal<Boolean> injectIntoEntityOrShadowShader = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static final ThreadLocal<Boolean> compilingSmokeShader = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static Matrix4f tmp1 = new Matrix4f();
    private static Matrix3f tmp2 = new Matrix3f();
    private static float[] tmpNormal = new float[9];
    private static float[] tmpInvModelView = new float[16];

    public static short getMaterialID(BlockState block) {
        if (StarterClient.iris) {
            try {
                Object2IntMap idMap = WorldRenderingSettings.INSTANCE.getBlockStateIds();
                if (idMap != null) {
                    return (short)idMap.getOrDefault((Object)block, -1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    @Nullable
    public static GlProgram getOceanProgram() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$getOceanShader();
        }
        return null;
    }

    @Nullable
    public static GlProgram getOceanShadowProgram() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$getOceanShadowShader();
        }
        return null;
    }

    @Nullable
    public static GlProgram getLiquidProgram() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$getLiquidShader();
        }
        return null;
    }

    @Nullable
    public static GlProgram getLiquidShadowProgram() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$getLiquidShadowShader();
        }
        return null;
    }

    @Nullable
    public static GlProgram getSmokeProgram() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$getSmokeShader();
        }
        return null;
    }

    @Nullable
    public static GlProgram getSmokeShadowProgram() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$getSmokeShadowShader();
        }
        return null;
    }

    public static boolean renderOceanShadow() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$renderOceanShadow();
        }
        return false;
    }

    public static boolean renderLiquidShadow() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$renderLiquidShadow();
        }
        return false;
    }

    public static boolean renderSmokeShadow() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$renderSmokeShadow();
        }
        return false;
    }

    public static void enableHandRendering() {
        if (StarterClient.iris) {
            ((MixinHandRendererAccessor)HandRenderer.INSTANCE).setRenderingSolid(true);
        }
    }

    public static void disableHandRendering() {
        if (StarterClient.iris) {
            ((MixinHandRendererAccessor)HandRenderer.INSTANCE).setRenderingSolid(false);
        }
    }

    public static boolean isExtending() {
        if (StarterClient.iris) {
            return IrisApi.getInstance().isShaderPackInUse();
        }
        return false;
    }

    public static boolean isShadowPass() {
        if (StarterClient.iris) {
            return IrisApi.getInstance().isRenderingShadowPass();
        }
        return false;
    }

    public static int getSpecularTextureID() {
        if (StarterClient.iris) {
            WorldRenderingPipeline pipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable();
            return pipeline.getCurrentSpecularTexture();
        }
        return 0;
    }

    public static int getNormalTextureID() {
        if (StarterClient.iris) {
            WorldRenderingPipeline pipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable();
            return pipeline.getCurrentNormalTexture();
        }
        return 0;
    }

    public static void setNormalMatrix(RenderPass renderPass, Matrix4fc modelViewMatrix) {
        GlProgram program = ((GlRenderPass)renderPass).pipeline.program();
        if (program instanceof MixinExtendedShaderAccessor) {
            MixinExtendedShaderAccessor extended = (MixinExtendedShaderAccessor)program;
            int mvi = extended.getModelViewInverse();
            int normal = extended.getNormalMat();
            if (mvi > -1) {
                modelViewMatrix.invert(tmp1).get(tmpInvModelView);
                IrisRenderSystem.uniformMatrix4fv((int)mvi, (boolean)false, (float[])tmpInvModelView);
            }
            if (normal > -1) {
                if (mvi > -1) {
                    tmp1.transpose3x3(tmp2);
                } else {
                    modelViewMatrix.normal(tmp2);
                }
                tmp2.get(tmpNormal);
                IrisRenderSystem.uniformMatrix3fv((int)normal, (boolean)false, (float[])tmpNormal);
            }
        }
    }

    public static void setNormalMatrix(RenderPass renderPass, Matrix4fc modelViewMatrix, Matrix3fc normalMatrix) {
        GlProgram program = ((GlRenderPass)renderPass).pipeline.program();
        if (program instanceof MixinExtendedShaderAccessor) {
            MixinExtendedShaderAccessor extended = (MixinExtendedShaderAccessor)program;
            int mvi = extended.getModelViewInverse();
            int normal = extended.getNormalMat();
            if (mvi > -1) {
                modelViewMatrix.invert(tmp1).get(tmpInvModelView);
                IrisRenderSystem.uniformMatrix4fv((int)mvi, (boolean)false, (float[])tmpInvModelView);
            }
            if (normal > -1) {
                normalMatrix.get(tmpNormal);
                IrisRenderSystem.uniformMatrix3fv((int)normal, (boolean)false, (float[])tmpNormal);
            }
        }
    }

    public static void setShadowMatrices(MainRenderer mainRenderer) {
        mainRenderer.setMatrices(ShadowRenderer.MODELVIEW, ShadowRenderer.PROJECTION);
    }

    public static void setRenderingPipelineToTerrainTranslucent(MainRenderer mainRenderer) {
        WorldRenderingPipeline pipeline;
        if (StarterClient.iris && (pipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof IrisRenderingPipeline) {
            IrisRenderingPipeline iris = (IrisRenderingPipeline)pipeline;
            iris.setPhase(WorldRenderingPhase.TERRAIN_TRANSLUCENT);
        }
    }

    public static void setRenderingPipelineToEntities(MainRenderer mainRenderer) {
        WorldRenderingPipeline pipeline;
        if (StarterClient.iris && (pipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof IrisRenderingPipeline) {
            IrisRenderingPipeline iris = (IrisRenderingPipeline)pipeline;
            iris.setPhase(WorldRenderingPhase.ENTITIES);
        }
    }

    public static void resetPBRUnits() {
        normalTextureUnit = -1;
        specularTextureUnit = -1;
    }

    public static void fetchPBRTextures(PBRDrawCall pbrDrawCall, GpuTextureView textureView) {
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)textureView);
        pbrDrawCall.normalTexture = Iris.getNormalTextureID();
        pbrDrawCall.specularTexture = Iris.getSpecularTextureID();
    }

    public static void bindPBRTextures(PBRDrawCall pbrDrawCall) {
        if (normalTextureUnit != -1) {
            GlStateManager._activeTexture((int)(33984 + normalTextureUnit));
            GlStateManager._bindTexture((int)pbrDrawCall.normalTexture);
        }
        if (specularTextureUnit != -1) {
            GlStateManager._activeTexture((int)(33984 + specularTextureUnit));
            GlStateManager._bindTexture((int)pbrDrawCall.specularTexture);
        }
        GlStateManager._activeTexture((int)33984);
    }
}

