/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.minecraft.ChunkSectionsToRenderExtension;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.render.MainRenderer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayerGroup;
import net.minecraft.client.renderer.chunk.ChunkSectionsToRender;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkSectionsToRender.class}, priority=2010)
public class MixinChunkSectionsToRender
implements ChunkSectionsToRenderExtension {
    @Unique
    private MainRenderer physicsmod$renderer;
    @Unique
    private ClientLevel physicsmod$level;

    @Inject(at={@At(value="HEAD")}, method={"renderGroup"})
    private void physicsmod$renderLiquids(ChunkSectionLayerGroup layerGroup, CallbackInfo info) {
        if (StarterClient.sodium || this.physicsmod$renderer == null) {
            return;
        }
        if (layerGroup == ChunkSectionLayerGroup.TRANSLUCENT) {
            this.physicsmod$renderer.renderLiquid(this.physicsmod$level, ChunkSectionLayer.TRANSLUCENT);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderGroup"})
    private void physicsmod$renderSolids(ChunkSectionLayerGroup layerGroup, CallbackInfo info) {
        if (StarterClient.sodium || this.physicsmod$renderer == null) {
            return;
        }
        if (layerGroup == ChunkSectionLayerGroup.OPAQUE) {
            if (StarterClient.iris && Iris.isShadowPass()) {
                Iris.setShadowMatrices(this.physicsmod$renderer);
            } else if (StarterClient.optifabric && Optifine.isShadowPass()) {
                Optifine.setShadowMatrices(this.physicsmod$renderer);
            }
            this.physicsmod$renderer.renderAll(this.physicsmod$level, ChunkSectionLayer.CUTOUT);
        }
    }

    @Override
    public void physicsmod$setRenderer(MainRenderer renderer, ClientLevel level) {
        this.physicsmod$renderer = renderer;
        this.physicsmod$level = level;
    }
}

