/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.diebuddies.physics.settings.gui.GuiPhysicsCustomRenderer;
import net.diebuddies.physics.settings.gui.GuiPhysicsEntityRenderer;
import net.diebuddies.physics.settings.gui.RendererReset;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.GuiRenderer;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiRenderer.class})
public class MixinGuiRenderer {
    @Shadow
    @Final
    private Map<Class<? extends PictureInPictureRenderState>, PictureInPictureRenderer<?>> pictureInPictureRenderers;

    @ModifyVariable(at=@At(value="HEAD"), method={"<init>"}, ordinal=0)
    private static List<PictureInPictureRenderer<?>> physicsmod$addPhysicsRenderer(List<PictureInPictureRenderer<?>> oldPips) {
        ObjectArrayList pips = new ObjectArrayList(oldPips);
        pips.add(new GuiPhysicsEntityRenderer(Minecraft.getInstance().renderBuffers().bufferSource(), Minecraft.getInstance().getEntityRenderDispatcher()));
        pips.add(new GuiPhysicsCustomRenderer(Minecraft.getInstance().renderBuffers().bufferSource()));
        return List.copyOf(pips);
    }

    @Inject(at={@At(value="HEAD")}, method={"preparePictureInPicture"})
    private void physicsmod$resetTexture(CallbackInfo info) {
        for (PictureInPictureRenderer<?> pictureRenderer : this.pictureInPictureRenderers.values()) {
            if (!(pictureRenderer instanceof RendererReset)) continue;
            RendererReset rendererExtension = (RendererReset)pictureRenderer;
            rendererExtension.reset();
        }
    }
}

