/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.minecraft.ItemEntityRenderStatePhysics;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntityRenderer.class})
public abstract class MixinItemEntityRenderer
extends EntityRenderer<ItemEntity, ItemEntityRenderState> {
    protected MixinItemEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(at={@At(value="HEAD")}, method={"submit"}, cancellable=true)
    private void physicsmod$renderItemPhysics(ItemEntityRenderState itemRenderState, PoseStack matrixStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, CallbackInfo info) {
        if (ConfigClient.hasItemPhysics() && !itemRenderState.item.isEmpty() && itemRenderState instanceof ItemEntityRenderStatePhysics) {
            ItemEntityRenderStatePhysics physicsState = (ItemEntityRenderStatePhysics)itemRenderState;
            matrixStack.pushPose();
            int count = itemRenderState.count;
            float offset = 0.05f;
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotation(itemRenderState.bobOffset));
            matrixStack.mulPose((Quaternionfc)Axis.XP.rotation((float)Math.toRadians(90.0) + physicsState.physicsmod$rotation()));
            if (!physicsState.physicsmod$isBlock()) {
                matrixStack.translate(0.0f, 0.0f, (float)(-(count - 1)) * offset);
            } else {
                matrixStack.translate(0.0f, -0.145f, 0.0f);
            }
            ItemStackRenderState itemStackRenderState = itemRenderState.item;
            if (!physicsState.physicsmod$isBlock()) {
                for (int i = 0; i < count; ++i) {
                    itemStackRenderState.submit(matrixStack, submitNodeCollector, itemRenderState.lightCoords, OverlayTexture.NO_OVERLAY, itemRenderState.outlineColor);
                    matrixStack.translate(0.0f, 0.0f, offset);
                }
            } else {
                itemStackRenderState.submit(matrixStack, submitNodeCollector, itemRenderState.lightCoords, OverlayTexture.NO_OVERLAY, itemRenderState.outlineColor);
            }
            matrixStack.popPose();
            super.submit((EntityRenderState)itemRenderState, matrixStack, submitNodeCollector, cameraRenderState);
            info.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"extractRenderState"})
    private void extractRenderState(ItemEntity entity, ItemEntityRenderState entityRenderState, float tickDelta, CallbackInfo info) {
        if (ConfigClient.hasItemPhysics() && !entityRenderState.item.isEmpty() && entityRenderState instanceof ItemEntityRenderStatePhysics) {
            ItemEntityRenderStatePhysics physicsState = (ItemEntityRenderStatePhysics)entityRenderState;
            ItemStack itemStack = entity.getItem();
            AABB.Builder builder = new AABB.Builder();
            entityRenderState.item.visitExtents(arg_0 -> ((AABB.Builder)builder).include(arg_0));
            AABB aABB = builder.build();
            boolean isBlock = aABB.getZsize() > 0.0625;
            float passedTimeMillis = tickDelta * 1.0f / 20.0f * 1000.0f * 0.1f;
            double rotationSpeed = 0.05 * (double)ConfigClient.itemRotationSpeed;
            if (entity.isInWater()) {
                rotationSpeed = 0.002;
            }
            if (entity.onGround()) {
                if (!(isBlock & !(itemStack.is(Items.TRIDENT) | itemStack.is(Items.SPYGLASS)))) {
                    entity.flyDist = 0.0f;
                }
            } else {
                entity.flyDist = (float)((double)entity.flyDist + (double)passedTimeMillis * rotationSpeed);
            }
            physicsState.physicsmod$rotation(entity.flyDist);
            physicsState.physicsmod$isBlock(isBlock);
        }
    }
}

