/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.diebuddies.compat.Sodium;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.render.BlockEntityVertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public class BlockEntityBufferSource
extends MultiBufferSource.BufferSource {
    public static BlockEntityVertexConsumer currentConsumer;
    private Map<RenderType, BlockEntityVertexConsumer> renderTypes = new Object2ObjectOpenHashMap();
    private RenderType lastLayer;

    public BlockEntityBufferSource() {
        super(null, null);
    }

    public VertexConsumer getBuffer(RenderType layer) {
        if (this.lastLayer != null) {
            this.lastLayer.clearRenderState();
        }
        this.lastLayer = layer;
        layer.setupRenderState();
        currentConsumer = this.renderTypes.computeIfAbsent(layer, key -> StarterClient.sodium ? Sodium.getNewBlockConsumer() : new BlockEntityVertexConsumer());
        return currentConsumer;
    }

    public RenderType getLastLayer() {
        return this.lastLayer;
    }

    public Map<RenderType, BlockEntityVertexConsumer> getBakedRenderTypeModels() {
        return this.renderTypes;
    }

    public void endLastBatch() {
    }

    public void endBatch() {
    }

    public void endBatch(RenderType renderType) {
    }
}

