/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.smoke;

import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Random;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.PhysicsIndex;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.smoke.SmokeDomain;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3d;
import org.joml.Vector4d;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import physx.NativeObject;
import physx.common.PxCudaContext;
import physx.common.PxCudaContextManager;
import physx.common.PxCudaTopLevelFunctions;
import physx.common.PxVec4;
import physx.particles.PxPBDMaterial;
import physx.particles.PxPBDParticleSystem;
import physx.particles.PxParticleBuffer;
import physx.particles.PxParticleBufferDesc;
import physx.particles.PxParticleBufferFlagEnum;
import physx.particles.PxParticlePhaseFlagEnum;
import physx.particles.PxParticlePhaseFlags;
import physx.physics.PxFilterData;

public class SmokeDomainCuda
extends SmokeDomain {
    private static final float DESPAWN_ANIMATION_TIME = 2.0f;
    private static final float CHECK_AIR_EVERY_X_SECONDS = 1.0f;
    private static final BlockPos.MutableBlockPos tmpPos = new BlockPos.MutableBlockPos();
    private PxPBDParticleSystem smokeSystem;
    private PxPBDMaterial smokeMat;
    private int smokePhase;
    private int maxSmoke;
    private ParticleInfo[] particles;
    private float[] cudaPositions;
    private float[] cudaOldPositions;
    private PxParticleBuffer particleBuffer;
    private FloatBuffer positionsBuffer;
    private FloatBuffer velocitiesBuffer;
    private IntBuffer phaseBuffer;
    private List<Vector4d> bufferedSpawns = new ObjectArrayList();
    private Random random;
    private int activeParticles;

    public SmokeDomainCuda(PhysicsWorld world) {
        super(world);
        this.maxSmoke = ConfigClient.smokeParticleLimitCuda;
        this.particles = new ParticleInfo[this.maxSmoke];
        this.random = new Random(System.nanoTime());
    }

    @Override
    public void update(double diff) {
        if (!ConfigClient.smokePhysics) {
            this.remove();
            super.update(diff);
            return;
        }
        if (this.smokeSystem == null) {
            this.createSmokeSystem();
        }
        if (this.hasBufferedParticles() || this.hasParticles()) {
            PxCudaContextManager cudaMgr = StarterClient.cudaManager;
            cudaMgr.acquireContext();
            PxCudaContext cudaContext = cudaMgr.getCudaContext();
            this.fetchPositions(cudaContext, diff);
            this.processBufferedParticles(cudaContext);
            long positionsAddress = MemoryUtil.memAddress((FloatBuffer)this.positionsBuffer);
            long velocitiesAddress = MemoryUtil.memAddress((FloatBuffer)this.velocitiesBuffer);
            long phaseAddress = MemoryUtil.memAddress((IntBuffer)this.phaseBuffer);
            cudaContext.memcpyHtoD(PxCudaTopLevelFunctions.pxVec4deviceptr(this.particleBuffer.getPositionInvMasses()), NativeObject.wrapPointer(positionsAddress), PxVec4.SIZEOF * this.activeParticles);
            cudaContext.memcpyHtoD(PxCudaTopLevelFunctions.pxVec4deviceptr(this.particleBuffer.getVelocities()), NativeObject.wrapPointer(velocitiesAddress), PxVec4.SIZEOF * this.activeParticles);
            cudaContext.memcpyHtoD(PxCudaTopLevelFunctions.pxU32deviceptr(this.particleBuffer.getPhases()), NativeObject.wrapPointer(phaseAddress), 4 * this.activeParticles);
            this.particleBuffer.raiseFlags(PxParticleBufferFlagEnum.eUPDATE_POSITION);
            this.particleBuffer.raiseFlags(PxParticleBufferFlagEnum.eUPDATE_VELOCITY);
            this.particleBuffer.raiseFlags(PxParticleBufferFlagEnum.eUPDATE_PHASE);
            this.particleBuffer.setNbActiveParticles(this.activeParticles);
            cudaMgr.releaseContext();
        }
        super.update(diff);
    }

    private void createSmokeSystem() {
        try (MemoryStack mem = MemoryStack.stackPush();){
            float r = 0.4f;
            this.smokeSystem = StarterClient.physics.createPBDParticleSystem(StarterClient.cudaManager, 96);
            float rest = r;
            float slop = rest * 0.2f;
            this.smokeSystem.setRestOffset(rest);
            this.smokeSystem.setContactOffset(rest + slop);
            this.smokeSystem.setParticleContactOffset(rest * 0.75f);
            this.smokeSystem.enableCCD(false);
            this.smokeSystem.setMaxVelocity(rest * 20.0f);
            this.smokeSystem.setSolverIterationCounts(4, 2);
            PxFilterData tmpFilterData = PxFilterData.createAt(mem, MemoryStack::nmalloc, 2, 23, 0, 0);
            this.smokeSystem.setSimulationFilterData(tmpFilterData);
            this.world.addParticleSystem(this.smokeSystem);
            this.smokeMat = StarterClient.physics.createPBDMaterial(0.0f, 0.08f, 0.0f, 0.0015f, 4.0f, 0.0f, 0.0f, 0.0f, 0.1f, 1.1f, -0.2f);
            PxParticlePhaseFlags flags = PxParticlePhaseFlags.createAt(mem, MemoryStack::nmalloc, 0);
            flags.raise(PxParticlePhaseFlagEnum.eParticlePhaseSelfCollide);
            this.smokePhase = this.smokeSystem.createPhase(this.smokeMat, flags);
            PxParticleBufferDesc bufferDesc = PxParticleBufferDesc.createAt(mem, MemoryStack::nmalloc);
            bufferDesc.setMaxParticles(this.maxSmoke);
            bufferDesc.setNumActiveParticles(0);
            this.positionsBuffer = MemoryUtil.memAllocFloat((int)(this.maxSmoke * 4));
            this.velocitiesBuffer = MemoryUtil.memAllocFloat((int)(this.maxSmoke * 4));
            this.phaseBuffer = MemoryUtil.memAllocInt((int)this.maxSmoke);
            this.cudaPositions = new float[this.maxSmoke * 4];
            this.cudaOldPositions = new float[this.maxSmoke * 4];
            PxCudaContextManager cudaMgr = StarterClient.cudaManager;
            this.particleBuffer = PxCudaTopLevelFunctions.CreateAndPopulateParticleBuffer(bufferDesc, cudaMgr);
            this.smokeSystem.addParticleBuffer(this.particleBuffer);
        }
    }

    private boolean hasBufferedParticles() {
        return this.bufferedSpawns.size() != 0;
    }

    private boolean hasParticles() {
        return this.activeParticles != 0;
    }

    private void fetchPositions(PxCudaContext cudaContext, double diff) {
        if (!this.hasParticles()) {
            return;
        }
        long positionsAddress = MemoryUtil.memAddress((FloatBuffer)this.positionsBuffer);
        long velocitiesAddress = MemoryUtil.memAddress((FloatBuffer)this.velocitiesBuffer);
        long phaseAddress = MemoryUtil.memAddress((IntBuffer)this.phaseBuffer);
        cudaContext.memcpyDtoH(NativeObject.wrapPointer(positionsAddress), PxCudaTopLevelFunctions.pxVec4deviceptr(this.particleBuffer.getPositionInvMasses()), PxVec4.SIZEOF * this.activeParticles);
        cudaContext.memcpyDtoH(NativeObject.wrapPointer(velocitiesAddress), PxCudaTopLevelFunctions.pxVec4deviceptr(this.particleBuffer.getVelocities()), PxVec4.SIZEOF * this.activeParticles);
        cudaContext.memcpyDtoH(NativeObject.wrapPointer(phaseAddress), PxCudaTopLevelFunctions.pxU32deviceptr(this.particleBuffer.getPhases()), 4 * this.activeParticles);
        System.arraycopy(this.cudaPositions, 0, this.cudaOldPositions, 0, this.activeParticles * 4);
        this.positionsBuffer.get(0, this.cudaPositions, 0, this.activeParticles * 4);
        Vector3d offset = this.world.getOffset();
        double maxSmokeDistance = ConfigClient.smokePhysicsRange * ConfigClient.smokePhysicsRange;
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 camPos = camera.getPosition();
        for (int i = 0; i < this.activeParticles; ++i) {
            ParticleInfo particle = this.particles[i];
            int arrOffset = i * 4;
            float posX = this.cudaPositions[arrOffset];
            float posY = this.cudaPositions[arrOffset + 1];
            float posZ = this.cudaPositions[arrOffset + 2];
            particle.loadChunkPhysics(this.world, posX, posY, posZ);
            particle.despawnTime = (float)((double)particle.despawnTime - diff);
            if (particle.touchedAir) {
                if (particle.despawnTime <= 0.0f) {
                    particle.unloadChunkPhysics(this.world);
                    this.removeParticleBuffer(i--);
                    continue;
                }
            } else if (particle.despawnTime <= 0.0f) {
                if (SmokeDomainCuda.isInOpenAir(this.world.getLevel(), Mth.floor((double)((double)posX + offset.x)), Mth.floor((double)((double)posY + offset.y)), Mth.floor((double)((double)posZ + offset.z)))) {
                    particle.despawnTime = (float)java.lang.Math.max(2.0, ConfigClient.particleDespawnTimeSmoke + (double)Math.random() * ConfigClient.particleDespawnTimeVarianceSmokeCuda);
                    particle.touchedAir = true;
                } else {
                    particle.despawnTime = 1.0f;
                }
            }
            if (!(camPos.distanceToSqr((double)posX + offset.x, (double)posY + offset.y, (double)posZ + offset.z) > maxSmokeDistance)) continue;
            particle.unloadChunkPhysics(this.world);
            this.removeParticleBuffer(i--);
        }
    }

    private void removeParticleBuffer(int index) {
        --this.activeParticles;
        int currentPos = index * 4;
        int oldPos = this.activeParticles * 4;
        this.positionsBuffer.put(currentPos, this.positionsBuffer, oldPos, 4);
        this.velocitiesBuffer.put(currentPos, this.velocitiesBuffer, oldPos, 4);
        this.phaseBuffer.put(index, this.phaseBuffer, this.activeParticles, 1);
        this.particles[index] = this.particles[this.activeParticles];
        this.particles[this.activeParticles] = null;
        this.cudaPositions[currentPos] = this.cudaPositions[oldPos];
        this.cudaPositions[currentPos + 1] = this.cudaPositions[oldPos + 1];
        this.cudaPositions[currentPos + 2] = this.cudaPositions[oldPos + 2];
        this.cudaOldPositions[currentPos] = this.cudaOldPositions[oldPos];
        this.cudaOldPositions[currentPos + 1] = this.cudaOldPositions[oldPos + 1];
        this.cudaOldPositions[currentPos + 2] = this.cudaOldPositions[oldPos + 2];
    }

    @Override
    public void clearParticles() {
        PxCudaContextManager cudaMgr = StarterClient.cudaManager;
        cudaMgr.acquireContext();
        for (int i = 0; i < this.activeParticles; ++i) {
            this.particles[i].unloadChunkPhysics(this.world);
        }
        this.activeParticles = 0;
        this.particleBuffer.setNbActiveParticles(this.activeParticles);
        cudaMgr.releaseContext();
    }

    @Override
    public void spawnParticle(double x, double y, double z, float scale) {
        if (!ConfigClient.smokePhysics) {
            return;
        }
        this.bufferedSpawns.add(new Vector4d(x + (double)this.random.nextFloat() * 0.1 - 0.05, y + (double)this.random.nextFloat() * 0.1 - 0.05, z + (double)this.random.nextFloat() * 0.1 - 0.05, (double)scale));
    }

    public void processBufferedParticles(PxCudaContext cudaContext) {
        if (!this.hasBufferedParticles()) {
            return;
        }
        Vector3d offset = this.world.getOffset();
        int needed = this.bufferedSpawns.size();
        int quickDespawn = needed - (this.maxSmoke - this.activeParticles);
        for (int i = 0; i < quickDespawn && this.activeParticles > 0; ++i) {
            int index = this.random.nextInt(this.activeParticles);
            ParticleInfo particle = this.particles[index];
            this.removeParticleBuffer(index);
            particle.unloadChunkPhysics(this.world);
        }
        int free = this.maxSmoke - this.activeParticles;
        if (free == 0) {
            this.bufferedSpawns.clear();
            return;
        }
        for (int i = 0; i < this.bufferedSpawns.size() && i < free; ++i) {
            int id = this.activeParticles;
            Vector4d bufferedSpawn = this.bufferedSpawns.get(i);
            double x = bufferedSpawn.x;
            double y = bufferedSpawn.y;
            double z = bufferedSpawn.z;
            float scale = (float)bufferedSpawn.w;
            this.world.adjustOffset(x, y, z);
            int fillOld = id * 4;
            this.cudaPositions[fillOld] = (float)(x -= offset.x);
            this.cudaPositions[fillOld + 1] = (float)(y -= offset.y);
            this.cudaPositions[fillOld + 2] = (float)(z -= offset.z);
            this.cudaOldPositions[fillOld] = (float)x;
            this.cudaOldPositions[fillOld + 1] = (float)y;
            this.cudaOldPositions[fillOld + 2] = (float)z;
            this.positionsBuffer.put(id * 4, new float[]{(float)x, (float)y, (float)z, 100.0f});
            this.velocitiesBuffer.put(id * 4, new float[4]);
            this.phaseBuffer.put(id, this.smokePhase);
            ParticleInfo particle = new ParticleInfo(this);
            particle.scale = scale;
            particle.dither = this.random.nextInt();
            this.particles[this.activeParticles] = particle;
            ++this.activeParticles;
        }
        this.bufferedSpawns.clear();
    }

    @Override
    public void executeExplosion(Explosion explosion) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 300; ++i) {
            double x = (double)Math.random() - 0.5;
            double y = (double)Math.random() - 0.5;
            double z = (double)Math.random() - 0.5;
            double vectorLength = java.lang.Math.sqrt(x * x + y * y + z * z);
            while (vectorLength == 0.0) {
                x = (double)Math.random() - 0.5;
                y = (double)Math.random() - 0.5;
                z = (double)Math.random() - 0.5;
                vectorLength = java.lang.Math.sqrt(x * x + y * y + z * z);
            }
            x /= vectorLength;
            y /= vectorLength;
            z /= vectorLength;
            double length = (double)Math.random() * java.lang.Math.max(1.0, (double)explosion.strength);
            x = x * length + explosion.position.x;
            y = y * length + explosion.position.y;
            z = z * length + explosion.position.z;
            blockPos.set(x, y, z);
            Level level = this.world.getLevel();
            BlockState state = level.getBlockState((BlockPos)blockPos);
            FluidState fluidState = state.getFluidState();
            if (fluidState.getAmount() != 0 || Block.isShapeFullBlock((VoxelShape)state.getShape((BlockGetter)level, (BlockPos)blockPos)) && !state.getCollisionShape((BlockGetter)level, (BlockPos)blockPos).isEmpty()) continue;
            this.spawnParticle(x, y, z, Math.random() * 2.5f + 1.0f);
        }
    }

    @Override
    public int particleCount() {
        return this.activeParticles;
    }

    @Override
    public int fillInstances(Vec3 cameraPos, float[] smokepos, float[] smokeposnew, byte[] smokelight) {
        PhysicsWorld physics = this.getWorld();
        Vector3d physicsOffset = physics.getOffset();
        for (int i = 0; i < this.activeParticles; ++i) {
            this.prepareSmokeInstances(physics, physics.getLevel(), cameraPos, i, physicsOffset.x, physicsOffset.y, physicsOffset.z, smokepos, smokeposnew, smokelight);
        }
        return this.activeParticles;
    }

    private void prepareSmokeInstances(PhysicsWorld physics, Level level, Vec3 view, int particleIndex, double ox, double oy, double oz, float[] smokepos, float[] smokeposnew, byte[] smokelight) {
        ParticleInfo particle = this.particles[particleIndex];
        int srcOffst = particleIndex * 4;
        int dstOffset = particleIndex * 4;
        float x = this.cudaPositions[srcOffst];
        float y = this.cudaPositions[srcOffst + 1];
        float z = this.cudaPositions[srcOffst + 2];
        int brightness = particle.getLight(level, tmpPos.set(ox + (double)x, oy + (double)y, oz + (double)z));
        byte scale = (byte)(Math.remapClamp((double)particle.scale, 0.25, 5.0, 0.0, 1.0) * 255.0);
        smokelight[dstOffset] = (byte)(particle.dither & 0xFF);
        smokelight[dstOffset + 1] = (byte)(particle.dither >> 8 & 0xFF);
        smokelight[dstOffset + 2] = (byte)(brightness >> 4 & 0xF | brightness >> 16 & 0xF0);
        smokelight[dstOffset + 3] = scale;
        float alpha = particle.touchedAir ? java.lang.Math.min(1.0f, particle.despawnTime / 2.0f) : 1.0f;
        smokepos[dstOffset] = this.cudaOldPositions[srcOffst];
        smokepos[dstOffset + 1] = this.cudaOldPositions[srcOffst + 1];
        smokepos[dstOffset + 2] = this.cudaOldPositions[srcOffst + 2];
        smokepos[dstOffset + 3] = alpha;
        smokeposnew[dstOffset] = x;
        smokeposnew[dstOffset + 1] = y;
        smokeposnew[dstOffset + 2] = z;
        smokeposnew[dstOffset + 3] = 1.0f;
    }

    @Override
    public void invalidateBrightness(LongSet updatedLightBlocks) {
        super.invalidateBrightness(updatedLightBlocks);
        for (int i = 0; i < this.activeParticles; ++i) {
            long pos;
            ParticleInfo particle = this.particles[i];
            BlockPos.MutableBlockPos cached = particle.getCachedBrightnessPos();
            if (cached == null || !updatedLightBlocks.contains(pos = cached.asLong())) continue;
            particle.invalidateBrightness();
        }
    }

    private void remove() {
        if (this.smokeSystem == null) {
            return;
        }
        PxCudaContextManager cudaMgr = StarterClient.cudaManager;
        cudaMgr.acquireContext();
        this.smokeSystem.removeParticleBuffer(this.particleBuffer);
        this.particleBuffer.release();
        this.particleBuffer = null;
        MemoryUtil.memFree((Buffer)this.positionsBuffer);
        MemoryUtil.memFree((Buffer)this.velocitiesBuffer);
        MemoryUtil.memFree((Buffer)this.phaseBuffer);
        this.world.removeParticleSystem(this.smokeSystem);
        this.smokeSystem.release();
        this.smokeSystem = null;
        if (this.smokeMat != null) {
            this.smokeMat.release();
            this.smokeMat = null;
        }
        this.activeParticles = 0;
        cudaMgr.releaseContext();
    }

    @Override
    public void destroy() {
        this.remove();
    }

    private class ParticleInfo {
        public float scale;
        public int dither;
        public float despawnTime;
        public boolean touchedAir;
        private long lastChunk = Long.MAX_VALUE;
        private int cachedBrightness;
        private BlockPos.MutableBlockPos cachedBrightnessPos;

        private ParticleInfo(SmokeDomainCuda smokeDomainCuda) {
        }

        public void loadChunkPhysics(PhysicsWorld world, float x, float y, float z) {
            int cz;
            int cy;
            Vector3d offset = world.getOffset();
            int cx = Mth.floor((double)((double)x + offset.x)) >> PhysicsWorld.CHUNK_SIZE_NUM_BITS;
            long chunkIndex = PhysicsIndex.pack(cx, cy = Mth.floor((double)((double)y + offset.y)) >> PhysicsWorld.CHUNK_SIZE_NUM_BITS, cz = Mth.floor((double)((double)z + offset.z)) >> PhysicsWorld.CHUNK_SIZE_NUM_BITS);
            if (chunkIndex != this.lastChunk) {
                if (this.lastChunk != Long.MAX_VALUE) {
                    world.removeLoadedChunkEntity(this.lastChunk);
                }
                this.lastChunk = chunkIndex;
                world.addLoadedChunkEntity(this.lastChunk);
            }
        }

        public void unloadChunkPhysics(PhysicsWorld world) {
            if (this.lastChunk != Long.MAX_VALUE) {
                world.removeLoadedChunkEntity(this.lastChunk);
                this.lastChunk = Long.MAX_VALUE;
            }
        }

        public int getLight(Level level, BlockPos.MutableBlockPos blockPos) {
            if (!StarterClient.disableLightingCache) {
                if (this.cachedBrightnessPos == null) {
                    this.cachedBrightnessPos = new BlockPos.MutableBlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                } else if (this.cachedBrightnessPos.getX() == blockPos.getX() && this.cachedBrightnessPos.getY() == blockPos.getY() && this.cachedBrightnessPos.getZ() == blockPos.getZ()) {
                    return this.cachedBrightness;
                }
            }
            BlockState bState = level.getBlockState((BlockPos)blockPos);
            int x = blockPos.getX();
            int y = blockPos.getY();
            int z = blockPos.getZ();
            int brightness = 0;
            if (!bState.canOcclude()) {
                brightness = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockPos);
            } else {
                bState = level.getBlockState((BlockPos)blockPos.set(x, y + 1, z));
                if (!bState.canOcclude()) {
                    brightness = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockPos);
                } else {
                    bState = level.getBlockState((BlockPos)blockPos.set(x, y - 1, z));
                    if (!bState.canOcclude()) {
                        brightness = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockPos);
                    } else {
                        bState = level.getBlockState((BlockPos)blockPos.set(x, y, z - 1));
                        if (!bState.canOcclude()) {
                            brightness = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockPos);
                        } else {
                            bState = level.getBlockState((BlockPos)blockPos.set(x + 1, y, z));
                            if (!bState.canOcclude()) {
                                brightness = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockPos);
                            } else {
                                bState = level.getBlockState((BlockPos)blockPos.set(x, y, z + 1));
                                if (!bState.canOcclude()) {
                                    brightness = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockPos);
                                } else {
                                    bState = level.getBlockState((BlockPos)blockPos.set(x - 1, y, z));
                                    if (!bState.canOcclude()) {
                                        brightness = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockPos);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            blockPos.set(x, y, z);
            if (!StarterClient.disableLightingCache) {
                this.cachedBrightness = brightness;
                this.cachedBrightnessPos.set(x, y, z);
            }
            return brightness;
        }

        public BlockPos.MutableBlockPos getCachedBrightnessPos() {
            return this.cachedBrightnessPos;
        }

        public void invalidateBrightness() {
            this.cachedBrightnessPos = null;
        }
    }
}

