/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.compat;

import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPass;
import com.mojang.blaze3d.opengl.Uniform;
import com.mojang.blaze3d.systems.RenderPass;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.Nullable;
import net.diebuddies.mixins.iris.MixinExtendedShaderAccessor;
import net.diebuddies.mixins.iris.MixinHandRendererAccessor;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.PhysicsExtendedPipeline;
import net.diebuddies.util.ShaderType;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.pathways.HandRenderer;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class Iris {
    public static boolean compilingLiquidShadowShader;
    public static String oceanError;
    public static String liquidsError;
    public static boolean vertexShaderSupportsOcean;
    public static boolean fragmentShaderSupportsOcean;
    public static boolean geometryShaderSupportsOcean;
    public static ShaderType preprocessOceanStage;
    public static boolean injectIntoEntityOrShadowShader;
    private static Matrix4f tmp1;
    private static Matrix3f tmp2;
    private static float[] tmpNormal;

    public static short getMaterialID(BlockState block) {
        if (StarterClient.iris) {
            try {
                Object2IntMap idMap = WorldRenderingSettings.INSTANCE.getBlockStateIds();
                if (idMap != null) {
                    return (short)idMap.getOrDefault((Object)block, -1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    @Nullable
    public static GlProgram getOceanProgram() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$getOceanShader();
        }
        return null;
    }

    @Nullable
    public static GlProgram getOceanShadowProgram() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$getOceanShadowShader();
        }
        return null;
    }

    @Nullable
    public static GlProgram getLiquidProgram() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$getLiquidShader();
        }
        return null;
    }

    @Nullable
    public static GlProgram getLiquidShadowProgram() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$getLiquidShadowShader();
        }
        return null;
    }

    public static boolean renderOceanShadow() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$renderOceanShadow();
        }
        return false;
    }

    public static boolean renderLiquidShadow() {
        WorldRenderingPipeline worldRenderingPipeline;
        if (StarterClient.iris && (worldRenderingPipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable()) instanceof PhysicsExtendedPipeline) {
            PhysicsExtendedPipeline extended = (PhysicsExtendedPipeline)worldRenderingPipeline;
            return extended.physicsmod$renderLiquidShadow();
        }
        return false;
    }

    public static void enableHandRendering() {
        if (StarterClient.iris) {
            ((MixinHandRendererAccessor)HandRenderer.INSTANCE).setRenderingSolid(true);
        }
    }

    public static void disableHandRendering() {
        if (StarterClient.iris) {
            ((MixinHandRendererAccessor)HandRenderer.INSTANCE).setRenderingSolid(false);
        }
    }

    public static boolean isExtending() {
        if (StarterClient.iris) {
            return IrisApi.getInstance().isShaderPackInUse();
        }
        return false;
    }

    public static boolean isShadowPass() {
        if (StarterClient.iris) {
            return IrisApi.getInstance().isRenderingShadowPass();
        }
        return false;
    }

    public static int getSpecularTextureID() {
        if (StarterClient.iris) {
            WorldRenderingPipeline pipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable();
            return pipeline.getCurrentSpecularTexture();
        }
        return 0;
    }

    public static int getNormalTextureID() {
        if (StarterClient.iris) {
            WorldRenderingPipeline pipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable();
            return pipeline.getCurrentNormalTexture();
        }
        return 0;
    }

    public static void setNormalMatrix(RenderPass renderPass, Matrix4f modelViewMatrix) {
        GlProgram program = ((GlRenderPass)renderPass).pipeline.program();
        if (program instanceof MixinExtendedShaderAccessor) {
            MixinExtendedShaderAccessor extended = (MixinExtendedShaderAccessor)program;
            Uniform mvi = extended.getModelViewInverse();
            int normal = extended.getNormalMat();
            if (mvi != null) {
                mvi.set(modelViewMatrix.invert(tmp1));
                mvi.upload();
            }
            if (normal > -1) {
                if (mvi != null) {
                    tmp1.transpose3x3(tmp2);
                } else {
                    modelViewMatrix.normal(tmp2);
                }
                tmp2.get(tmpNormal);
                IrisRenderSystem.uniformMatrix3fv((int)normal, (boolean)false, (float[])tmpNormal);
            }
        }
    }

    public static void setNormalMatrix(RenderPass renderPass, Matrix4f modelViewMatrix, Matrix3f normalMatrix) {
        GlProgram program = ((GlRenderPass)renderPass).pipeline.program();
        if (program instanceof MixinExtendedShaderAccessor) {
            MixinExtendedShaderAccessor extended = (MixinExtendedShaderAccessor)program;
            Uniform mvi = extended.getModelViewInverse();
            int normal = extended.getNormalMat();
            if (mvi != null) {
                mvi.set(modelViewMatrix.invert(tmp1));
                mvi.upload();
            }
            if (normal > -1) {
                normalMatrix.get(tmpNormal);
                IrisRenderSystem.uniformMatrix3fv((int)normal, (boolean)false, (float[])tmpNormal);
            }
        }
    }

    static {
        oceanError = "";
        liquidsError = "";
        tmp1 = new Matrix4f();
        tmp2 = new Matrix3f();
        tmpNormal = new float[9];
    }
}

