/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft;

import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.minecraft.RenderHelper;
import net.diebuddies.physics.EntityRenderStateExtended;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ThrownItemRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionfc;

public class EggItemRenderer<T extends Entity>
extends EntityRenderer<T, ThrownItemRenderState> {
    private final ItemModelResolver itemModelResolver;
    private final float scale;
    private final boolean fullBright;

    public EggItemRenderer(EntityRendererProvider.Context context, float f, boolean bl) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
        this.scale = f;
        this.fullBright = bl;
    }

    public EggItemRenderer(EntityRendererProvider.Context context) {
        this(context, 1.0f, false);
    }

    public int getBlockLightLevel(T entity, BlockPos blockPos) {
        return this.fullBright ? 15 : super.getBlockLightLevel(entity, blockPos);
    }

    public void render(ThrownItemRenderState thrownItemRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        Entity entity = ((EntityRenderStateExtended)thrownItemRenderState).getEntity();
        float tickDelta = ((EntityRenderStateExtended)thrownItemRenderState).getTickDelta();
        if (ConfigClient.eggModel != 2) {
            RenderHelper.renderMesh(entity, tickDelta, multiBufferSource, this.entityRenderDispatcher, PhysicsMod.EGG_TEXTURE, PhysicsMod.eggMesh.get(ConfigClient.eggModel), poseStack, light, OverlayTexture.NO_OVERLAY, ConfigClient.eggShade);
        } else {
            poseStack.pushPose();
            poseStack.scale(this.scale, this.scale, this.scale);
            poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
            thrownItemRenderState.item.render(poseStack, multiBufferSource, light, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        super.render((EntityRenderState)thrownItemRenderState, poseStack, multiBufferSource, light);
    }

    public ThrownItemRenderState createRenderState() {
        return new ThrownItemRenderState();
    }

    public void extractRenderState(T entity, ThrownItemRenderState thrownItemRenderState, float f) {
        super.extractRenderState(entity, (EntityRenderState)thrownItemRenderState, f);
        this.itemModelResolver.updateForNonLiving(thrownItemRenderState.item, ((ItemSupplier)entity).getItem(), ItemDisplayContext.GROUND, entity);
    }
}

