/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.physics.EntityRenderStateExtended;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.verlet.Cloth;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.physics.verlet.constraints.OceanPhysicsDisplacementConstraint;
import net.diebuddies.util.PlayerLevelPacked;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WingsLayer.class})
public class MixinElytraLayer {
    @Unique
    private Map<PlayerLevelPacked, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    @Unique
    private Matrix4f localT = new Matrix4f();
    @Unique
    private MultiBufferSource multiBufferSource;
    @Unique
    private PlayerLevelPacked tmp = new PlayerLevelPacked(null, null);

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    private void physicsmod$replaceElytra(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, HumanoidRenderState humanoidRenderState, float f, float g, CallbackInfo info) {
        Entity entity = ((EntityRenderStateExtended)humanoidRenderState).getEntity();
        if (entity instanceof AbstractClientPlayer) {
            boolean renderCloth;
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            this.physicsmod$removeOldSimulations();
            ItemStack itemStack = humanoidRenderState.chestEquipment;
            if (itemStack == null || !itemStack.is(Items.ELYTRA)) {
                return;
            }
            boolean bl = renderCloth = Minecraft.getInstance().player != player;
            if (renderCloth && this.physicsmod$shouldRenderPhysicsElytra(player) && this.physicsmod$hasPhysicsElytra(player)) {
                this.physicsmod$renderPhysicsElytra(player, light);
                info.cancel();
            }
        }
    }

    @Unique
    private void physicsmod$removeOldSimulations() {
        Iterator<Map.Entry<PlayerLevelPacked, VerletSimulation>> it = this.simulations.entrySet().iterator();
        while (it.hasNext()) {
            if (!it.next().getValue().destroyed) continue;
            it.remove();
        }
    }

    @Unique
    private void physicsmod$renderPhysicsElytra(AbstractClientPlayer player, int light) {
        Level level = player.getCommandSenderWorld();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        this.tmp.e1 = player.getGameProfile().getName();
        this.tmp.e2 = level;
        VerletSimulation simulation = this.simulations.get(this.tmp);
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        boolean renderFast = false;
        if (camera.getBlockPosition().distSqr((Vec3i)player.blockPosition()) > (double)(ConfigClient.clothEntityRange * ConfigClient.clothEntityRange)) {
            renderFast = true;
        }
        Cloth cloth = ConfigCloth.getCategory((Entity)player, "Elytra");
        LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player);
        EntityModel model = renderer.getModel();
        if (renderFast || !cloth.rules.isDynamic()) {
            ModelPart modelPart = ModelPartConstraint.getPart((Model)model, "body");
            if (cloth != null && modelPart != null) {
                PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, (LivingEntity)player, modelPart, light));
            }
        } else {
            if (simulation == null) {
                boolean alwaysInstantlyUpdate;
                EntityModel entityModel;
                if (model instanceof EntityModel && !ModelPartConstraint.exists((EntityModel<LivingEntityRenderState>)(entityModel = model), "body")) {
                    return;
                }
                int quality = player == Minecraft.getInstance().player ? 90 : 45;
                simulation = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(level.dimension().location())), quality, 0.855);
                ModelPartConstraint modelPartConstraint = new ModelPartConstraint(simulation, cloth.rules.getIgnoreParts(), (LivingEntity)player, "body", (Model)model);
                PoseStack modelMatrix = new PoseStack();
                ModelPartConstraint.entityTransformation(modelMatrix, simulation, (LivingEntity)player, (Model)model, 1.0f);
                modelPartConstraint.modelPartTransformation(modelMatrix.last().pose());
                Matrix4d partTransformation = new Matrix4d();
                partTransformation.set((Matrix4fc)modelMatrix.last().pose());
                simulation.getConstraints().clear();
                simulation.addConstraint(new OceanPhysicsDisplacementConstraint((Entity)player));
                simulation.addConstraint(modelPartConstraint);
                simulation.brightness = light;
                simulation.addCloth(cloth, cloth.getTexture((Entity)player), partTransformation, false);
                simulation.setOffset(new Vector3d(player.getX(), player.getY(), player.getZ()).add((Vector3dc)simulation.getOffset()), false);
                simulation.setTransformation(partTransformation);
                simulation.setBufferTransformation(partTransformation);
                simulation.updateOffsets();
                PhysicsWorld physicsWorld = PhysicsMod.getInstance((Level)level).physicsWorld;
                modelPartConstraint.initAsyncData(physicsWorld, simulation);
                modelPartConstraint.changeInstantly = true;
                modelPartConstraint.updateAfter(0.0, simulation);
                simulation.downloadData();
                simulation.alwaysFetchInstantly = alwaysInstantlyUpdate = player == Minecraft.getInstance().player;
                this.simulations.put(new PlayerLevelPacked(player.getGameProfile().getName(), player.getCommandSenderWorld()), simulation);
                if (alwaysInstantlyUpdate) {
                    physicsWorld.addVerletSimulation(0, simulation);
                } else {
                    physicsWorld.addVerletSimulation(simulation);
                }
            } else if (!simulation.destroyed) {
                simulation.active = true;
                simulation.brightness = light;
            }
            if (cloth != simulation.cloth) {
                simulation.destroyed = true;
            }
            PhysicsMod.dynamicCloth.computeIfAbsent(PhysicsMod.getRenderPass(), key -> new ObjectArrayList()).add(simulation);
        }
    }

    @Unique
    private boolean physicsmod$shouldRenderPhysicsElytra(AbstractClientPlayer player) {
        return !PhysicsMod.hudRendering && ConfigClient.capePhysics && player != null && !player.isInvisible() && !ConfigClient.clothForceArmor;
    }

    @Unique
    private boolean physicsmod$hasPhysicsElytra(AbstractClientPlayer player) {
        return ConfigCloth.hasCategory((Entity)player, "Elytra");
    }
}

