/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.ux;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import net.diebuddies.math.Math;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.diebuddies.physics.settings.ux.BaseColors;
import net.diebuddies.physics.settings.ux.GUIResources;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.ARGB;
import org.joml.Matrix4f;

public class ScrollAnimator
extends Animator {
    private Object2FloatMap<Animatable> baseOffsets;
    private float scrollOffset = 0.0f;
    private float oldScrollOffset;
    private float currentScrollOffset;
    private float minOffset;
    private float maxOffset;
    private float scrollSpeed = 40.0f;
    private float animationSpeed = 0.5f;
    private float screenHeight;
    private float arrowXPos;
    private float time;
    private int hoveredColor = BaseColors.HIGHLIGHT_COLOR;

    public ScrollAnimator(float minOffset, float maxOffset, float arrowXPos, float screenHeight) {
        this.minOffset = minOffset;
        this.maxOffset = maxOffset;
        this.screenHeight = screenHeight;
        this.arrowXPos = arrowXPos;
        this.baseOffsets = new Object2FloatLinkedOpenHashMap();
    }

    @Override
    public boolean render(Animatable animatable, GuiGraphics guiGraphics, int mouseX, int mouseY, float renderPercent, float delta) {
        this.baseOffsets.putIfAbsent((Object)animatable, animatable.getAnimY());
        float baseY = this.baseOffsets.getFloat((Object)animatable);
        animatable.setAnimY(baseY + org.joml.Math.lerp((float)this.oldScrollOffset, (float)this.currentScrollOffset, (float)renderPercent));
        Matrix4f pose = guiGraphics.pose().last().pose();
        if (animatable == this.baseOffsets.keySet().iterator().next()) {
            int color;
            boolean shadowOffset = true;
            this.time += delta;
            GlStateManager._enableDepthTest();
            GlStateManager._enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float width = 12.0f;
            float height = 12.0f;
            float x = this.arrowXPos - width * 0.5f + (float)shadowOffset;
            float y = this.screenHeight * 0.95f - height * 0.5f + (float)java.lang.Math.sin((double)this.time * 6.0) + (float)shadowOffset;
            float depth = 130.0f;
            if (this.scrollOffset - 0.01f >= this.minOffset) {
                color = ARGB.color((int)255, (int)0, (int)0, (int)0);
                Animator.drawRect(guiGraphics, GUIResources.ARROW, pose, x, y, width, height, depth, 0.0f, 1.0f, 0.0f, 1.0f, color);
                color = ARGB.color((int)255, (int)255, (int)255, (int)255);
                if (this.isOverBottomArrow(mouseX, mouseY)) {
                    color = this.hoveredColor;
                }
                Animator.drawRect(guiGraphics, GUIResources.ARROW, pose, x -= (float)shadowOffset, y -= (float)shadowOffset, width, height, depth, 0.0f, 1.0f, 0.0f, 1.0f, color);
            }
            if (this.scrollOffset + 0.01f <= this.maxOffset) {
                color = ARGB.color((int)255, (int)0, (int)0, (int)0);
                x = this.arrowXPos - width * 0.5f + (float)shadowOffset;
                y = this.screenHeight * 0.05f - height / 2.0f + (float)java.lang.Math.cos((double)this.time * 6.0) + (float)shadowOffset;
                Animator.drawRect(guiGraphics, GUIResources.ARROW, pose, x, y, width, height, depth, 0.0f, 1.0f, 1.0f, 0.0f, color);
                color = ARGB.color((int)255, (int)255, (int)255, (int)255);
                if (this.isOverTopArrow(mouseX, mouseY)) {
                    color = this.hoveredColor;
                }
                Animator.drawRect(guiGraphics, GUIResources.ARROW, pose, x -= (float)shadowOffset, y -= (float)shadowOffset, width, height, depth, 0.0f, 1.0f, 1.0f, 0.0f, color);
            }
            GlStateManager._disableBlend();
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseKey) {
        if (mouseKey == 0) {
            if (this.isOverBottomArrow(mouseX, mouseY)) {
                this.scroll(-2.0f);
                return true;
            }
            if (this.isOverTopArrow(mouseX, mouseY)) {
                this.scroll(2.0f);
                return true;
            }
        }
        return false;
    }

    private boolean isOverBottomArrow(double mouseX, double mouseY) {
        float width = 24.0f;
        float height = 16.0f;
        float x = this.arrowXPos - width * 0.5f;
        float y = this.screenHeight * 0.95f - height * 0.5f + (float)java.lang.Math.sin((double)this.time * 6.0);
        return mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + width) && mouseY < (double)(y + height);
    }

    private boolean isOverTopArrow(double mouseX, double mouseY) {
        float width = 24.0f;
        float height = 16.0f;
        float x = this.arrowXPos - width * 0.5f;
        float y = this.screenHeight * 0.05f - height * 0.5f + (float)java.lang.Math.sin((double)this.time * 6.0);
        return mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + width) && mouseY < (double)(y + height);
    }

    @Override
    public void tick(Animatable animatable) {
        if (this.baseOffsets.size() == 0 || animatable == this.baseOffsets.keySet().iterator().next()) {
            this.oldScrollOffset = this.currentScrollOffset;
            this.currentScrollOffset = org.joml.Math.lerp((float)this.currentScrollOffset, (float)this.scrollOffset, (float)this.animationSpeed);
        }
    }

    public void scroll(float scroll) {
        this.scrollOffset = Math.clamp(this.scrollOffset + scroll * this.scrollSpeed, this.minOffset, this.maxOffset);
    }

    public float getScrollSpeed() {
        return this.scrollSpeed;
    }

    public void setScrollSpeed(float scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    public void setMinOffset(float minOffset) {
        this.minOffset = minOffset;
    }

    public void setMaxOffset(float maxOffset) {
        this.maxOffset = maxOffset;
    }

    public float getMinOffset() {
        return this.minOffset;
    }

    public float getMaxOffset() {
        return this.maxOffset;
    }

    public void setAnimationSpeed(float animationSpeed) {
        this.animationSpeed = animationSpeed;
    }

    public float getAnimationSpeed() {
        return this.animationSpeed;
    }
}

