/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPass;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.render.MainRenderer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL20;

public class LiquidRenderer {
    private MainRenderer mainRenderer;
    private int mcEntityLocation = -1;
    private Matrix4d transformation = new Matrix4d();
    private Matrix4f localT = new Matrix4f();

    public LiquidRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void render(ClientLevel level, RenderType blockLayerIn, double xIn, double yIn, double zInm, Matrix4f viewMatrix, Matrix4f projectionMatrix) {
    }

    private void renderLiquid(RenderPass renderPass, PhysicsWorld physics, ClientLevel level, Matrix4fStack matrixStackIn, Vec3 view, Liquid liquid) {
        this.setupAttribute(this.mcEntityLocation, liquid.materialID, liquid.renderType, -1.0f, -1.0f);
        GlStateManager._enableCull();
        this.transformation.set((Matrix4dc)liquid.transformation);
        this.transformation.m30(this.transformation.m30() - view.x);
        this.transformation.m31(this.transformation.m31() - view.y);
        this.transformation.m32(this.transformation.m32() - view.z);
        float scale = 1.0f / (float)liquid.gridSize;
        this.transformation.scale((double)scale);
        matrixStackIn.pushMatrix();
        this.localT.set((Matrix4dc)this.transformation);
        matrixStackIn.mul((Matrix4fc)this.localT);
        if (level.effects().constantAmbientLight()) {
            RenderSystem.shaderLightDirections[0] = MainRenderer.NETHER_DIFFUSE_LIGHT_0;
            RenderSystem.shaderLightDirections[1] = MainRenderer.NETHER_DIFFUSE_LIGHT_1;
        } else {
            RenderSystem.shaderLightDirections[0] = MainRenderer.DIFFUSE_LIGHT_0;
            RenderSystem.shaderLightDirections[1] = MainRenderer.DIFFUSE_LIGHT_1;
        }
        RenderSystem.setShaderTexture((int)0, (GpuTexture)liquid.textureID);
        GlStateManager._activeTexture((int)33984);
        GlStateManager._bindTexture((int)((GlTexture)liquid.textureID).glId());
        ((GlTexture)liquid.textureID).flushModeChanges();
        this.mainRenderer.setupPBRTextures();
        GlProgram program = ((GlRenderPass)renderPass).pipeline.program();
        if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            if (program.LIGHT0_DIRECTION != null) {
                program.LIGHT0_DIRECTION.set(RenderSystem.shaderLightDirections[0]);
                program.LIGHT0_DIRECTION.upload();
            }
            if (program.LIGHT1_DIRECTION != null) {
                program.LIGHT1_DIRECTION.set(RenderSystem.shaderLightDirections[1]);
                program.LIGHT1_DIRECTION.upload();
            }
        }
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            Optifine.setModelViewMatrix(RenderSystem.getModelViewMatrix());
        } else {
            program.MODEL_VIEW_MATRIX.set(RenderSystem.getModelViewMatrix());
            program.MODEL_VIEW_MATRIX.upload();
            if (StarterClient.iris) {
                Iris.setNormalMatrix(renderPass, RenderSystem.getModelViewMatrix());
            }
        }
        liquid.vao.render();
        matrixStackIn.popMatrix();
    }

    public void setupAttribute(int location, float v0, float v1, float v2, float v3) {
        if (location != -1) {
            GL20.glVertexAttrib4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
        }
    }
}

