/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.liquid;

import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.liquid.LiquidController;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import org.joml.Random;

public class WaterController
implements LiquidController {
    private class_2338 pos;
    private class_238 aabb;
    private boolean continous;
    private int spawnAmount;
    private Random random;

    public WaterController(class_2338 pos, boolean continous, int spawnAmount) {
        this.continous = continous;
        this.spawnAmount = spawnAmount;
        this.pos = pos;
        this.aabb = new class_238(pos);
        this.random = new Random(System.nanoTime());
    }

    @Override
    public void init(PhysicsWorld world, Liquid liquid) {
        liquid.blockPos = this.pos;
        liquid.sourceAlive = this.continous;
        if (StarterClient.iris) {
            liquid.materialID = Iris.getMaterialID(class_2246.field_10382.method_9564());
        } else if (StarterClient.optifabric) {
            liquid.materialID = (short)Optifine.getMaterialID(class_2246.field_10382.method_9564());
        }
        for (int i = 0; i < this.spawnAmount; ++i) {
            int amount = ConfigClient.liquidCudaAmount * 16;
            double width = this.aabb.field_1320 - this.aabb.field_1323;
            double height = this.aabb.field_1325 - this.aabb.field_1322;
            double depth = this.aabb.field_1324 - this.aabb.field_1321;
            for (int j = 0; j < amount; ++j) {
                liquid.spawnParticle((double)this.random.nextFloat() * width + this.aabb.field_1323, (double)this.random.nextFloat() * height + this.aabb.field_1322, (double)this.random.nextFloat() * depth + this.aabb.field_1321);
            }
        }
    }

    @Override
    public void update(Liquid liquid, double diff) {
        if (StarterClient.iris) {
            liquid.materialID = Iris.getMaterialID(class_2246.field_10382.method_9564());
        } else if (StarterClient.optifabric) {
            liquid.materialID = (short)Optifine.getMaterialID(class_2246.field_10382.method_9564());
        }
        if (liquid.sourceAlive) {
            int amount = 4;
            amount = ConfigClient.cudaLiquids() ? (amount *= ConfigClient.liquidCudaAmount) : (amount *= ConfigClient.liquidAmount);
            double width = this.aabb.field_1320 - this.aabb.field_1323;
            double height = this.aabb.field_1325 - this.aabb.field_1322;
            double depth = this.aabb.field_1324 - this.aabb.field_1321;
            for (int i = 0; i < amount; ++i) {
                liquid.spawnParticle((double)this.random.nextFloat() * width + this.aabb.field_1323, (double)this.random.nextFloat() * height + this.aabb.field_1322, (double)this.random.nextFloat() * depth + this.aabb.field_1321);
            }
        }
    }
}

