/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.bridge;

import net.diebuddies.minecraft.weather.DustParticle;
import net.diebuddies.minecraft.weather.RainParticle;
import net.diebuddies.minecraft.weather.SnowParticle;
import net.diebuddies.mixins.MixinParticleResourcesAccessor;
import net.diebuddies.physics.ocean.ExplosionOceanSplashParticle;
import net.diebuddies.physics.ocean.OceanSplashParticle;
import net.diebuddies.physics.ocean.SmallOceanSplashParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleResources;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.Identifier;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class WeatherParticlesRegistry {
    public static final Identifier RAIN_RESOURCE = Identifier.fromNamespaceAndPath((String)"physicsmod", (String)"rain");
    public static final Identifier SNOW_RESOURCE = Identifier.fromNamespaceAndPath((String)"physicsmod", (String)"snow");
    public static final Identifier DUST_RESOURCE = Identifier.fromNamespaceAndPath((String)"physicsmod", (String)"dust");
    public static final Identifier SPLASH_RESOURCE = Identifier.fromNamespaceAndPath((String)"physicsmod", (String)"splash");
    public static final Identifier SPLASH_SMALL_RESOURCE = Identifier.fromNamespaceAndPath((String)"physicsmod", (String)"splash_small");
    public static final Identifier SPLASH_EXPLOSION_RESOURCE = Identifier.fromNamespaceAndPath((String)"physicsmod", (String)"splash_explosion");

    public static void register(FMLJavaModLoadingContext context) {
        RegisterParticleProvidersEvent.BUS.addListener(WeatherParticlesRegistry::registerParticles);
    }

    public static void registerParticles(RegisterParticleProvidersEvent event) {
        WeatherParticlesRegistry.registerSpriteSet(RAIN_RESOURCE, sprite -> new RainParticle.Provider(sprite));
        WeatherParticlesRegistry.registerSpriteSet(SNOW_RESOURCE, sprite -> new SnowParticle.Provider(sprite));
        WeatherParticlesRegistry.registerSpriteSet(DUST_RESOURCE, sprite -> new DustParticle.Provider(sprite));
        WeatherParticlesRegistry.registerSpriteSet(SPLASH_RESOURCE, sprite -> new OceanSplashParticle.Provider(sprite));
        WeatherParticlesRegistry.registerSpriteSet(SPLASH_SMALL_RESOURCE, sprite -> new SmallOceanSplashParticle.Provider(sprite));
        WeatherParticlesRegistry.registerSpriteSet(SPLASH_EXPLOSION_RESOURCE, sprite -> new ExplosionOceanSplashParticle.Provider(sprite));
    }

    private static <T extends ParticleOptions> void registerSpriteSet(Identifier resource, ParticleResources.SpriteParticleRegistration<T> registration) {
        MixinParticleResourcesAccessor particleEngine = (MixinParticleResourcesAccessor)Minecraft.getInstance().particleResources;
        ParticleResources.MutableSpriteSet spriteSet = new ParticleResources.MutableSpriteSet();
        particleEngine.getSpriteSets().put(resource, spriteSet);
        particleEngine.getParticleProviders().put(resource, registration.create((SpriteSet)spriteSet));
    }
}

