/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.compat;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.PBRDrawCall;
import net.diebuddies.render.shader.PhysicsShaderExtension;
import net.diebuddies.util.ShaderType;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.Config;
import net.optifine.shaders.BlockAliases;
import net.optifine.shaders.GlState;
import net.optifine.shaders.Program;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersFramebuffer;
import net.optifine.shaders.ShadersTex;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL32C;

public class Optifine {
    public static Program compilingProgram;
    public static Program oceanProgram;
    public static Program oceanShadowProgram;
    public static Program liquidProgram;
    public static Program liquidShadowProgram;
    public static Program smokeProgram;
    public static Program smokeShadowProgram;
    public static ShaderType compileStage;
    public static Matrix4f shadowView;
    private static Method setData;
    private static Method getProjectionMatrix;
    private static Field activeFramebufferField;
    private static Constructor<?> vertexFormatConstructor;
    private static RenderPipeline PHYSICS_SMOKE_PIPELINE_OPTIFINE;
    private static boolean init;
    private static int[] viewport;
    private static int drawFboBoundBefore;
    private static int readFboBoundBefore;
    private static ShadersFramebuffer framebuffer;

    public static boolean areShadersEnabled() {
        if (!Optifine.initMethods()) {
            return false;
        }
        try {
            return Config.isShaders();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static RenderPipeline getPhysicsVanillaSmokePipeline() {
        if (!Optifine.initMethods()) {
            return null;
        }
        if (PHYSICS_SMOKE_PIPELINE_OPTIFINE == null) {
            PHYSICS_SMOKE_PIPELINE_OPTIFINE = RenderPipelines.register((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withVertexShader(Identifier.fromNamespaceAndPath((String)"physicsmod", (String)"core/smoke")).withFragmentShader(Identifier.fromNamespaceAndPath((String)"physicsmod", (String)"core/smoke")).withLocation("pipeline/physics_smoke").withShaderDefine("ALPHA_CUTOUT", 0.001f).withShaderDefine("NO_OVERLAY").withCull(false).withVertexFormat(Optifine.createSmokeFormat(), VertexFormat.Mode.TRIANGLES).build());
        }
        return PHYSICS_SMOKE_PIPELINE_OPTIFINE;
    }

    private static VertexFormat createSmokeFormat() {
        if (!Optifine.initMethods()) {
            return null;
        }
        try {
            VertexFormatElement SMOKE_LIGHT = (VertexFormatElement)vertexFormatConstructor.newInstance(6, 0, VertexFormatElement.Type.BYTE, VertexFormatElement.Usage.POSITION, 4, null, 6);
            VertexFormatElement SMOKE_POS = (VertexFormatElement)vertexFormatConstructor.newInstance(7, 0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.POSITION, 4, null, 7);
            VertexFormatElement SMOKE_POS_NEW = (VertexFormatElement)vertexFormatConstructor.newInstance(8, 0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.POSITION, 4, null, 8);
            return VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).add("UV1", VertexFormatElement.UV1).add("UV2", VertexFormatElement.UV2).add("Normal", VertexFormatElement.NORMAL).padding(1).add("physics_light", SMOKE_LIGHT).add("physics_offset", SMOKE_POS).add("physics_offsetNew", SMOKE_POS_NEW).build();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isShadowPass() {
        if (!Optifine.initMethods()) {
            return false;
        }
        try {
            return Shaders.isShadowPass;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isUsingShadersNoInternal() {
        if (!Optifine.initMethods()) {
            return false;
        }
        try {
            return Shaders.uniform_modelViewMatrix.isDefined();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void setModelViewMatrix(Matrix4f modelViewMatrix) {
        if (!Optifine.initMethods()) {
            return;
        }
        try {
            Shaders.setModelViewMatrix((Matrix4f)modelViewMatrix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setProjectionMatrix(Matrix4f projectionMatrix) {
        if (!Optifine.initMethods()) {
            return;
        }
        try {
            Shaders.setProjectionMatrix((Matrix4f)projectionMatrix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setColorModulator(float[] colors) {
        if (!Optifine.initMethods()) {
            return;
        }
        try {
            Shaders.setColorModulator((float[])colors);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setDynamicTransforms(GpuBufferSlice slice) {
        if (!Optifine.initMethods()) {
            return;
        }
        try {
            Shaders.setDynamicTransforms((GpuBufferSlice)slice);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setGpuBufferSliceData(GpuBufferSlice slice, Object data) {
        if (!Optifine.initMethods()) {
            return;
        }
        try {
            setData.invoke((Object)slice, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setTextureMatrix(Matrix4f textureMatrix) {
        if (!Optifine.initMethods()) {
            return;
        }
        try {
            Shaders.setTextureMatrix((Matrix4f)textureMatrix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setNormalMatrix(Matrix3f normal) {
        if (!Optifine.initMethods()) {
            return;
        }
        try {
            if (Shaders.uniform_normalMatrix.isDefined()) {
                Shaders.uniform_normalMatrix.setValue(normal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean bindPBRTexture(PBRDrawCall drawCall) {
        if (!Optifine.initMethods()) {
            return false;
        }
        boolean isDefaultTexture = false;
        try {
            if (drawCall.texture != null) {
                ShadersTex.bindTexture((GlTexture)((GlTexture)drawCall.texture.texture()));
            } else {
                isDefaultTexture = true;
                ShadersTex.bindTexture((AbstractTexture)Shaders.defaultTexture);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDefaultTexture;
    }

    public static int getMaterialID(BlockState state) {
        if (!Optifine.initMethods()) {
            return -1;
        }
        try {
            return BlockAliases.getAliasBlockId((BlockState)state);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getRenderType(BlockState state) {
        if (!Optifine.initMethods()) {
            return -1;
        }
        try {
            return BlockAliases.getRenderType((BlockState)state);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void useEntityShader() {
        if (!Optifine.initMethods()) {
            return;
        }
        Shaders.useProgram((Program)Shaders.ProgramEntities);
    }

    public static void useOceanShader() {
        if (!Optifine.initMethods()) {
            return;
        }
        Shaders.useProgram((Program)oceanProgram);
    }

    public static void useOceanShadowShader() {
        if (!Optifine.initMethods()) {
            return;
        }
        boolean before = Shaders.isShadowPass;
        Shaders.isShadowPass = false;
        Shaders.useProgram((Program)oceanShadowProgram);
        Shaders.isShadowPass = before;
    }

    public static void useLiquidShader() {
        if (!Optifine.initMethods()) {
            return;
        }
        Shaders.useProgram((Program)liquidProgram);
    }

    public static void useLiquidShadowShader() {
        if (!Optifine.initMethods()) {
            return;
        }
        boolean before = Shaders.isShadowPass;
        Shaders.isShadowPass = false;
        Shaders.useProgram((Program)liquidShadowProgram);
        Shaders.isShadowPass = before;
    }

    public static void useSmokeShader() {
        if (!Optifine.initMethods()) {
            return;
        }
        Shaders.useProgram((Program)smokeProgram);
    }

    public static void useSmokeShadowShader() {
        if (!Optifine.initMethods()) {
            return;
        }
        boolean before = Shaders.isShadowPass;
        Shaders.isShadowPass = false;
        Shaders.useProgram((Program)smokeShadowProgram);
        Shaders.isShadowPass = before;
    }

    public static void useWaterShader() {
        if (!Optifine.initMethods()) {
            return;
        }
        Shaders.useProgram((Program)Shaders.ProgramWater);
    }

    public static PhysicsShaderExtension getActiveShaderExtension() {
        if (!Optifine.initMethods()) {
            return null;
        }
        return (PhysicsShaderExtension)Shaders.activeProgram;
    }

    public static void setShadowMatrices(MainRenderer mainRenderer) {
        if (!Optifine.initMethods()) {
            return;
        }
        try {
            Matrix4f projection = (Matrix4f)getProjectionMatrix.invoke(null, new Object[0]);
            mainRenderer.setMatrices(shadowView, projection);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void resetLastProgram() {
        if (!Optifine.initMethods()) {
            return;
        }
        Shaders.activeProgram = Shaders.ProgramNone;
        Shaders.activeProgramID = 0;
    }

    public static void storeFBOAndViewport() {
        if (!Optifine.initMethods()) {
            return;
        }
        drawFboBoundBefore = GL32C.glGetInteger((int)36006);
        readFboBoundBefore = GL32C.glGetInteger((int)36010);
        GL32C.glGetIntegerv((int)2978, (int[])viewport);
    }

    public static void restoreFBOAndViewport() {
        if (!Optifine.initMethods()) {
            return;
        }
        GlStateManager._glBindFramebuffer((int)36009, (int)drawFboBoundBefore);
        GlStateManager._glBindFramebuffer((int)36008, (int)readFboBoundBefore);
        GlStateManager._viewport((int)viewport[0], (int)viewport[1], (int)viewport[2], (int)viewport[3]);
    }

    public static void disableShaders() {
        if (!Optifine.initMethods()) {
            return;
        }
        framebuffer = GlState.getFramebuffer();
        try {
            activeFramebufferField.set(null, null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static int viewportWidth() {
        return viewport[2];
    }

    public static int viewportHeight() {
        return viewport[3];
    }

    public static void restoreShaders() {
        if (!Optifine.initMethods()) {
            return;
        }
        try {
            activeFramebufferField.set(null, framebuffer);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private static boolean initMethods() {
        if (!StarterClient.optifabric) {
            return false;
        }
        if (init) {
            return true;
        }
        init = true;
        try {
            Class<GpuBufferSlice> bufferSlice = GpuBufferSlice.class;
            setData = bufferSlice.getMethod("setData", Object.class);
            Class<RenderSystem> renderSystem = RenderSystem.class;
            getProjectionMatrix = renderSystem.getMethod("getProjectionMatrix", new Class[0]);
            Class<GlState> glState = GlState.class;
            activeFramebufferField = glState.getDeclaredField("activeFramebuffer");
            activeFramebufferField.setAccessible(true);
            Class<VertexFormatElement> vertexFormatElement = VertexFormatElement.class;
            vertexFormatConstructor = vertexFormatElement.getConstructor(Integer.TYPE, Integer.TYPE, VertexFormatElement.Type.class, VertexFormatElement.Usage.class, Integer.TYPE, String.class, Integer.TYPE);
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        return true;
    }

    static {
        shadowView = new Matrix4f();
        init = false;
        viewport = new int[4];
        framebuffer = null;
    }
}

