/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.diebuddies.compat.Optifine;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.render.DynamicUniformStorageExtension;
import net.minecraft.client.renderer.DynamicUniformStorage;
import net.minecraft.client.renderer.MappableRingBuffer;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={DynamicUniformStorage.class})
public class MixinDynamicUniformStorage
implements DynamicUniformStorageExtension {
    @Shadow
    @Final
    private int blockSize;
    @Shadow
    private MappableRingBuffer ringBuffer;
    @Shadow
    private int nextBlock;
    @Shadow
    private int capacity;
    @Shadow
    private DynamicUniformStorage.DynamicUniform lastUniform;
    @Shadow
    @Final
    private String label;

    @Shadow
    private void resizeBuffers(int i) {
    }

    @Override
    public <T> void physicsmod$writeUniforms(List<T> dynamicUniforms, Function<T, DynamicUniformStorage.DynamicUniform> getter, BiConsumer<T, GpuBufferSlice> setter) {
        int i;
        if (dynamicUniforms.size() == 0) {
            return;
        }
        if (this.nextBlock + dynamicUniforms.size() > this.capacity) {
            i = Mth.smallestEncompassingPowerOfTwo((int)Math.max(this.capacity + 1, dynamicUniforms.size()));
            LogUtils.getLogger().info("Resizing " + this.label + ", capacity limit of {} reached during a single frame. New capacity will be {}.", (Object)this.capacity, (Object)i);
            this.resizeBuffers(i);
        }
        i = this.nextBlock * this.blockSize;
        GpuBufferSlice[] gpuBufferSlices = new GpuBufferSlice[dynamicUniforms.size()];
        try (GpuBuffer.MappedView mappedView = RenderSystem.getDevice().createCommandEncoder().mapBuffer(this.ringBuffer.currentBuffer().slice((long)i, (long)(dynamicUniforms.size() * this.blockSize)), false, true);){
            ByteBuffer byteBuffer = mappedView.data();
            for (int j = 0; j < dynamicUniforms.size(); ++j) {
                T item = dynamicUniforms.get(j);
                DynamicUniformStorage.DynamicUniform dynamicUniform = getter.apply(item);
                GpuBufferSlice gpuBufferSlice = this.ringBuffer.currentBuffer().slice((long)(i + j * this.blockSize), (long)this.blockSize);
                if (StarterClient.optifabric) {
                    Optifine.setGpuBufferSliceData(gpuBufferSlice, dynamicUniform);
                }
                byteBuffer.position(j * this.blockSize);
                dynamicUniform.write(byteBuffer);
                setter.accept(item, gpuBufferSlice);
            }
        }
        this.nextBlock += dynamicUniforms.size();
        this.lastUniform = getter.apply(dynamicUniforms.get(dynamicUniforms.size() - 1));
    }
}

