/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.ARGB;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DummyVertexConsumer
implements VertexConsumer {
    public boolean trackVertices = false;
    private Vector3f tmpPos = new Vector3f();
    private Vector3f tmpNormal = new Vector3f();

    public DummyVertexConsumer(GpuTextureView gpuTexture) {
        PhysicsMod mod = PhysicsMod.getCurrentInstance();
        mod.itemStackEntity.models.get((int)0).textureID = gpuTexture;
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        return this;
    }

    public VertexConsumer setColor(int red, int green, int blue, int alpha) {
        return this;
    }

    public VertexConsumer setUv(float u, float v) {
        return this;
    }

    public VertexConsumer setUv1(int u, int v) {
        return this;
    }

    public VertexConsumer setUv2(int u, int v) {
        return this;
    }

    public VertexConsumer setNormal(float x, float y, float z) {
        return this;
    }

    public void putBulkData(PoseStack.Pose pose, BakedQuad quad, float[] brightness, float red, float green, float blue, float alpha, int[] lights, int overlay) {
        if (!this.trackVertices) {
            return;
        }
        PhysicsMod mod = PhysicsMod.getCurrentInstance();
        Mesh mesh = mod.itemStackEntity.models.get((int)0).mesh;
        Vector3fc direction = quad.direction().getUnitVec3f();
        Matrix4f matrix4f = pose.pose();
        pose.transformNormal(direction, this.tmpNormal);
        for (int l = 0; l < 4; ++l) {
            Vector3fc quadPos = quad.position(l);
            long packedUv = quad.packedUV(l);
            float b = brightness[l];
            matrix4f.transformPosition(quadPos, this.tmpPos);
            float u = UVPair.unpackU((long)packedUv);
            float v = UVPair.unpackV((long)packedUv);
            mesh.positions.add(new Vector3f(this.tmpPos.x(), this.tmpPos.y(), this.tmpPos.z()));
            mesh.addColor(b * red, b * green, b * blue);
            mesh.normals.add(new Vector3f(this.tmpNormal.x(), this.tmpNormal.y(), this.tmpNormal.z()));
            mesh.uvs.add(new Vector2f(u, v));
        }
        int index = mesh.positions.size() - 4;
        mesh.indices.add(index);
        mesh.indices.add(index + 1);
        mesh.indices.add(index + 2);
        mesh.indices.add(index);
        mesh.indices.add(index + 2);
        mesh.indices.add(index + 3);
        mod.itemStackEntity.feature = mod.blockifyFeature;
        mod.itemStackEntity.shade = quad.shade();
    }

    public void addVertex(float x, float y, float z, int color, float u, float v, int overlay, int light, float normalX, float normalY, float normalZ) {
        if (!this.trackVertices) {
            return;
        }
        PhysicsMod mod = PhysicsMod.getCurrentInstance();
        Mesh mesh = mod.itemStackEntity.models.get((int)0).mesh;
        mesh.positions.add(new Vector3f(x, y, z));
        mesh.addColor((float)ARGB.red((int)color) / 255.0f, (float)ARGB.green((int)color) / 255.0f, (float)ARGB.blue((int)color) / 255.0f, (float)ARGB.alpha((int)color) / 255.0f);
        mesh.normals.add(new Vector3f(normalX, normalY, normalZ));
        mesh.uvs.add(new Vector2f(u, v));
        int index = mesh.positions.size() - 1;
        mesh.indices.add(index);
    }

    public VertexConsumer addVertex(Matrix4fc matrix, float x, float y, float z) {
        return this;
    }

    public VertexConsumer setNormal(PoseStack.Pose matrix, float x, float y, float z) {
        return this;
    }

    public VertexConsumer setColor(float red, float green, float blue, float alpha) {
        return this;
    }

    public VertexConsumer setLight(int uv) {
        return this;
    }

    public VertexConsumer setOverlay(int uv) {
        return this;
    }

    public VertexConsumer setColor(int color) {
        return this;
    }

    public VertexConsumer setLineWidth(float f) {
        return this;
    }
}

