/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.ux;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.BlitFloatRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public abstract class Animator {
    public boolean render(Animatable animatable, GuiGraphics guiGraphics, int mouseX, int mouseY, float renderPercent, float delta) {
        return false;
    }

    public boolean renderToolTip(Animatable animatable, GuiGraphics guiGraphics, int mouseX, int mouseY, float renderPercent) {
        return false;
    }

    public void tick(Animatable animatable) {
    }

    public void init(Animatable animatable) {
    }

    public static final void drawRect(GuiGraphics guiGraphics, float x, float y, float width, float height, float depth, int color) {
        guiGraphics.fill((int)x, (int)y, (int)(x + width), (int)(y + height), color);
    }

    public static final void drawLine(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, float depth, int color) {
        guiGraphics.fill((int)x1, (int)y1, (int)x2 + 1, (int)y2 + 1, color);
    }

    public static final void drawRect(GuiGraphics guiGraphics, Identifier image, float x, float y, float width, float height, float depth, float umin, float umax, float vmin, float vmax, int color) {
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(image);
        GpuTextureView gpuTexture = texture.getTextureView();
        GpuSampler gpuSampler = texture.getSampler();
        Animator.drawRect(guiGraphics, gpuTexture, gpuSampler, x, y, width, height, depth, umin, umax, vmin, vmax, color);
    }

    public static final void drawRect(GuiGraphics guiGraphics, GpuTextureView image, GpuSampler sampler, float x, float y, float width, float height, float depth, float umin, float umax, float vmin, float vmax, int color) {
        Animator.drawRect(guiGraphics, image, sampler, x, y, width, height, depth, umin, umax, vmin, vmax, color, () -> {});
    }

    public static final void drawRect(GuiGraphics guiGraphics, GpuTextureView image, GpuSampler sampler, float x, float y, float width, float height, float depth, float umin, float umax, float vmin, float vmax, int color, Runnable custom) {
        Animator.submitBlit(guiGraphics, RenderPipelines.GUI_TEXTURED, image, sampler, x, y, x + width, y + height, umin, umax, vmin, vmax, color, custom);
    }

    private static void submitBlit(GuiGraphics guiGraphics, RenderPipeline renderPipeline, GpuTextureView gpuTexture, GpuSampler sampler, float i, float j, float k, float l, float f, float g, float h, float m, int n, Runnable custom) {
        guiGraphics.guiRenderState.submitGuiElement((GuiElementRenderState)new BlitFloatRenderState(renderPipeline, TextureSetup.singleTexture((GpuTextureView)gpuTexture, (GpuSampler)sampler), new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), i, j, k, l, f, g, h, m, n, guiGraphics.scissorStack.peek(), custom));
    }

    public static final void drawText(GuiGraphics guiGraphics, Font font, FormattedCharSequence formattedCharSequence, float x, float y) {
        guiGraphics.drawString(font, formattedCharSequence, (int)x + 1, (int)y + 1, ARGB.color((int)255, (int)0, (int)0, (int)0), false);
        guiGraphics.drawString(font, formattedCharSequence, (int)x, (int)y, ARGB.color((int)255, (int)255, (int)255, (int)255), false);
    }
}

